/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.arlington;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSBase;
import org.verapdf.cos.COSDictionary;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.gf.model.impl.arlington.GFACryptFilterMap;
import org.verapdf.gf.model.impl.arlington.GFAObject;
import org.verapdf.gf.model.impl.containers.StaticContainers;
import org.verapdf.model.alayer.ACryptFilterMap;
import org.verapdf.model.alayer.AEncryptionStandard;
import org.verapdf.model.baselayer.Object;

public class GFAEncryptionStandard
extends GFAObject
implements AEncryptionStandard {
    public GFAEncryptionStandard(COSBase baseObject, COSBase parentObject, String keyName) {
        super(baseObject, parentObject, keyName, "AEncryptionStandard");
    }

    public List<? extends Object> getLinkedObjects(String link) {
        switch (link) {
            case "CF": {
                return this.getCF();
            }
        }
        return super.getLinkedObjects(link);
    }

    private List<ACryptFilterMap> getCF() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return this.getCF1_5();
            }
        }
        return Collections.emptyList();
    }

    private List<ACryptFilterMap> getCF1_5() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"CF"));
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_DICT) {
            ArrayList<GFACryptFilterMap> list = new ArrayList<GFACryptFilterMap>(1);
            list.add(new GFACryptFilterMap((COSBase)((COSDictionary)object.getDirectBase()), this.baseObject, "CF"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    public Boolean getcontainsCF() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"CF"));
    }

    public Boolean getCFHasTypeDictionary() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"CF"));
        return object != null && object.getType() == COSObjType.COS_DICT;
    }

    public Boolean getcontainsEFF() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"EFF"));
    }

    public Boolean getEFFHasTypeName() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"EFF"));
        return object != null && object.getType() == COSObjType.COS_NAME;
    }

    public Boolean getcontainsEncryptMetadata() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"EncryptMetadata"));
    }

    public Boolean getEncryptMetadataHasTypeBoolean() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"EncryptMetadata"));
        return object != null && object.getType() == COSObjType.COS_BOOLEAN;
    }

    public Boolean getcontainsFilter() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"Filter"));
    }

    public Boolean getFilterHasTypeName() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Filter"));
        return object != null && object.getType() == COSObjType.COS_NAME;
    }

    public String getFilterNameValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Filter"));
        if (object == null || object.empty()) {
            return this.getFilterNameDefaultValue();
        }
        if (object != null && object.getType() == COSObjType.COS_NAME) {
            return object.getString();
        }
        return null;
    }

    public String getFilterNameDefaultValue() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: 
            case ARLINGTON2_0: 
            case ARLINGTON1_1: 
            case ARLINGTON1_2: 
            case ARLINGTON1_3: 
            case ARLINGTON1_4: {
                return "Standard";
            }
        }
        return null;
    }

    public Boolean getcontainsKDFSalt() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"KDFSalt"));
    }

    public Boolean getisKDFSaltIndirect() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"KDFSalt"));
        return object != null && object.get() != null && object.get().isIndirect() != false;
    }

    public Boolean getKDFSaltHasTypeStringByte() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"KDFSalt"));
        return object != null && object.getType() == COSObjType.COS_STRING;
    }

    public Boolean getcontainsLength() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"Length"));
    }

    public Boolean getLengthHasTypeInteger() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Length"));
        return object != null && object.getType() == COSObjType.COS_INTEGER;
    }

    public Long getLengthIntegerValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Length"));
        if (object == null || object.empty()) {
            return this.getLengthIntegerDefaultValue();
        }
        if (object != null && object.getType() == COSObjType.COS_INTEGER) {
            return object.getInteger();
        }
        return null;
    }

    public Long getLengthIntegerDefaultValue() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: 
            case ARLINGTON2_0: 
            case ARLINGTON1_4: {
                return 40L;
            }
        }
        return null;
    }

    public Boolean getcontainsO() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"O"));
    }

    public Boolean getOHasTypeStringByte() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"O"));
        return object != null && object.getType() == COSObjType.COS_STRING;
    }

    public Long getOStringSize() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"O"));
        if (object != null && object.getType() == COSObjType.COS_STRING) {
            return object.getString().length();
        }
        return null;
    }

    public Boolean getcontainsOE() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"OE"));
    }

    public Boolean getOEHasTypeStringByte() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"OE"));
        return object != null && object.getType() == COSObjType.COS_STRING;
    }

    public Long getOEStringSize() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"OE"));
        if (object != null && object.getType() == COSObjType.COS_STRING) {
            return object.getString().length();
        }
        return null;
    }

    public Boolean getcontainsP() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"P"));
    }

    public Boolean getPHasTypeBitmask() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"P"));
        return object != null && object.getType() == COSObjType.COS_INTEGER;
    }

    public Long getPBitmaskValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"P"));
        if (object == null || object.empty()) {
            return this.getPBitmaskDefaultValue();
        }
        if (object != null && object.getType() == COSObjType.COS_INTEGER) {
            return object.getInteger();
        }
        return null;
    }

    public Long getPBitmaskDefaultValue() {
        return null;
    }

    public Boolean getcontainsPerms() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"Perms"));
    }

    public Boolean getPermsHasTypeStringByte() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Perms"));
        return object != null && object.getType() == COSObjType.COS_STRING;
    }

    public Boolean getcontainsR() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"R"));
    }

    public Boolean getRHasTypeInteger() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"R"));
        return object != null && object.getType() == COSObjType.COS_INTEGER;
    }

    public Long getRIntegerValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"R"));
        if (object == null || object.empty()) {
            return this.getRIntegerDefaultValue();
        }
        if (object != null && object.getType() == COSObjType.COS_INTEGER) {
            return object.getInteger();
        }
        return null;
    }

    public Long getRIntegerDefaultValue() {
        return null;
    }

    public Boolean getcontainsStmF() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"StmF"));
    }

    public Boolean getStmFHasTypeName() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"StmF"));
        return object != null && object.getType() == COSObjType.COS_NAME;
    }

    public Boolean getcontainsStrF() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"StrF"));
    }

    public Boolean getStrFHasTypeName() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"StrF"));
        return object != null && object.getType() == COSObjType.COS_NAME;
    }

    public Boolean getcontainsSubFilter() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"SubFilter"));
    }

    public Boolean getSubFilterHasTypeName() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"SubFilter"));
        return object != null && object.getType() == COSObjType.COS_NAME;
    }

    public Boolean getcontainsU() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"U"));
    }

    public Boolean getUHasTypeStringByte() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"U"));
        return object != null && object.getType() == COSObjType.COS_STRING;
    }

    public Long getUStringSize() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"U"));
        if (object != null && object.getType() == COSObjType.COS_STRING) {
            return object.getString().length();
        }
        return null;
    }

    public Boolean getcontainsUE() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"UE"));
    }

    public Boolean getUEHasTypeStringByte() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"UE"));
        return object != null && object.getType() == COSObjType.COS_STRING;
    }

    public Boolean getcontainsV() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"V"));
    }

    public Boolean getVHasTypeInteger() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"V"));
        return object != null && object.getType() == COSObjType.COS_INTEGER;
    }

    public Long getVIntegerValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"V"));
        if (object == null || object.empty()) {
            return this.getVIntegerDefaultValue();
        }
        if (object != null && object.getType() == COSObjType.COS_INTEGER) {
            return object.getInteger();
        }
        return null;
    }

    public Long getVIntegerDefaultValue() {
        return null;
    }

    public Boolean gethasExtensionADBE_Extn3() {
        return false;
    }

    public Boolean gethasExtensionISO_TS_32004() {
        return false;
    }
}

