/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.arlington;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSBase;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.gf.model.impl.arlington.GFA3DMeasure3DC;
import org.verapdf.gf.model.impl.arlington.GFA3DMeasureAD3;
import org.verapdf.gf.model.impl.arlington.GFA3DMeasureLD3;
import org.verapdf.gf.model.impl.arlington.GFA3DMeasurePD3;
import org.verapdf.gf.model.impl.arlington.GFA3DMeasureRD3;
import org.verapdf.gf.model.impl.arlington.GFAObject;
import org.verapdf.gf.model.impl.containers.StaticContainers;
import org.verapdf.model.alayer.AExDataProjection;
import org.verapdf.model.baselayer.Object;

public class GFAExDataProjection
extends GFAObject
implements AExDataProjection {
    public GFAExDataProjection(COSBase baseObject, COSBase parentObject, String keyName) {
        super(baseObject, parentObject, keyName, "AExDataProjection");
    }

    public List<? extends Object> getLinkedObjects(String link) {
        switch (link) {
            case "M3DREF": {
                return this.getM3DREF();
            }
        }
        return super.getLinkedObjects(link);
    }

    private List<Object> getM3DREF() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return this.getM3DREF1_7();
            }
        }
        return Collections.emptyList();
    }

    private List<Object> getM3DREF1_7() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"M3DREF"));
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_DICT) {
            Object result = this.getM3DREFDictionary1_7(object.getDirectBase(), "M3DREF");
            ArrayList<Object> list = new ArrayList<Object>(1);
            if (result != null) {
                list.add(result);
            }
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private Object getM3DREFDictionary1_7(COSBase base, String keyName) {
        COSObject subtype = base.getKey(ASAtom.getASAtom((String)"Subtype"));
        if (subtype == null) {
            return null;
        }
        String subtypeValue = subtype.getString();
        if (subtypeValue == null) {
            return null;
        }
        switch (subtypeValue) {
            case "AD3": {
                return new GFA3DMeasureAD3(base, this.baseObject, keyName);
            }
            case "RD3": {
                return new GFA3DMeasureRD3(base, this.baseObject, keyName);
            }
            case "3DC": {
                return new GFA3DMeasure3DC(base, this.baseObject, keyName);
            }
            case "LD3": {
                return new GFA3DMeasureLD3(base, this.baseObject, keyName);
            }
            case "PD3": {
                return new GFA3DMeasurePD3(base, this.baseObject, keyName);
            }
        }
        return null;
    }

    public Boolean getcontainsM3DREF() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"M3DREF"));
    }

    public Boolean getisM3DREFIndirect() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"M3DREF"));
        return object != null && object.get() != null && object.get().isIndirect() != false;
    }

    public Boolean getM3DREFHasTypeDictionary() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"M3DREF"));
        return object != null && object.getType() == COSObjType.COS_DICT;
    }

    public Boolean getcontainsSubtype() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"Subtype"));
    }

    public Boolean getSubtypeHasTypeName() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Subtype"));
        return object != null && object.getType() == COSObjType.COS_NAME;
    }

    public String getSubtypeNameValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Subtype"));
        if (object == null || object.empty()) {
            return this.getSubtypeNameDefaultValue();
        }
        if (object != null && object.getType() == COSObjType.COS_NAME) {
            return object.getString();
        }
        return null;
    }

    public String getSubtypeNameDefaultValue() {
        return null;
    }

    public Boolean getcontainsType() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"Type"));
    }

    public Boolean getTypeHasTypeName() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Type"));
        return object != null && object.getType() == COSObjType.COS_NAME;
    }

    public String getTypeNameValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Type"));
        if (object == null || object.empty()) {
            return this.getTypeNameDefaultValue();
        }
        if (object != null && object.getType() == COSObjType.COS_NAME) {
            return object.getString();
        }
        return null;
    }

    public String getTypeNameDefaultValue() {
        return null;
    }
}

