/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.arlington;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSArray;
import org.verapdf.cos.COSBase;
import org.verapdf.cos.COSDictionary;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.cos.COSStream;
import org.verapdf.gf.model.impl.arlington.GFAObject;
import org.verapdf.gf.model.impl.arlington.GFAStream;
import org.verapdf.gf.model.impl.arlington.GFA_UniversalArray;
import org.verapdf.gf.model.impl.arlington.GFA_UniversalDictionary;
import org.verapdf.gf.model.impl.containers.StaticContainers;
import org.verapdf.model.alayer.ASignatureReferenceIdentity;
import org.verapdf.model.baselayer.Object;

public class GFASignatureReferenceIdentity
extends GFAObject
implements ASignatureReferenceIdentity {
    public GFASignatureReferenceIdentity(COSBase baseObject, COSBase parentObject, String keyName) {
        super(baseObject, parentObject, keyName, "ASignatureReferenceIdentity");
    }

    public List<? extends Object> getLinkedObjects(String link) {
        switch (link) {
            case "Data": {
                return this.getData();
            }
        }
        return super.getLinkedObjects(link);
    }

    private List<Object> getData() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return this.getData1_5();
            }
        }
        return Collections.emptyList();
    }

    private List<Object> getData1_5() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Data"));
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_ARRAY) {
            ArrayList<GFA_UniversalArray> list = new ArrayList<GFA_UniversalArray>(1);
            list.add(new GFA_UniversalArray((COSBase)((COSArray)object.getDirectBase()), this.baseObject, "Data"));
            return Collections.unmodifiableList(list);
        }
        if (object.getType() == COSObjType.COS_STREAM) {
            ArrayList<GFAStream> list = new ArrayList<GFAStream>(1);
            list.add(new GFAStream((COSBase)((COSStream)object.getDirectBase()), this.baseObject, "Data"));
            return Collections.unmodifiableList(list);
        }
        if (object.getType() == COSObjType.COS_DICT) {
            ArrayList<GFA_UniversalDictionary> list = new ArrayList<GFA_UniversalDictionary>(1);
            list.add(new GFA_UniversalDictionary((COSBase)((COSDictionary)object.getDirectBase()), this.baseObject, "Data"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    public Boolean getcontainsData() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"Data"));
    }

    public Boolean getisDataIndirect() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Data"));
        return object != null && object.get() != null && object.get().isIndirect() != false;
    }

    public Boolean getDataHasTypeArray() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Data"));
        return object != null && object.getType() == COSObjType.COS_ARRAY;
    }

    public Boolean getDataHasTypeStream() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Data"));
        return object != null && object.getType() == COSObjType.COS_STREAM;
    }

    public Boolean getDataHasTypeBoolean() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Data"));
        return object != null && object.getType() == COSObjType.COS_BOOLEAN;
    }

    public Boolean getDataHasTypeString() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Data"));
        return object != null && object.getType() == COSObjType.COS_STRING;
    }

    public Boolean getDataHasTypeInteger() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Data"));
        return object != null && object.getType() == COSObjType.COS_INTEGER;
    }

    public Boolean getDataHasTypeName() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Data"));
        return object != null && object.getType() == COSObjType.COS_NAME;
    }

    public Boolean getDataHasTypeDictionary() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Data"));
        return object != null && object.getType() == COSObjType.COS_DICT;
    }

    public Boolean getcontainsDigestMethod() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"DigestMethod"));
    }

    public Boolean getDigestMethodHasTypeName() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"DigestMethod"));
        return object != null && object.getType() == COSObjType.COS_NAME;
    }

    public String getDigestMethodNameValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"DigestMethod"));
        if (object == null || object.empty()) {
            return this.getDigestMethodNameDefaultValue();
        }
        if (object != null && object.getType() == COSObjType.COS_NAME) {
            return object.getString();
        }
        return null;
    }

    public String getDigestMethodNameDefaultValue() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON2_0: {
                return this.gethasExtensionISO_TS_32001() != false ? "SHA256" : null;
            }
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: {
                return "MD5";
            }
        }
        return null;
    }

    public Boolean getcontainsTransformMethod() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"TransformMethod"));
    }

    public Boolean getTransformMethodHasTypeName() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"TransformMethod"));
        return object != null && object.getType() == COSObjType.COS_NAME;
    }

    public String getTransformMethodNameValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"TransformMethod"));
        if (object == null || object.empty()) {
            return this.getTransformMethodNameDefaultValue();
        }
        if (object != null && object.getType() == COSObjType.COS_NAME) {
            return object.getString();
        }
        return null;
    }

    public String getTransformMethodNameDefaultValue() {
        return null;
    }

    public Boolean getcontainsType() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"Type"));
    }

    public Boolean getTypeHasTypeName() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Type"));
        return object != null && object.getType() == COSObjType.COS_NAME;
    }

    public String getTypeNameValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Type"));
        if (object == null || object.empty()) {
            return this.getTypeNameDefaultValue();
        }
        if (object != null && object.getType() == COSObjType.COS_NAME) {
            return object.getString();
        }
        return null;
    }

    public String getTypeNameDefaultValue() {
        return null;
    }

    public Boolean gethasExtensionISO_TS_32001() {
        return false;
    }
}

