/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.arlington;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSArray;
import org.verapdf.cos.COSBase;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.cos.COSString;
import org.verapdf.gf.model.impl.arlington.GFAArrayOfStringsASCII;
import org.verapdf.gf.model.impl.arlington.GFAArrayOfStringsByte;
import org.verapdf.gf.model.impl.arlington.GFAArrayOfSubjectDN;
import org.verapdf.gf.model.impl.arlington.GFAObject;
import org.verapdf.gf.model.impl.containers.StaticContainers;
import org.verapdf.model.alayer.AArrayOfStringsASCII;
import org.verapdf.model.alayer.AArrayOfStringsByte;
import org.verapdf.model.alayer.AArrayOfSubjectDN;
import org.verapdf.model.alayer.ACertSeedValue;
import org.verapdf.model.baselayer.Object;

public class GFACertSeedValue
extends GFAObject
implements ACertSeedValue {
    public GFACertSeedValue(COSBase baseObject, COSBase parentObject, String keyName) {
        super(baseObject, parentObject, keyName, "ACertSeedValue");
    }

    public List<? extends Object> getLinkedObjects(String link) {
        switch (link) {
            case "Issuer": {
                return this.getIssuer();
            }
            case "KeyUsage": {
                return this.getKeyUsage();
            }
            case "OID": {
                return this.getOID();
            }
            case "SignaturePolicyCommitmentType": {
                return this.getSignaturePolicyCommitmentType();
            }
            case "Subject": {
                return this.getSubject();
            }
            case "SubjectDN": {
                return this.getSubjectDN();
            }
        }
        return super.getLinkedObjects(link);
    }

    private List<AArrayOfStringsByte> getIssuer() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return this.getIssuer1_5();
            }
        }
        return Collections.emptyList();
    }

    private List<AArrayOfStringsByte> getIssuer1_5() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Issuer"));
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_ARRAY) {
            ArrayList<GFAArrayOfStringsByte> list = new ArrayList<GFAArrayOfStringsByte>(1);
            list.add(new GFAArrayOfStringsByte((COSBase)((COSArray)object.getDirectBase()), this.baseObject, "Issuer"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<AArrayOfStringsASCII> getKeyUsage() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return this.getKeyUsage1_7();
            }
        }
        return Collections.emptyList();
    }

    private List<AArrayOfStringsASCII> getKeyUsage1_7() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"KeyUsage"));
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_ARRAY) {
            ArrayList<GFAArrayOfStringsASCII> list = new ArrayList<GFAArrayOfStringsASCII>(1);
            list.add(new GFAArrayOfStringsASCII((COSBase)((COSArray)object.getDirectBase()), this.baseObject, "KeyUsage"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<AArrayOfStringsByte> getOID() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return this.getOID1_5();
            }
        }
        return Collections.emptyList();
    }

    private List<AArrayOfStringsByte> getOID1_5() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"OID"));
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_ARRAY) {
            ArrayList<GFAArrayOfStringsByte> list = new ArrayList<GFAArrayOfStringsByte>(1);
            list.add(new GFAArrayOfStringsByte((COSBase)((COSArray)object.getDirectBase()), this.baseObject, "OID"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<AArrayOfStringsASCII> getSignaturePolicyCommitmentType() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON2_0: {
                return this.getSignaturePolicyCommitmentType2_0();
            }
        }
        return Collections.emptyList();
    }

    private List<AArrayOfStringsASCII> getSignaturePolicyCommitmentType2_0() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"SignaturePolicyCommitmentType"));
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_ARRAY) {
            ArrayList<GFAArrayOfStringsASCII> list = new ArrayList<GFAArrayOfStringsASCII>(1);
            list.add(new GFAArrayOfStringsASCII((COSBase)((COSArray)object.getDirectBase()), this.baseObject, "SignaturePolicyCommitmentType"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<AArrayOfStringsByte> getSubject() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return this.getSubject1_5();
            }
        }
        return Collections.emptyList();
    }

    private List<AArrayOfStringsByte> getSubject1_5() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Subject"));
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_ARRAY) {
            ArrayList<GFAArrayOfStringsByte> list = new ArrayList<GFAArrayOfStringsByte>(1);
            list.add(new GFAArrayOfStringsByte((COSBase)((COSArray)object.getDirectBase()), this.baseObject, "Subject"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<AArrayOfSubjectDN> getSubjectDN() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return this.getSubjectDN1_7();
            }
        }
        return Collections.emptyList();
    }

    private List<AArrayOfSubjectDN> getSubjectDN1_7() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"SubjectDN"));
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_ARRAY) {
            ArrayList<GFAArrayOfSubjectDN> list = new ArrayList<GFAArrayOfSubjectDN>(1);
            list.add(new GFAArrayOfSubjectDN((COSBase)((COSArray)object.getDirectBase()), this.baseObject, "SubjectDN"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    public Boolean getcontainsFf() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"Ff"));
    }

    public Boolean getFfHasTypeBitmask() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Ff"));
        return object != null && object.getType() == COSObjType.COS_INTEGER;
    }

    public Long getFfBitmaskValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Ff"));
        if (object == null || object.empty()) {
            return this.getFfBitmaskDefaultValue();
        }
        if (object != null && object.getType() == COSObjType.COS_INTEGER) {
            return object.getInteger();
        }
        return null;
    }

    public Long getFfBitmaskDefaultValue() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return 0L;
            }
        }
        return null;
    }

    public Boolean getcontainsIssuer() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"Issuer"));
    }

    public Boolean getIssuerHasTypeArray() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Issuer"));
        return object != null && object.getType() == COSObjType.COS_ARRAY;
    }

    public Boolean getcontainsKeyUsage() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"KeyUsage"));
    }

    public Boolean getKeyUsageHasTypeArray() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"KeyUsage"));
        return object != null && object.getType() == COSObjType.COS_ARRAY;
    }

    public Boolean getcontainsOID() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"OID"));
    }

    public Boolean getOIDHasTypeArray() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"OID"));
        return object != null && object.getType() == COSObjType.COS_ARRAY;
    }

    public Boolean getcontainsSignaturePolicyCommitmentType() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"SignaturePolicyCommitmentType"));
    }

    public Boolean getSignaturePolicyCommitmentTypeHasTypeArray() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"SignaturePolicyCommitmentType"));
        return object != null && object.getType() == COSObjType.COS_ARRAY;
    }

    public Boolean getcontainsSignaturePolicyHashAlgorithm() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"SignaturePolicyHashAlgorithm"));
    }

    public Boolean getSignaturePolicyHashAlgorithmHasTypeName() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"SignaturePolicyHashAlgorithm"));
        return object != null && object.getType() == COSObjType.COS_NAME;
    }

    public String getSignaturePolicyHashAlgorithmNameValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"SignaturePolicyHashAlgorithm"));
        if (object == null || object.empty()) {
            return this.getSignaturePolicyHashAlgorithmNameDefaultValue();
        }
        if (object != null && object.getType() == COSObjType.COS_NAME) {
            return object.getString();
        }
        return null;
    }

    public String getSignaturePolicyHashAlgorithmNameDefaultValue() {
        return null;
    }

    public Boolean getcontainsSignaturePolicyHashValue() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"SignaturePolicyHashValue"));
    }

    public Boolean getSignaturePolicyHashValueHasTypeString() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"SignaturePolicyHashValue"));
        return object != null && object.getType() == COSObjType.COS_STRING;
    }

    public Boolean getcontainsSignaturePolicyOID() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"SignaturePolicyOID"));
    }

    public Boolean getSignaturePolicyOIDHasTypeStringAscii() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"SignaturePolicyOID"));
        return object != null && object.getType() == COSObjType.COS_STRING && ((COSString)object.getDirectBase()).isASCIIString();
    }

    public Boolean getcontainsSubject() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"Subject"));
    }

    public Boolean getSubjectHasTypeArray() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Subject"));
        return object != null && object.getType() == COSObjType.COS_ARRAY;
    }

    public Boolean getcontainsSubjectDN() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"SubjectDN"));
    }

    public Boolean getSubjectDNHasTypeArray() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"SubjectDN"));
        return object != null && object.getType() == COSObjType.COS_ARRAY;
    }

    public Boolean getcontainsType() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"Type"));
    }

    public Boolean getTypeHasTypeName() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Type"));
        return object != null && object.getType() == COSObjType.COS_NAME;
    }

    public String getTypeNameValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Type"));
        if (object == null || object.empty()) {
            return this.getTypeNameDefaultValue();
        }
        if (object != null && object.getType() == COSObjType.COS_NAME) {
            return object.getString();
        }
        return null;
    }

    public String getTypeNameDefaultValue() {
        return null;
    }

    public Boolean getcontainsURL() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"URL"));
    }

    public Boolean getURLHasTypeStringAscii() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"URL"));
        return object != null && object.getType() == COSObjType.COS_STRING && ((COSString)object.getDirectBase()).isASCIIString();
    }

    public Boolean getcontainsURLType() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"URLType"));
    }

    public Boolean getURLTypeHasTypeName() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"URLType"));
        return object != null && object.getType() == COSObjType.COS_NAME;
    }

    public String getURLTypeNameValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"URLType"));
        if (object == null || object.empty()) {
            return this.getURLTypeNameDefaultValue();
        }
        if (object != null && object.getType() == COSObjType.COS_NAME) {
            return object.getString();
        }
        return null;
    }

    public String getURLTypeNameDefaultValue() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return "Browser";
            }
        }
        return null;
    }
}

