/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.arlington;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSBase;
import org.verapdf.cos.COSDictionary;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.cos.COSString;
import org.verapdf.gf.model.impl.arlington.GFAFileSpecification;
import org.verapdf.gf.model.impl.arlington.GFAObject;
import org.verapdf.gf.model.impl.arlington.GFARoleMapNS;
import org.verapdf.gf.model.impl.containers.StaticContainers;
import org.verapdf.model.alayer.AFileSpecification;
import org.verapdf.model.alayer.ANamespace;
import org.verapdf.model.alayer.ARoleMapNS;
import org.verapdf.model.baselayer.Object;

public class GFANamespace
extends GFAObject
implements ANamespace {
    public GFANamespace(COSBase baseObject, COSBase parentObject, String keyName) {
        super(baseObject, parentObject, keyName, "ANamespace");
    }

    public List<? extends Object> getLinkedObjects(String link) {
        switch (link) {
            case "RoleMapNS": {
                return this.getRoleMapNS();
            }
            case "Schema": {
                return this.getSchema();
            }
        }
        return super.getLinkedObjects(link);
    }

    private List<ARoleMapNS> getRoleMapNS() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON2_0: {
                return this.getRoleMapNS2_0();
            }
        }
        return Collections.emptyList();
    }

    private List<ARoleMapNS> getRoleMapNS2_0() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"RoleMapNS"));
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_DICT) {
            ArrayList<GFARoleMapNS> list = new ArrayList<GFARoleMapNS>(1);
            list.add(new GFARoleMapNS((COSBase)((COSDictionary)object.getDirectBase()), this.baseObject, "RoleMapNS"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<AFileSpecification> getSchema() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON2_0: {
                return this.getSchema2_0();
            }
        }
        return Collections.emptyList();
    }

    private List<AFileSpecification> getSchema2_0() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Schema"));
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_DICT) {
            ArrayList<GFAFileSpecification> list = new ArrayList<GFAFileSpecification>(1);
            list.add(new GFAFileSpecification((COSBase)((COSDictionary)object.getDirectBase()), this.baseObject, "Schema"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    public Boolean getcontainsNS() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"NS"));
    }

    public Boolean getNSHasTypeStringText() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"NS"));
        return object != null && object.getType() == COSObjType.COS_STRING && ((COSString)object.getDirectBase()).isTextString();
    }

    public Boolean getcontainsRoleMapNS() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"RoleMapNS"));
    }

    public Boolean getRoleMapNSHasTypeDictionary() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"RoleMapNS"));
        return object != null && object.getType() == COSObjType.COS_DICT;
    }

    public Boolean getcontainsSchema() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"Schema"));
    }

    public Boolean getSchemaHasTypeDictionary() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Schema"));
        return object != null && object.getType() == COSObjType.COS_DICT;
    }

    public Boolean getSchemaHasTypeString() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Schema"));
        return object != null && object.getType() == COSObjType.COS_STRING;
    }

    public Boolean getcontainsType() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"Type"));
    }

    public Boolean getTypeHasTypeName() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Type"));
        return object != null && object.getType() == COSObjType.COS_NAME;
    }

    public String getTypeNameValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Type"));
        if (object == null || object.empty()) {
            return this.getTypeNameDefaultValue();
        }
        if (object != null && object.getType() == COSObjType.COS_NAME) {
            return object.getString();
        }
        return null;
    }

    public String getTypeNameDefaultValue() {
        return null;
    }
}

