/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.pd;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSName;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.gf.model.impl.cos.GFCosUnicodeName;
import org.verapdf.gf.model.impl.pd.GFPDObject;
import org.verapdf.gf.model.impl.pd.GFPDStructElem;
import org.verapdf.gf.model.impl.pd.gfse.GFSEFactory;
import org.verapdf.model.coslayer.CosUnicodeName;
import org.verapdf.model.pdlayer.PDStructTreeRoot;
import org.verapdf.pd.PDObject;
import org.verapdf.pd.structure.PDStructElem;
import org.verapdf.tools.TaggedPDFHelper;

public class GFPDStructTreeRoot
extends GFPDObject
implements PDStructTreeRoot {
    public static final String STRUCT_TREE_ROOT_TYPE = "PDStructTreeRoot";
    public static final String CHILDREN = "K";
    public static final String ROLE_MAP_NAMES = "roleMapNames";
    private List<org.verapdf.model.pdlayer.PDStructElem> children = null;

    public GFPDStructTreeRoot(org.verapdf.pd.structure.PDStructTreeRoot treeRoot) {
        super((PDObject)treeRoot, STRUCT_TREE_ROOT_TYPE);
    }

    public String getkidsStandardTypes() {
        return this.getChildren().stream().map(org.verapdf.model.pdlayer.PDStructElem::getstandardType).filter(Objects::nonNull).collect(Collectors.joining("&"));
    }

    public Boolean gethasContentItems() {
        COSObject children = this.simplePDObject.getKey(ASAtom.K);
        if (children == null) {
            return false;
        }
        if (TaggedPDFHelper.isContentItem((COSObject)children)) {
            return true;
        }
        if (children.getType() == COSObjType.COS_ARRAY && children.size() > 0) {
            for (int i = 0; i < children.size(); ++i) {
                COSObject elem = children.at(i);
                if (!TaggedPDFHelper.isContentItem((COSObject)elem)) continue;
                return true;
            }
        }
        return false;
    }

    public List<? extends org.verapdf.model.baselayer.Object> getLinkedObjects(String link) {
        switch (link) {
            case "K": {
                return this.getChildren();
            }
            case "roleMapNames": {
                return this.getRoleMapNames();
            }
        }
        return super.getLinkedObjects(link);
    }

    private List<org.verapdf.model.pdlayer.PDStructElem> getChildren() {
        if (this.children == null) {
            this.children = this.parseChildren();
        }
        return this.children;
    }

    private List<org.verapdf.model.pdlayer.PDStructElem> parseChildren() {
        List elements = ((org.verapdf.pd.structure.PDStructTreeRoot)this.simplePDObject).getStructChildren();
        if (!elements.isEmpty()) {
            ArrayList<GFPDStructElem> res = new ArrayList<GFPDStructElem>(elements.size());
            for (PDStructElem element : elements) {
                res.add(GFSEFactory.createTypedStructElem(element));
            }
            return Collections.unmodifiableList(res);
        }
        return Collections.emptyList();
    }

    private List<CosUnicodeName> getRoleMapNames() {
        Map roleMap;
        if (this.simplePDObject != null && (roleMap = ((org.verapdf.pd.structure.PDStructTreeRoot)this.simplePDObject).getRoleMap()) != null) {
            ArrayList<CosUnicodeName> res = new ArrayList<CosUnicodeName>();
            for (Map.Entry entry : roleMap.entrySet()) {
                res.add(new GFCosUnicodeName((COSName)COSName.construct((ASAtom)((ASAtom)entry.getKey())).get()));
                res.add(new GFCosUnicodeName((COSName)COSName.construct((ASAtom)((ASAtom)entry.getValue())).get()));
            }
            return res;
        }
        return Collections.emptyList();
    }

    public String gettopLevelFirstElementStandardType() {
        if (this.children == null) {
            this.children = this.parseChildren();
        }
        if (!this.children.isEmpty()) {
            return this.children.get(0).getstandardType();
        }
        return null;
    }
}

