/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.arlington;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSArray;
import org.verapdf.cos.COSBase;
import org.verapdf.cos.COSDictionary;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.cos.COSStream;
import org.verapdf.gf.model.impl.arlington.GFA3DRenderMode;
import org.verapdf.gf.model.impl.arlington.GFAArrayOf3DTransMatrix;
import org.verapdf.gf.model.impl.arlington.GFAObject;
import org.verapdf.gf.model.impl.arlington.GFARichMediaInstance;
import org.verapdf.gf.model.impl.arlington.GFAStream;
import org.verapdf.gf.model.impl.containers.StaticContainers;
import org.verapdf.model.alayer.A3DNode;
import org.verapdf.model.alayer.A3DRenderMode;
import org.verapdf.model.alayer.AArrayOf3DTransMatrix;
import org.verapdf.model.alayer.ARichMediaInstance;
import org.verapdf.model.alayer.AStream;

public class GFA3DNode
extends GFAObject
implements A3DNode {
    public GFA3DNode(COSBase baseObject, COSBase parentObject, String keyName) {
        super(baseObject, parentObject, keyName, "A3DNode");
    }

    public List<? extends org.verapdf.model.baselayer.Object> getLinkedObjects(String link) {
        switch (link) {
            case "Data": {
                return this.getData();
            }
            case "Instance": {
                return this.getInstance();
            }
            case "M": {
                return this.getM();
            }
            case "RM": {
                return this.getRM();
            }
        }
        return super.getLinkedObjects(link);
    }

    private List<AStream> getData() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON2_0: {
                return this.getData2_0();
            }
        }
        return Collections.emptyList();
    }

    private List<AStream> getData2_0() {
        COSObject object = this.getDataValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_STREAM) {
            ArrayList<GFAStream> list = new ArrayList<GFAStream>(1);
            list.add(new GFAStream((COSBase)((COSStream)object.getDirectBase()), this.baseObject, "Data"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<ARichMediaInstance> getInstance() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON2_0: {
                return this.getInstance2_0();
            }
        }
        return Collections.emptyList();
    }

    private List<ARichMediaInstance> getInstance2_0() {
        COSObject object = this.getInstanceValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_DICT) {
            ArrayList<GFARichMediaInstance> list = new ArrayList<GFARichMediaInstance>(1);
            list.add(new GFARichMediaInstance((COSBase)((COSDictionary)object.getDirectBase()), this.baseObject, "Instance"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<AArrayOf3DTransMatrix> getM() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON2_0: 
            case ARLINGTON1_7: {
                return this.getM1_7();
            }
        }
        return Collections.emptyList();
    }

    private List<AArrayOf3DTransMatrix> getM1_7() {
        COSObject object = this.getMValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_ARRAY) {
            ArrayList<GFAArrayOf3DTransMatrix> list = new ArrayList<GFAArrayOf3DTransMatrix>(1);
            list.add(new GFAArrayOf3DTransMatrix((COSBase)((COSArray)object.getDirectBase()), this.baseObject, "M"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<A3DRenderMode> getRM() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON2_0: {
                return this.getRM2_0();
            }
        }
        return Collections.emptyList();
    }

    private List<A3DRenderMode> getRM2_0() {
        COSObject object = this.getRMValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_DICT) {
            ArrayList<GFA3DRenderMode> list = new ArrayList<GFA3DRenderMode>(1);
            list.add(new GFA3DRenderMode((COSBase)((COSDictionary)object.getDirectBase()), this.baseObject, "RM"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    public Boolean getcontainsData() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"Data"));
    }

    public COSObject getDataValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Data"));
        return object;
    }

    public Boolean getisDataIndirect() {
        COSObject Data = this.getDataValue();
        return GFA3DNode.getisIndirect(Data);
    }

    public Boolean getDataHasTypeStream() {
        COSObject Data = this.getDataValue();
        return GFA3DNode.getHasTypeStream(Data);
    }

    public Boolean getDataHasTypeStringText() {
        COSObject Data = this.getDataValue();
        return GFA3DNode.getHasTypeStringText(Data);
    }

    public Boolean getcontainsInstance() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"Instance"));
    }

    public COSObject getInstanceValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Instance"));
        return object;
    }

    public Boolean getInstanceHasTypeDictionary() {
        COSObject Instance = this.getInstanceValue();
        return GFA3DNode.getHasTypeDictionary(Instance);
    }

    public Boolean getcontainsM() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"M"));
    }

    public COSObject getMValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"M"));
        return object;
    }

    public Boolean getMHasTypeArray() {
        COSObject M = this.getMValue();
        return GFA3DNode.getHasTypeArray(M);
    }

    public Boolean getcontainsN() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"N"));
    }

    public COSObject getNValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"N"));
        return object;
    }

    public Boolean getNHasTypeString() {
        COSObject N = this.getNValue();
        return GFA3DNode.getHasTypeString(N);
    }

    public Boolean getcontainsO() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"O"));
    }

    public COSObject getOValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"O"));
        return object;
    }

    public Boolean getOHasTypeNumber() {
        COSObject O = this.getOValue();
        return GFA3DNode.getHasTypeNumber(O);
    }

    public Double getONumberValue() {
        COSObject O = this.getOValue();
        return GFA3DNode.getNumberValue(O);
    }

    public Boolean getcontainsRM() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"RM"));
    }

    public COSObject getRMValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"RM"));
        return object;
    }

    public Boolean getRMHasTypeDictionary() {
        COSObject RM = this.getRMValue();
        return GFA3DNode.getHasTypeDictionary(RM);
    }

    public Boolean getcontainsType() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"Type"));
    }

    public COSObject getTypeValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Type"));
        return object;
    }

    public Boolean getTypeHasTypeName() {
        COSObject Type2 = this.getTypeValue();
        return GFA3DNode.getHasTypeName(Type2);
    }

    public String getTypeNameValue() {
        COSObject Type2 = this.getTypeValue();
        return GFA3DNode.getNameValue(Type2);
    }

    public Boolean getcontainsV() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"V"));
    }

    public COSObject getVValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"V"));
        return object;
    }

    public Boolean getVHasTypeBoolean() {
        COSObject V = this.getVValue();
        return GFA3DNode.getHasTypeBoolean(V);
    }
}

