/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.arlington;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSArray;
import org.verapdf.cos.COSBase;
import org.verapdf.cos.COSInteger;
import org.verapdf.cos.COSName;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.gf.model.impl.arlington.GFAArrayOfStringsASCII;
import org.verapdf.gf.model.impl.arlington.GFAArrayOfStringsByte;
import org.verapdf.gf.model.impl.arlington.GFAArrayOfSubjectDN;
import org.verapdf.gf.model.impl.arlington.GFAObject;
import org.verapdf.gf.model.impl.containers.StaticContainers;
import org.verapdf.model.alayer.AArrayOfStringsASCII;
import org.verapdf.model.alayer.AArrayOfStringsByte;
import org.verapdf.model.alayer.AArrayOfSubjectDN;
import org.verapdf.model.alayer.ACertSeedValue;

public class GFACertSeedValue
extends GFAObject
implements ACertSeedValue {
    public GFACertSeedValue(COSBase baseObject, COSBase parentObject, String keyName) {
        super(baseObject, parentObject, keyName, "ACertSeedValue");
    }

    public List<? extends org.verapdf.model.baselayer.Object> getLinkedObjects(String link) {
        switch (link) {
            case "Issuer": {
                return this.getIssuer();
            }
            case "KeyUsage": {
                return this.getKeyUsage();
            }
            case "OID": {
                return this.getOID();
            }
            case "SignaturePolicyCommitmentType": {
                return this.getSignaturePolicyCommitmentType();
            }
            case "Subject": {
                return this.getSubject();
            }
            case "SubjectDN": {
                return this.getSubjectDN();
            }
        }
        return super.getLinkedObjects(link);
    }

    private List<AArrayOfStringsByte> getIssuer() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return this.getIssuer1_5();
            }
        }
        return Collections.emptyList();
    }

    private List<AArrayOfStringsByte> getIssuer1_5() {
        COSObject object = this.getIssuerValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_ARRAY) {
            ArrayList<GFAArrayOfStringsByte> list = new ArrayList<GFAArrayOfStringsByte>(1);
            list.add(new GFAArrayOfStringsByte((COSBase)((COSArray)object.getDirectBase()), this.baseObject, "Issuer"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<AArrayOfStringsASCII> getKeyUsage() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return this.getKeyUsage1_7();
            }
        }
        return Collections.emptyList();
    }

    private List<AArrayOfStringsASCII> getKeyUsage1_7() {
        COSObject object = this.getKeyUsageValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_ARRAY) {
            ArrayList<GFAArrayOfStringsASCII> list = new ArrayList<GFAArrayOfStringsASCII>(1);
            list.add(new GFAArrayOfStringsASCII((COSBase)((COSArray)object.getDirectBase()), this.baseObject, "KeyUsage"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<AArrayOfStringsByte> getOID() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return this.getOID1_5();
            }
        }
        return Collections.emptyList();
    }

    private List<AArrayOfStringsByte> getOID1_5() {
        COSObject object = this.getOIDValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_ARRAY) {
            ArrayList<GFAArrayOfStringsByte> list = new ArrayList<GFAArrayOfStringsByte>(1);
            list.add(new GFAArrayOfStringsByte((COSBase)((COSArray)object.getDirectBase()), this.baseObject, "OID"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<AArrayOfStringsASCII> getSignaturePolicyCommitmentType() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON2_0: {
                return this.getSignaturePolicyCommitmentType2_0();
            }
        }
        return Collections.emptyList();
    }

    private List<AArrayOfStringsASCII> getSignaturePolicyCommitmentType2_0() {
        COSObject object = this.getSignaturePolicyCommitmentTypeValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_ARRAY) {
            ArrayList<GFAArrayOfStringsASCII> list = new ArrayList<GFAArrayOfStringsASCII>(1);
            list.add(new GFAArrayOfStringsASCII((COSBase)((COSArray)object.getDirectBase()), this.baseObject, "SignaturePolicyCommitmentType"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<AArrayOfStringsByte> getSubject() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return this.getSubject1_5();
            }
        }
        return Collections.emptyList();
    }

    private List<AArrayOfStringsByte> getSubject1_5() {
        COSObject object = this.getSubjectValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_ARRAY) {
            ArrayList<GFAArrayOfStringsByte> list = new ArrayList<GFAArrayOfStringsByte>(1);
            list.add(new GFAArrayOfStringsByte((COSBase)((COSArray)object.getDirectBase()), this.baseObject, "Subject"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<AArrayOfSubjectDN> getSubjectDN() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return this.getSubjectDN1_7();
            }
        }
        return Collections.emptyList();
    }

    private List<AArrayOfSubjectDN> getSubjectDN1_7() {
        COSObject object = this.getSubjectDNValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_ARRAY) {
            ArrayList<GFAArrayOfSubjectDN> list = new ArrayList<GFAArrayOfSubjectDN>(1);
            list.add(new GFAArrayOfSubjectDN((COSBase)((COSArray)object.getDirectBase()), this.baseObject, "SubjectDN"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    public Boolean getcontainsFf() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"Ff"));
    }

    public COSObject getFfDefaultValue() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return COSInteger.construct((long)0L);
            }
        }
        return null;
    }

    public COSObject getFfValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Ff"));
        if (object == null || object.empty()) {
            object = this.getFfDefaultValue();
        }
        return object;
    }

    public Boolean getFfHasTypeBitmask() {
        COSObject Ff = this.getFfValue();
        return GFACertSeedValue.getHasTypeBitmask(Ff);
    }

    public Long getFfBitmaskValue() {
        COSObject Ff = this.getFfValue();
        return GFACertSeedValue.getBitmaskValue(Ff);
    }

    public Boolean getcontainsIssuer() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"Issuer"));
    }

    public COSObject getIssuerValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Issuer"));
        return object;
    }

    public Boolean getIssuerHasTypeArray() {
        COSObject Issuer = this.getIssuerValue();
        return GFACertSeedValue.getHasTypeArray(Issuer);
    }

    public Boolean getcontainsKeyUsage() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"KeyUsage"));
    }

    public COSObject getKeyUsageValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"KeyUsage"));
        return object;
    }

    public Boolean getKeyUsageHasTypeArray() {
        COSObject KeyUsage = this.getKeyUsageValue();
        return GFACertSeedValue.getHasTypeArray(KeyUsage);
    }

    public Boolean getcontainsOID() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"OID"));
    }

    public COSObject getOIDValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"OID"));
        return object;
    }

    public Boolean getOIDHasTypeArray() {
        COSObject OID = this.getOIDValue();
        return GFACertSeedValue.getHasTypeArray(OID);
    }

    public Boolean getcontainsSignaturePolicyCommitmentType() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"SignaturePolicyCommitmentType"));
    }

    public COSObject getSignaturePolicyCommitmentTypeValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"SignaturePolicyCommitmentType"));
        return object;
    }

    public Boolean getSignaturePolicyCommitmentTypeHasTypeArray() {
        COSObject SignaturePolicyCommitmentType = this.getSignaturePolicyCommitmentTypeValue();
        return GFACertSeedValue.getHasTypeArray(SignaturePolicyCommitmentType);
    }

    public Boolean getcontainsSignaturePolicyHashAlgorithm() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"SignaturePolicyHashAlgorithm"));
    }

    public COSObject getSignaturePolicyHashAlgorithmValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"SignaturePolicyHashAlgorithm"));
        return object;
    }

    public Boolean getSignaturePolicyHashAlgorithmHasTypeName() {
        COSObject SignaturePolicyHashAlgorithm = this.getSignaturePolicyHashAlgorithmValue();
        return GFACertSeedValue.getHasTypeName(SignaturePolicyHashAlgorithm);
    }

    public String getSignaturePolicyHashAlgorithmNameValue() {
        COSObject SignaturePolicyHashAlgorithm = this.getSignaturePolicyHashAlgorithmValue();
        return GFACertSeedValue.getNameValue(SignaturePolicyHashAlgorithm);
    }

    public Boolean getcontainsSignaturePolicyHashValue() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"SignaturePolicyHashValue"));
    }

    public COSObject getSignaturePolicyHashValueValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"SignaturePolicyHashValue"));
        return object;
    }

    public Boolean getSignaturePolicyHashValueHasTypeString() {
        COSObject SignaturePolicyHashValue = this.getSignaturePolicyHashValueValue();
        return GFACertSeedValue.getHasTypeString(SignaturePolicyHashValue);
    }

    public Boolean getcontainsSignaturePolicyOID() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"SignaturePolicyOID"));
    }

    public COSObject getSignaturePolicyOIDValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"SignaturePolicyOID"));
        return object;
    }

    public Boolean getSignaturePolicyOIDHasTypeStringAscii() {
        COSObject SignaturePolicyOID = this.getSignaturePolicyOIDValue();
        return GFACertSeedValue.getHasTypeStringAscii(SignaturePolicyOID);
    }

    public Boolean getcontainsSubject() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"Subject"));
    }

    public COSObject getSubjectValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Subject"));
        return object;
    }

    public Boolean getSubjectHasTypeArray() {
        COSObject Subject = this.getSubjectValue();
        return GFACertSeedValue.getHasTypeArray(Subject);
    }

    public Boolean getcontainsSubjectDN() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"SubjectDN"));
    }

    public COSObject getSubjectDNValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"SubjectDN"));
        return object;
    }

    public Boolean getSubjectDNHasTypeArray() {
        COSObject SubjectDN = this.getSubjectDNValue();
        return GFACertSeedValue.getHasTypeArray(SubjectDN);
    }

    public Boolean getcontainsType() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"Type"));
    }

    public COSObject getTypeValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Type"));
        return object;
    }

    public Boolean getTypeHasTypeName() {
        COSObject Type2 = this.getTypeValue();
        return GFACertSeedValue.getHasTypeName(Type2);
    }

    public String getTypeNameValue() {
        COSObject Type2 = this.getTypeValue();
        return GFACertSeedValue.getNameValue(Type2);
    }

    public Boolean getcontainsURL() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"URL"));
    }

    public COSObject getURLValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"URL"));
        return object;
    }

    public Boolean getURLHasTypeStringAscii() {
        COSObject URL2 = this.getURLValue();
        return GFACertSeedValue.getHasTypeStringAscii(URL2);
    }

    public Boolean getcontainsURLType() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"URLType"));
    }

    public COSObject getURLTypeDefaultValue() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return COSName.construct((String)"Browser");
            }
        }
        return null;
    }

    public COSObject getURLTypeValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"URLType"));
        if (object == null || object.empty()) {
            object = this.getURLTypeDefaultValue();
        }
        return object;
    }

    public Boolean getURLTypeHasTypeName() {
        COSObject URLType = this.getURLTypeValue();
        return GFACertSeedValue.getHasTypeName(URLType);
    }

    public String getURLTypeNameValue() {
        COSObject URLType = this.getURLTypeValue();
        return GFACertSeedValue.getNameValue(URLType);
    }
}

