/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.arlington;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSArray;
import org.verapdf.cos.COSBase;
import org.verapdf.cos.COSBoolean;
import org.verapdf.cos.COSName;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.gf.model.impl.arlington.GFAArrayOfStringsByte;
import org.verapdf.gf.model.impl.arlington.GFAObject;
import org.verapdf.gf.model.impl.containers.StaticContainers;
import org.verapdf.model.alayer.AArrayOfStringsByte;
import org.verapdf.model.alayer.ACryptFilterPublicKey;
import org.verapdf.model.baselayer.Object;

public class GFACryptFilterPublicKey
extends GFAObject
implements ACryptFilterPublicKey {
    public GFACryptFilterPublicKey(COSBase baseObject, COSBase parentObject, String keyName) {
        super(baseObject, parentObject, keyName, "ACryptFilterPublicKey");
    }

    public List<? extends Object> getLinkedObjects(String link) {
        switch (link) {
            case "Recipients": {
                return this.getRecipients();
            }
        }
        return super.getLinkedObjects(link);
    }

    private List<AArrayOfStringsByte> getRecipients() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return this.getRecipients1_5();
            }
        }
        return Collections.emptyList();
    }

    private List<AArrayOfStringsByte> getRecipients1_5() {
        COSObject object = this.getRecipientsValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_ARRAY) {
            ArrayList<GFAArrayOfStringsByte> list = new ArrayList<GFAArrayOfStringsByte>(1);
            list.add(new GFAArrayOfStringsByte((COSBase)((COSArray)object.getDirectBase()), this.baseObject, "Recipients"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    public Boolean getcontainsAuthEvent() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"AuthEvent"));
    }

    public COSObject getAuthEventDefaultValue() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return COSName.construct((String)"DocOpen");
            }
        }
        return null;
    }

    public COSObject getAuthEventValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"AuthEvent"));
        if (object == null || object.empty()) {
            object = this.getAuthEventDefaultValue();
        }
        return object;
    }

    public Boolean getAuthEventHasTypeName() {
        COSObject AuthEvent = this.getAuthEventValue();
        return GFACryptFilterPublicKey.getHasTypeName(AuthEvent);
    }

    public String getAuthEventNameValue() {
        COSObject AuthEvent = this.getAuthEventValue();
        return GFACryptFilterPublicKey.getNameValue(AuthEvent);
    }

    public Boolean getcontainsCFM() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"CFM"));
    }

    public COSObject getCFMDefaultValue() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return COSName.construct((String)"None");
            }
        }
        return null;
    }

    public COSObject getCFMValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"CFM"));
        if (object == null || object.empty()) {
            object = this.getCFMDefaultValue();
        }
        return object;
    }

    public Boolean getCFMHasTypeName() {
        COSObject CFM = this.getCFMValue();
        return GFACryptFilterPublicKey.getHasTypeName(CFM);
    }

    public String getCFMNameValue() {
        COSObject CFM = this.getCFMValue();
        return GFACryptFilterPublicKey.getNameValue(CFM);
    }

    public Boolean getcontainsEncryptMetadata() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"EncryptMetadata"));
    }

    public COSObject getEncryptMetadataDefaultValue() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return COSBoolean.construct((boolean)true);
            }
        }
        return null;
    }

    public COSObject getEncryptMetadataValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"EncryptMetadata"));
        if (object == null || object.empty()) {
            object = this.getEncryptMetadataDefaultValue();
        }
        return object;
    }

    public Boolean getEncryptMetadataHasTypeBoolean() {
        COSObject EncryptMetadata = this.getEncryptMetadataValue();
        return GFACryptFilterPublicKey.getHasTypeBoolean(EncryptMetadata);
    }

    public Boolean getcontainsLength() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"Length"));
    }

    public COSObject getLengthValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Length"));
        return object;
    }

    public Boolean getLengthHasTypeInteger() {
        COSObject Length = this.getLengthValue();
        return GFACryptFilterPublicKey.getHasTypeInteger(Length);
    }

    public Long getLengthIntegerValue() {
        COSObject Length = this.getLengthValue();
        return GFACryptFilterPublicKey.getIntegerValue(Length);
    }

    public Boolean getcontainsRecipients() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"Recipients"));
    }

    public COSObject getRecipientsValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Recipients"));
        return object;
    }

    public Boolean getRecipientsHasTypeArray() {
        COSObject Recipients = this.getRecipientsValue();
        return GFACryptFilterPublicKey.getHasTypeArray(Recipients);
    }

    public Boolean getRecipientsHasTypeStringByte() {
        COSObject Recipients = this.getRecipientsValue();
        return GFACryptFilterPublicKey.getHasTypeStringByte(Recipients);
    }

    public Boolean getcontainsType() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"Type"));
    }

    public COSObject getTypeValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Type"));
        return object;
    }

    public Boolean getTypeHasTypeName() {
        COSObject Type2 = this.getTypeValue();
        return GFACryptFilterPublicKey.getHasTypeName(Type2);
    }

    public String getTypeNameValue() {
        COSObject Type2 = this.getTypeValue();
        return GFACryptFilterPublicKey.getNameValue(Type2);
    }
}

