/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.arlington;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSBase;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.gf.model.impl.arlington.GFADictionaryOfFunctionsEntry;
import org.verapdf.gf.model.impl.arlington.GFAFunctionType0;
import org.verapdf.gf.model.impl.arlington.GFAFunctionType2;
import org.verapdf.gf.model.impl.arlington.GFAFunctionType3;
import org.verapdf.gf.model.impl.arlington.GFAFunctionType4;
import org.verapdf.gf.model.impl.arlington.GFAObject;
import org.verapdf.gf.model.impl.containers.StaticContainers;
import org.verapdf.model.alayer.ADictionaryOfFunctions;
import org.verapdf.model.alayer.ADictionaryOfFunctionsEntry;
import org.verapdf.model.baselayer.Object;

public class GFADictionaryOfFunctions
extends GFAObject
implements ADictionaryOfFunctions {
    public GFADictionaryOfFunctions(COSBase baseObject, COSBase parentObject, String keyName) {
        super(baseObject, parentObject, keyName, "ADictionaryOfFunctions");
    }

    public List<? extends Object> getLinkedObjects(String link) {
        switch (link) {
            case "Entries": {
                return this.getEntries();
            }
            case "Default": {
                return this.getDefault();
            }
        }
        return super.getLinkedObjects(link);
    }

    private List<ADictionaryOfFunctionsEntry> getEntries() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_6: 
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return this.getEntries1_6();
            }
        }
        return Collections.emptyList();
    }

    private List<ADictionaryOfFunctionsEntry> getEntries1_6() {
        LinkedList<GFADictionaryOfFunctionsEntry> list = new LinkedList<GFADictionaryOfFunctionsEntry>();
        for (ASAtom key : this.baseObject.getKeySet()) {
            if ("Default".equals(key.getValue())) continue;
            COSObject object = this.baseObject.getKey(key);
            list.add(new GFADictionaryOfFunctionsEntry(object != null ? object.get() : null, this.baseObject, this.parentObject, this.keyName, key.getValue()));
        }
        return Collections.unmodifiableList(list);
    }

    private List<Object> getDefault() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_6: 
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return this.getDefault1_6();
            }
        }
        return Collections.emptyList();
    }

    private List<Object> getDefault1_6() {
        COSObject object = this.getDefaultValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_DICT) {
            Object result = this.getDefaultDictionary1_6(object.getDirectBase(), "Default");
            ArrayList<Object> list = new ArrayList<Object>(1);
            if (result != null) {
                list.add(result);
            }
            return Collections.unmodifiableList(list);
        }
        if (object.getType() == COSObjType.COS_STREAM) {
            Object result = this.getDefaultStream1_6(object.getDirectBase(), "Default");
            ArrayList<Object> list = new ArrayList<Object>(1);
            if (result != null) {
                list.add(result);
            }
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private Object getDefaultDictionary1_6(COSBase base, String keyName) {
        COSObject subtype = base.getKey(ASAtom.getASAtom((String)"FunctionType"));
        if (subtype == null) {
            return null;
        }
        Long subtypeValue = subtype.getInteger();
        if (subtypeValue == null) {
            return null;
        }
        switch (subtypeValue.intValue()) {
            case 2: {
                return new GFAFunctionType2(base, this.baseObject, keyName);
            }
            case 3: {
                return new GFAFunctionType3(base, this.baseObject, keyName);
            }
        }
        return null;
    }

    private Object getDefaultStream1_6(COSBase base, String keyName) {
        COSObject subtype = base.getKey(ASAtom.getASAtom((String)"FunctionType"));
        if (subtype == null) {
            return null;
        }
        Long subtypeValue = subtype.getInteger();
        if (subtypeValue == null) {
            return null;
        }
        switch (subtypeValue.intValue()) {
            case 0: {
                return new GFAFunctionType0(base, this.baseObject, keyName);
            }
            case 4: {
                return new GFAFunctionType4(base, this.baseObject, keyName);
            }
        }
        return null;
    }

    public Boolean getcontainsDefault() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"Default"));
    }

    public COSObject getDefaultValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Default"));
        return object;
    }

    public Boolean getisDefaultIndirect() {
        COSObject Default = this.getDefaultValue();
        return GFADictionaryOfFunctions.getisIndirect(Default);
    }

    public Boolean getDefaultHasTypeDictionary() {
        COSObject Default = this.getDefaultValue();
        return GFADictionaryOfFunctions.getHasTypeDictionary(Default);
    }

    public Boolean getDefaultHasTypeStream() {
        COSObject Default = this.getDefaultValue();
        return GFADictionaryOfFunctions.getHasTypeStream(Default);
    }
}

