/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.arlington;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSArray;
import org.verapdf.cos.COSBase;
import org.verapdf.cos.COSDictionary;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.gf.model.impl.arlington.GFAObject;
import org.verapdf.gf.model.impl.arlington.GFAPageObject;
import org.verapdf.gf.model.impl.arlington.GFAXObjectFormType1;
import org.verapdf.gf.model.impl.arlington.GFAXObjectImage;
import org.verapdf.gf.model.impl.arlington.GFA_UniversalArray;
import org.verapdf.gf.model.impl.arlington.GFA_UniversalDictionary;
import org.verapdf.gf.model.impl.containers.StaticContainers;
import org.verapdf.model.alayer.AObjectReference;
import org.verapdf.model.alayer.APageObject;
import org.verapdf.model.baselayer.Object;

public class GFAObjectReference
extends GFAObject
implements AObjectReference {
    public GFAObjectReference(COSBase baseObject, COSBase parentObject, String keyName) {
        super(baseObject, parentObject, keyName, "AObjectReference");
        COSObject obj = this.baseObject.getKey(ASAtom.OBJ);
        if (obj != null && obj.getKey() != null) {
            GFAObject.getKeysSet().add(obj.getKey());
        }
    }

    public List<? extends Object> getLinkedObjects(String link) {
        switch (link) {
            case "Obj": {
                return this.getObj();
            }
            case "Pg": {
                return this.getPg();
            }
        }
        return super.getLinkedObjects(link);
    }

    private List<Object> getObj() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_3: 
            case ARLINGTON1_4: 
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return this.getObj1_3();
            }
        }
        return Collections.emptyList();
    }

    private List<Object> getObj1_3() {
        COSObject object = this.getObjValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_ARRAY) {
            ArrayList<GFA_UniversalArray> list = new ArrayList<GFA_UniversalArray>(1);
            list.add(new GFA_UniversalArray((COSBase)((COSArray)object.getDirectBase()), this.baseObject, "Obj"));
            return Collections.unmodifiableList(list);
        }
        if (object.getType() == COSObjType.COS_DICT) {
            ArrayList<GFA_UniversalDictionary> list = new ArrayList<GFA_UniversalDictionary>(1);
            list.add(new GFA_UniversalDictionary((COSBase)((COSDictionary)object.getDirectBase()), this.baseObject, "Obj"));
            return Collections.unmodifiableList(list);
        }
        if (object.getType() == COSObjType.COS_STREAM) {
            Object result = this.getObjStream1_3(object.getDirectBase(), "Obj");
            ArrayList<Object> list = new ArrayList<Object>(1);
            if (result != null) {
                list.add(result);
            }
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private Object getObjStream1_3(COSBase base, String keyName) {
        COSObject subtype = base.getKey(ASAtom.getASAtom((String)"Subtype"));
        if (subtype == null) {
            return null;
        }
        String subtypeValue = subtype.getString();
        if (subtypeValue == null) {
            return null;
        }
        switch (subtypeValue) {
            case "Form": {
                return new GFAXObjectFormType1(base, this.baseObject, keyName);
            }
            case "Image": {
                return new GFAXObjectImage(base, this.baseObject, keyName);
            }
        }
        return null;
    }

    private List<APageObject> getPg() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_3: 
            case ARLINGTON1_4: 
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return this.getPg1_3();
            }
        }
        return Collections.emptyList();
    }

    private List<APageObject> getPg1_3() {
        COSObject object = this.getPgValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_DICT) {
            ArrayList<GFAPageObject> list = new ArrayList<GFAPageObject>(1);
            list.add(new GFAPageObject((COSBase)((COSDictionary)object.getDirectBase()), this.baseObject, "Pg"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    public Boolean getcontainsObj() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"Obj"));
    }

    public COSObject getObjValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Obj"));
        return object;
    }

    public Boolean getisObjIndirect() {
        COSObject Obj = this.getObjValue();
        return GFAObjectReference.getisIndirect(Obj);
    }

    public Boolean getObjHasTypeArray() {
        COSObject Obj = this.getObjValue();
        return GFAObjectReference.getHasTypeArray(Obj);
    }

    public Boolean getObjHasTypeDictionary() {
        COSObject Obj = this.getObjValue();
        return GFAObjectReference.getHasTypeDictionary(Obj);
    }

    public Boolean getObjHasTypeStream() {
        COSObject Obj = this.getObjValue();
        return GFAObjectReference.getHasTypeStream(Obj);
    }

    public Boolean getcontainsPg() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"Pg"));
    }

    public COSObject getPgValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Pg"));
        return object;
    }

    public Boolean getisPgIndirect() {
        COSObject Pg = this.getPgValue();
        return GFAObjectReference.getisIndirect(Pg);
    }

    public Boolean getPgHasTypeDictionary() {
        COSObject Pg = this.getPgValue();
        return GFAObjectReference.getHasTypeDictionary(Pg);
    }

    public Boolean getcontainsType() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"Type"));
    }

    public COSObject getTypeValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Type"));
        return object;
    }

    public Boolean getTypeHasTypeName() {
        COSObject Type2 = this.getTypeValue();
        return GFAObjectReference.getHasTypeName(Type2);
    }

    public String getTypeNameValue() {
        COSObject Type2 = this.getTypeValue();
        return GFAObjectReference.getNameValue(Type2);
    }
}

