/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.pd;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSName;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.cos.COSString;
import org.verapdf.gf.model.impl.containers.StaticContainers;
import org.verapdf.gf.model.impl.cos.GFCosBM;
import org.verapdf.gf.model.impl.cos.GFCosLang;
import org.verapdf.gf.model.impl.pd.GFPDObject;
import org.verapdf.gf.model.impl.pd.actions.GFPDAction;
import org.verapdf.gf.model.impl.pd.actions.GFPDAdditionalActions;
import org.verapdf.gf.model.impl.pd.annotations.GFPD3DAnnot;
import org.verapdf.gf.model.impl.pd.annotations.GFPDFileAttachmentAnnot;
import org.verapdf.gf.model.impl.pd.annotations.GFPDInkAnnot;
import org.verapdf.gf.model.impl.pd.annotations.GFPDLinkAnnot;
import org.verapdf.gf.model.impl.pd.annotations.GFPDMarkupAnnot;
import org.verapdf.gf.model.impl.pd.annotations.GFPDMovieAnnot;
import org.verapdf.gf.model.impl.pd.annotations.GFPDPopupAnnot;
import org.verapdf.gf.model.impl.pd.annotations.GFPDPrinterMarkAnnot;
import org.verapdf.gf.model.impl.pd.annotations.GFPDRichMediaAnnot;
import org.verapdf.gf.model.impl.pd.annotations.GFPDRubberStampAnnot;
import org.verapdf.gf.model.impl.pd.annotations.GFPDScreenAnnot;
import org.verapdf.gf.model.impl.pd.annotations.GFPDSoundAnnot;
import org.verapdf.gf.model.impl.pd.annotations.GFPDTrapNetAnnot;
import org.verapdf.gf.model.impl.pd.annotations.GFPDWidgetAnnot;
import org.verapdf.gf.model.impl.pd.gfse.GFSEFactory;
import org.verapdf.gf.model.impl.pd.images.GFPDXForm;
import org.verapdf.gf.model.impl.pd.util.PDResourcesHandler;
import org.verapdf.model.coslayer.CosBM;
import org.verapdf.model.coslayer.CosLang;
import org.verapdf.model.pdlayer.PDAction;
import org.verapdf.model.pdlayer.PDAdditionalActions;
import org.verapdf.model.pdlayer.PDAnnot;
import org.verapdf.model.pdlayer.PDXForm;
import org.verapdf.pd.PDAnnotation;
import org.verapdf.pd.PDAppearanceEntry;
import org.verapdf.pd.PDAppearanceStream;
import org.verapdf.pd.PDObject;
import org.verapdf.pd.PDPage;
import org.verapdf.pd.actions.PDAbstractAdditionalActions;
import org.verapdf.pd.actions.PDAnnotationAdditionalActions;
import org.verapdf.pd.annotations.PDWidgetAnnotation;
import org.verapdf.pd.structure.PDNumberTreeNode;
import org.verapdf.pd.structure.PDStructElem;
import org.verapdf.pd.structure.PDStructTreeRoot;
import org.verapdf.pdfa.flavours.PDFAFlavour;
import org.verapdf.tools.StaticResources;
import org.verapdf.tools.TaggedPDFRoleMapHelper;

public class GFPDAnnot
extends GFPDObject
implements PDAnnot {
    public static final String ANNOTATION_TYPE = "PDAnnot";
    public static final String DICT = "Dict";
    public static final String STREAM = "Stream";
    public static final String APPEARANCE = "appearance";
    public static final String A = "A";
    public static final String ADDITIONAL_ACTION = "AA";
    public static final String LANG = "Lang";
    public static final String BM = "BM";
    public static final String TYPE_3D = "3D";
    public static final String CARET = "Caret";
    public static final String CIRCLE = "Circle";
    public static final String FILE_ATTACHMENT = "FileAttachment";
    public static final String FREE_TEXT = "FreeText";
    public static final String HIGHLIGHT = "Highlight";
    public static final String INK = "Ink";
    public static final String LINE = "Line";
    public static final String LINK = "Link";
    public static final String MOVIE = "Movie";
    public static final String POLYGON = "Polygon";
    public static final String POLYLINE = "PolyLine";
    public static final String POPUP = "Popup";
    public static final String PRINTER_MARK = "PrinterMark";
    public static final String REDACT = "Redact";
    public static final String RICH_MEDIA = "RichMedia";
    public static final String SCREEN = "Screen";
    public static final String SOUND = "Sound";
    public static final String STAMP = "Stamp";
    public static final String STRIKE_OUT = "StrikeOut";
    public static final String SQUARE = "Square";
    public static final String SQUIGGLY = "Squiggly";
    public static final String TEXT = "Text";
    public static final String TRAP_NET = "TrapNet";
    public static final String UNDERLINE = "Underline";
    public static final String WIDGET = "Widget";
    public static final int X_AXIS = 0;
    public static final int Y_AXIS = 1;
    protected final PDResourcesHandler resources;
    private final PDPage page;
    private List<CosBM> blendMode = null;
    private List<PDXForm> appearance = null;
    private boolean containsTransparency = false;

    public GFPDAnnot(PDAnnotation annot, PDResourcesHandler pageResources, PDPage page) {
        this(annot, pageResources, page, ANNOTATION_TYPE);
    }

    public GFPDAnnot(PDAnnotation annot, PDResourcesHandler pageResources, PDPage page, String type) {
        super((PDObject)annot, type);
        this.resources = pageResources;
        this.page = page;
    }

    public String getSubtype() {
        ASAtom subtype = ((PDAnnotation)this.simplePDObject).getSubtype();
        return subtype == null ? null : subtype.getValue();
    }

    public String getAP() {
        COSObject apLocal = ((PDAnnotation)this.simplePDObject).getCOSAP();
        if (apLocal != null) {
            return apLocal.getKeySet().stream().map(ASAtom::getValue).collect(Collectors.joining("&"));
        }
        return null;
    }

    public Long getF() {
        return ((PDAnnotation)this.simplePDObject).getF();
    }

    public Double getCA() {
        return ((PDAnnotation)this.simplePDObject).getCA();
    }

    public String getN_type() {
        PDAppearanceEntry normalAppearance = ((PDAnnotation)this.simplePDObject).getNormalAppearance();
        if (normalAppearance == null) {
            return null;
        }
        if (normalAppearance.isSubDictionary()) {
            return DICT;
        }
        return STREAM;
    }

    public Boolean getcontainsC() {
        return ((PDAnnotation)this.simplePDObject).getCOSC() != null;
    }

    public Boolean getcontainsIC() {
        return ((PDAnnotation)this.simplePDObject).getCOSIC() != null;
    }

    public String getFT() {
        ASAtom ft = ((PDAnnotation)this.simplePDObject).getFT();
        return ft == null ? null : ft.getValue();
    }

    public Double getwidth() {
        return GFPDAnnot.getDifference(((PDAnnotation)this.simplePDObject).getRect(), 0);
    }

    public Double getheight() {
        return GFPDAnnot.getDifference(((PDAnnotation)this.simplePDObject).getRect(), 1);
    }

    public Boolean getcontainsAA() {
        return this.simplePDObject.knownKey(ASAtom.AA);
    }

    public String getstructParentType() {
        COSObject parentDictionary = this.getParentDictionary();
        return parentDictionary != null ? parentDictionary.getNameKeyStringValue(ASAtom.S) : null;
    }

    public String getstructParentStandardType() {
        COSObject parentDictionary;
        TaggedPDFRoleMapHelper taggedPDFRoleMapHelper = StaticResources.getRoleMapHelper();
        if (taggedPDFRoleMapHelper != null && (parentDictionary = this.getParentDictionary()) != null) {
            PDStructElem structElem = new PDStructElem(parentDictionary, taggedPDFRoleMapHelper.getRoleMap());
            return GFSEFactory.getStructureElementStandardType(structElem);
        }
        return null;
    }

    private COSObject getParentDictionary() {
        PDStructTreeRoot structTreeRoot = StaticResources.getDocument().getStructTreeRoot();
        Long structParent = ((PDAnnotation)this.simplePDObject).getStructParent();
        if (structTreeRoot != null && structParent != null) {
            COSObject structureElement;
            PDNumberTreeNode parentTreeRoot = structTreeRoot.getParentTree();
            COSObject cOSObject = structureElement = parentTreeRoot == null ? null : parentTreeRoot.getObject(structParent);
            if (structureElement != null && structureElement.getType() == COSObjType.COS_DICT) {
                return structureElement;
            }
        }
        return null;
    }

    private List<CosLang> getLang() {
        PDStructTreeRoot structTreeRoot = StaticResources.getDocument().getStructTreeRoot();
        Long structParent = ((PDAnnotation)this.simplePDObject).getStructParent();
        if (structTreeRoot != null && structParent != null) {
            COSObject baseLang;
            COSObject structureElement;
            PDNumberTreeNode parentTreeRoot = structTreeRoot.getParentTree();
            COSObject cOSObject = structureElement = parentTreeRoot == null ? null : parentTreeRoot.getObject(structParent);
            if (structureElement != null && (baseLang = structureElement.getKey(ASAtom.LANG)) != null && baseLang.getType() == COSObjType.COS_STRING) {
                ArrayList<GFCosLang> list = new ArrayList<GFCosLang>(1);
                list.add(new GFCosLang((COSString)baseLang.getDirectBase()));
                return Collections.unmodifiableList(list);
            }
        }
        return Collections.emptyList();
    }

    private List<CosBM> getBM() {
        if (this.blendMode == null) {
            this.blendMode = this.parseBM();
        }
        return this.blendMode;
    }

    private List<CosBM> parseBM() {
        if (StaticContainers.getFlavour().getPart() != PDFAFlavour.Specification.ISO_19005_4) {
            return Collections.emptyList();
        }
        COSObject BM = ((PDAnnotation)this.simplePDObject).getBM();
        if (BM != null && BM.getType() == COSObjType.COS_NAME) {
            if (!ASAtom.NORMAL.equals((Object)BM.getName())) {
                this.containsTransparency = true;
            }
            ArrayList<GFCosBM> list = new ArrayList<GFCosBM>(1);
            list.add(new GFCosBM((COSName)BM.getDirectBase()));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    public String getContents() {
        return ((PDAnnotation)this.simplePDObject).getContents();
    }

    public String getAlt() {
        PDStructTreeRoot structTreeRoot = StaticResources.getDocument().getStructTreeRoot();
        Long structParent = ((PDAnnotation)this.simplePDObject).getStructParent();
        if (structTreeRoot != null && structParent != null) {
            COSObject baseAlt;
            COSObject structureElement;
            PDNumberTreeNode parentTreeRoot = structTreeRoot.getParentTree();
            COSObject cOSObject = structureElement = parentTreeRoot == null ? null : parentTreeRoot.getObject(structParent);
            if (structureElement != null && (baseAlt = structureElement.getKey(ASAtom.ALT)) != null && baseAlt.getType() == COSObjType.COS_STRING) {
                return baseAlt.getDirectBase().toString();
            }
        }
        return null;
    }

    public Boolean getisOutsideCropBox() {
        double[] cropBox = this.page.getCropBox();
        double[] rectangle = ((PDAnnotation)this.simplePDObject).getRect();
        if (rectangle != null && rectangle.length >= 4) {
            return cropBox[1] >= rectangle[3] || cropBox[0] >= rectangle[2] || cropBox[3] <= rectangle[1] || cropBox[2] <= rectangle[0];
        }
        return null;
    }

    private static Double getDifference(double[] array, int shift) {
        if (array != null && array.length > shift + 2) {
            return array[shift + 2] - array[shift];
        }
        return null;
    }

    public Boolean getcontainsA() {
        return this.simplePDObject.knownKey(ASAtom.A);
    }

    public List<? extends org.verapdf.model.baselayer.Object> getLinkedObjects(String link) {
        switch (link) {
            case "AA": {
                return this.getAdditionalActions();
            }
            case "A": {
                return this.getA();
            }
            case "appearance": {
                return this.getAppearance();
            }
            case "Lang": {
                return this.getLang();
            }
            case "BM": {
                return this.getBM();
            }
        }
        return super.getLinkedObjects(link);
    }

    private List<PDAdditionalActions> getAdditionalActions() {
        PDAnnotationAdditionalActions additionalActions = ((PDAnnotation)this.simplePDObject).getAdditionalActions();
        if (additionalActions != null) {
            ArrayList<GFPDAdditionalActions> actions = new ArrayList<GFPDAdditionalActions>(1);
            actions.add(new GFPDAdditionalActions((PDAbstractAdditionalActions)additionalActions));
            return Collections.unmodifiableList(actions);
        }
        return Collections.emptyList();
    }

    private List<PDAction> getA() {
        org.verapdf.pd.actions.PDAction action = ((PDAnnotation)this.simplePDObject).getA();
        if (action != null) {
            ArrayList<PDAction> res = new ArrayList<PDAction>(1);
            res.add(GFPDAction.getAction(action));
            return Collections.unmodifiableList(res);
        }
        return Collections.emptyList();
    }

    private List<PDXForm> getAppearance() {
        if (this.appearance == null) {
            this.appearance = this.parseAppearance();
        }
        return this.appearance;
    }

    boolean isContainsTransparency() {
        if (this.appearance == null) {
            this.appearance = this.parseAppearance();
        }
        if (this.blendMode == null) {
            this.blendMode = this.parseBM();
        }
        return this.containsTransparency;
    }

    private List<PDXForm> parseAppearance() {
        PDAppearanceEntry normalAppearance = ((PDAnnotation)this.simplePDObject).getNormalAppearance();
        PDAppearanceEntry downAppearance = ((PDAnnotation)this.simplePDObject).getDownAppearance();
        PDAppearanceEntry rolloverAppearance = ((PDAnnotation)this.simplePDObject).getRolloverAppearance();
        if (normalAppearance != null || downAppearance != null || rolloverAppearance != null) {
            ArrayList<PDXForm> appearances = new ArrayList<PDXForm>();
            this.addContentStreamsFromAppearanceEntry(normalAppearance, appearances);
            this.addContentStreamsFromAppearanceEntry(downAppearance, appearances);
            this.addContentStreamsFromAppearanceEntry(rolloverAppearance, appearances);
            return Collections.unmodifiableList(appearances);
        }
        return Collections.emptyList();
    }

    private void addContentStreamsFromAppearanceEntry(PDAppearanceEntry appearanceEntry, List<PDXForm> appearances) {
        if (appearanceEntry != null) {
            if (appearanceEntry.isSubDictionary()) {
                Map subDictionary = appearanceEntry.getSubDictionary();
                for (PDAppearanceStream stream : subDictionary.values()) {
                    this.addAppearance(appearances, stream);
                }
            } else {
                this.addAppearance(appearances, appearanceEntry.getAppearanceStream());
            }
        }
    }

    private void addAppearance(List<PDXForm> list, PDAppearanceStream toAdd) {
        if (toAdd != null) {
            PDResourcesHandler resources = this.resources.getExtendedResources(toAdd.getResources());
            List<CosLang> annotLang = this.getLang();
            GFPDXForm xForm = new GFPDXForm((org.verapdf.pd.images.PDXForm)toAdd, resources, null, this.getstructParentType(), "", annotLang.isEmpty() ? null : annotLang.get(0).getunicodeValue());
            this.containsTransparency |= xForm.containsTransparency();
            list.add(xForm);
        }
    }

    public static GFPDAnnot createAnnot(PDAnnotation annot, PDResourcesHandler pageResources, PDPage page) {
        String subtypeString;
        ASAtom subtype = annot.getSubtype();
        if (subtype == null) {
            return new GFPDAnnot(annot, pageResources, page);
        }
        switch (subtypeString = subtype.getValue()) {
            case "3D": {
                return new GFPD3DAnnot(annot, pageResources, page);
            }
            case "FileAttachment": {
                return new GFPDFileAttachmentAnnot(annot, pageResources, page);
            }
            case "Ink": {
                return new GFPDInkAnnot(annot, pageResources, page);
            }
            case "Link": {
                return new GFPDLinkAnnot(annot, pageResources, page);
            }
            case "Movie": {
                return new GFPDMovieAnnot(annot, pageResources, page);
            }
            case "Popup": {
                return new GFPDPopupAnnot(annot, pageResources, page);
            }
            case "PrinterMark": {
                return new GFPDPrinterMarkAnnot(annot, pageResources, page);
            }
            case "RichMedia": {
                return new GFPDRichMediaAnnot(annot, pageResources, page);
            }
            case "Screen": {
                return new GFPDScreenAnnot(annot, pageResources, page);
            }
            case "Sound": {
                return new GFPDSoundAnnot(annot, pageResources, page);
            }
            case "Stamp": {
                return new GFPDRubberStampAnnot(annot, pageResources, page);
            }
            case "TrapNet": {
                return new GFPDTrapNetAnnot(annot, pageResources, page);
            }
            case "Widget": {
                return new GFPDWidgetAnnot((PDWidgetAnnotation)annot, pageResources, page);
            }
            case "Caret": 
            case "Circle": 
            case "FreeText": 
            case "Highlight": 
            case "Line": 
            case "Polygon": 
            case "PolyLine": 
            case "Redact": 
            case "StrikeOut": 
            case "Square": 
            case "Squiggly": 
            case "Text": 
            case "Underline": {
                return new GFPDMarkupAnnot(annot, pageResources, page);
            }
        }
        return new GFPDAnnot(annot, pageResources, page);
    }
}

