/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.arlington;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSArray;
import org.verapdf.cos.COSBase;
import org.verapdf.cos.COSDictionary;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.cos.COSStream;
import org.verapdf.gf.model.impl.arlington.GFAAuthCode;
import org.verapdf.gf.model.impl.arlington.GFACatalog;
import org.verapdf.gf.model.impl.arlington.GFADocInfo;
import org.verapdf.gf.model.impl.arlington.GFAEncryptionPublicKey;
import org.verapdf.gf.model.impl.arlington.GFAEncryptionStandard;
import org.verapdf.gf.model.impl.arlington.GFAObject;
import org.verapdf.gf.model.impl.arlington.GFATrailerIDArray;
import org.verapdf.gf.model.impl.arlington.GFAXRefStream;
import org.verapdf.gf.model.impl.containers.StaticContainers;
import org.verapdf.model.alayer.AAuthCode;
import org.verapdf.model.alayer.ACatalog;
import org.verapdf.model.alayer.ADocInfo;
import org.verapdf.model.alayer.AFileTrailer;
import org.verapdf.model.alayer.ATrailerIDArray;
import org.verapdf.model.alayer.AXRefStream;
import org.verapdf.tools.StaticResources;

public class GFAFileTrailer
extends GFAObject
implements AFileTrailer {
    public GFAFileTrailer(COSBase baseObject, COSBase parentObject, String keyName) {
        super(baseObject, parentObject, keyName, "AFileTrailer");
    }

    public List<? extends org.verapdf.model.baselayer.Object> getLinkedObjects(String link) {
        switch (link) {
            case "AuthCode": {
                return this.getAuthCode();
            }
            case "Encrypt": {
                return this.getEncrypt();
            }
            case "entryID": {
                return this.getentryID();
            }
            case "Info": {
                return this.getInfo();
            }
            case "Root": {
                return this.getRoot();
            }
            case "XRefStream": {
                return this.getXRefStream();
            }
        }
        return super.getLinkedObjects(link);
    }

    private List<AAuthCode> getAuthCode() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON2_0: {
                return this.getAuthCode2_0();
            }
        }
        return Collections.emptyList();
    }

    private List<AAuthCode> getAuthCode2_0() {
        COSObject object = this.getAuthCodeValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_DICT) {
            ArrayList<GFAAuthCode> list = new ArrayList<GFAAuthCode>(1);
            list.add(new GFAAuthCode((COSBase)((COSDictionary)object.getDirectBase()), this.baseObject, "AuthCode"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<org.verapdf.model.baselayer.Object> getEncrypt() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON2_0: 
            case ARLINGTON1_1: 
            case ARLINGTON1_2: 
            case ARLINGTON1_3: 
            case ARLINGTON1_4: 
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: {
                return this.getEncrypt1_1();
            }
        }
        return Collections.emptyList();
    }

    private List<org.verapdf.model.baselayer.Object> getEncrypt1_1() {
        COSObject object = this.getEncryptValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_DICT) {
            org.verapdf.model.baselayer.Object result = this.getEncryptDictionary1_1(object.getDirectBase(), "Encrypt");
            ArrayList<org.verapdf.model.baselayer.Object> list = new ArrayList<org.verapdf.model.baselayer.Object>(1);
            if (result != null) {
                list.add(result);
            }
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private org.verapdf.model.baselayer.Object getEncryptDictionary1_1(COSBase base, String keyName) {
        COSObject subtype = base.getKey(ASAtom.getASAtom((String)"Filter"));
        if (subtype == null) {
            return null;
        }
        String subtypeValue = subtype.getString();
        if (subtypeValue == null) {
            return new GFAEncryptionPublicKey(base, this.baseObject, keyName);
        }
        switch (subtypeValue) {
            case "Adobe.PubSec": {
                return new GFAEncryptionPublicKey(base, this.baseObject, keyName);
            }
            case "AdobePPKLite": {
                return new GFAEncryptionPublicKey(base, this.baseObject, keyName);
            }
            case "Standard": {
                return new GFAEncryptionStandard(base, this.baseObject, keyName);
            }
        }
        return null;
    }

    private List<ATrailerIDArray> getentryID() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON2_0: 
            case ARLINGTON1_1: 
            case ARLINGTON1_2: 
            case ARLINGTON1_3: 
            case ARLINGTON1_4: 
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: {
                return this.getentryID1_1();
            }
        }
        return Collections.emptyList();
    }

    private List<ATrailerIDArray> getentryID1_1() {
        COSObject object = this.getentryIDValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_ARRAY) {
            ArrayList<GFATrailerIDArray> list = new ArrayList<GFATrailerIDArray>(1);
            list.add(new GFATrailerIDArray((COSBase)((COSArray)object.getDirectBase()), this.baseObject, "ID"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<ADocInfo> getInfo() {
        return this.getInfo1_0();
    }

    private List<ADocInfo> getInfo1_0() {
        COSObject object = this.getInfoValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_DICT) {
            ArrayList<GFADocInfo> list = new ArrayList<GFADocInfo>(1);
            list.add(new GFADocInfo((COSBase)((COSDictionary)object.getDirectBase()), this.baseObject, "Info"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<ACatalog> getRoot() {
        return this.getRoot1_0();
    }

    private List<ACatalog> getRoot1_0() {
        COSObject object = this.getRootValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_DICT) {
            ArrayList<GFACatalog> list = new ArrayList<GFACatalog>(1);
            list.add(new GFACatalog((COSBase)((COSDictionary)object.getDirectBase()), this.baseObject, "Root"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<AXRefStream> getXRefStream() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON2_0: 
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: {
                return this.getXRefStream1_5();
            }
        }
        return Collections.emptyList();
    }

    private List<AXRefStream> getXRefStream1_5() {
        COSObject object = this.getXRefStreamValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_STREAM) {
            ArrayList<GFAXRefStream> list = new ArrayList<GFAXRefStream>(1);
            list.add(new GFAXRefStream((COSBase)((COSStream)object.getDirectBase()), this.baseObject, "XRefStream"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    public Boolean getcontainsAuthCode() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"AuthCode"));
    }

    public COSObject getAuthCodeValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"AuthCode"));
        return object;
    }

    public Boolean getisAuthCodeIndirect() {
        COSObject AuthCode = this.getAuthCodeValue();
        return GFAFileTrailer.getisIndirect(AuthCode);
    }

    public String getAuthCodeType() {
        COSObject AuthCode = this.getAuthCodeValue();
        return this.getObjectType(AuthCode);
    }

    public Boolean getAuthCodeHasTypeDictionary() {
        COSObject AuthCode = this.getAuthCodeValue();
        return GFAFileTrailer.getHasTypeDictionary(AuthCode);
    }

    public Boolean getcontainsEncrypt() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"Encrypt"));
    }

    public COSObject getEncryptValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Encrypt"));
        return object;
    }

    public String getEncryptType() {
        COSObject Encrypt = this.getEncryptValue();
        return this.getObjectType(Encrypt);
    }

    public Boolean getEncryptHasTypeDictionary() {
        COSObject Encrypt = this.getEncryptValue();
        return GFAFileTrailer.getHasTypeDictionary(Encrypt);
    }

    public Boolean getcontainsID() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"ID"));
    }

    public COSObject getentryIDValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"ID"));
        return object;
    }

    public Boolean getisentryIDIndirect() {
        COSObject entryID = this.getentryIDValue();
        return GFAFileTrailer.getisIndirect(entryID);
    }

    public String getentryIDType() {
        COSObject entryID = this.getentryIDValue();
        return this.getObjectType(entryID);
    }

    public Boolean getentryIDHasTypeArray() {
        COSObject entryID = this.getentryIDValue();
        return GFAFileTrailer.getHasTypeArray(entryID);
    }

    public Boolean getcontainsInfo() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"Info"));
    }

    public COSObject getInfoValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Info"));
        return object;
    }

    public Boolean getisInfoIndirect() {
        COSObject Info = this.getInfoValue();
        return GFAFileTrailer.getisIndirect(Info);
    }

    public String getInfoType() {
        COSObject Info = this.getInfoValue();
        return this.getObjectType(Info);
    }

    public Boolean getInfoHasTypeDictionary() {
        COSObject Info = this.getInfoValue();
        return GFAFileTrailer.getHasTypeDictionary(Info);
    }

    public Boolean getcontainsPrev() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"Prev"));
    }

    public COSObject getPrevValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Prev"));
        return object;
    }

    public Boolean getisPrevIndirect() {
        COSObject Prev = this.getPrevValue();
        return GFAFileTrailer.getisIndirect(Prev);
    }

    public String getPrevType() {
        COSObject Prev = this.getPrevValue();
        return this.getObjectType(Prev);
    }

    public Boolean getPrevHasTypeInteger() {
        COSObject Prev = this.getPrevValue();
        return GFAFileTrailer.getHasTypeInteger(Prev);
    }

    public Long getPrevIntegerValue() {
        COSObject Prev = this.getPrevValue();
        return GFAFileTrailer.getIntegerValue(Prev);
    }

    public Boolean getcontainsRoot() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"Root"));
    }

    public COSObject getRootValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Root"));
        return object;
    }

    public Boolean getisRootIndirect() {
        COSObject Root = this.getRootValue();
        return GFAFileTrailer.getisIndirect(Root);
    }

    public String getRootType() {
        COSObject Root = this.getRootValue();
        return this.getObjectType(Root);
    }

    public Boolean getRootHasTypeDictionary() {
        COSObject Root = this.getRootValue();
        return GFAFileTrailer.getHasTypeDictionary(Root);
    }

    public Boolean getcontainsSize() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"Size"));
    }

    public COSObject getSizeValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Size"));
        return object;
    }

    public Boolean getisSizeIndirect() {
        COSObject Size = this.getSizeValue();
        return GFAFileTrailer.getisIndirect(Size);
    }

    public String getSizeType() {
        COSObject Size = this.getSizeValue();
        return this.getObjectType(Size);
    }

    public Boolean getSizeHasTypeInteger() {
        COSObject Size = this.getSizeValue();
        return GFAFileTrailer.getHasTypeInteger(Size);
    }

    public Long getSizeIntegerValue() {
        COSObject Size = this.getSizeValue();
        return GFAFileTrailer.getIntegerValue(Size);
    }

    public Boolean getcontainsXRefStm() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"XRefStm"));
    }

    public COSObject getXRefStmValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"XRefStm"));
        return object;
    }

    public String getXRefStmType() {
        COSObject XRefStm = this.getXRefStmValue();
        return this.getObjectType(XRefStm);
    }

    public Boolean getXRefStmHasTypeInteger() {
        COSObject XRefStm = this.getXRefStmValue();
        return GFAFileTrailer.getHasTypeInteger(XRefStm);
    }

    public Long getXRefStmIntegerValue() {
        COSObject XRefStm = this.getXRefStmValue();
        return GFAFileTrailer.getIntegerValue(XRefStm);
    }

    public Boolean getcontainsXRefStream() {
        return this.getcontainsXRefStm();
    }

    public COSObject getXRefStreamValue() {
        Long offset = this.getXRefStmIntegerValue();
        COSObject object = offset != null ? StaticResources.getDocument().getDocument().getObject(offset.longValue()) : null;
        return object;
    }

    public String getXRefStreamType() {
        COSObject XRefStream = this.getXRefStreamValue();
        return this.getObjectType(XRefStream);
    }

    public Boolean getXRefStreamHasTypeStream() {
        COSObject XRefStream = this.getXRefStreamValue();
        return GFAFileTrailer.getHasTypeStream(XRefStream);
    }

    public COSObject getEncryptVValue() {
        if (this.baseObject == null || !this.baseObject.getType().isDictionaryBased()) {
            return null;
        }
        COSObject Encrypt = this.baseObject.getKey(ASAtom.getASAtom((String)"Encrypt"));
        if (Encrypt == null || !Encrypt.getType().isDictionaryBased()) {
            return null;
        }
        COSObject V = Encrypt.getKey(ASAtom.getASAtom((String)"V"));
        return V;
    }

    public COSObject gettrailerCatalogValue() {
        COSObject trailer = StaticResources.getDocument().getDocument().getTrailer().getObject();
        if (trailer == null || !trailer.getType().isDictionaryBased()) {
            return null;
        }
        COSObject Root = trailer.getKey(ASAtom.getASAtom((String)"Root"));
        return Root;
    }

    public COSObject gettrailerInfoValue() {
        COSObject trailer = StaticResources.getDocument().getDocument().getTrailer().getObject();
        if (trailer == null || !trailer.getType().isDictionaryBased()) {
            return null;
        }
        COSObject Info = trailer.getKey(ASAtom.getASAtom((String)"Info"));
        return Info;
    }

    public Long getEncryptVIntegerValue() {
        COSObject EncryptV = this.getEncryptVValue();
        return GFAFileTrailer.getIntegerValue(EncryptV);
    }

    public Boolean getEncryptVHasTypeInteger() {
        COSObject EncryptV = this.getEncryptVValue();
        return GFAFileTrailer.getHasTypeInteger(EncryptV);
    }

    public Boolean getcontainstrailerCatalogPieceInfo() {
        COSObject trailerCatalog = this.gettrailerCatalogValue();
        return trailerCatalog.knownKey(ASAtom.getASAtom((String)"PieceInfo"));
    }

    public Boolean getcontainstrailerInfoModDate() {
        COSObject trailerInfo = this.gettrailerInfoValue();
        return trailerInfo.knownKey(ASAtom.getASAtom((String)"ModDate"));
    }

    public Boolean gethasExtensionISO_TS_32004() {
        return false;
    }
}

