/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.EnumSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.verapdf.ReleaseDetails;
import org.verapdf.as.ASAtom;
import org.verapdf.component.ComponentDetails;
import org.verapdf.component.Components;
import org.verapdf.core.EncryptedPdfException;
import org.verapdf.core.ModelParsingException;
import org.verapdf.cos.COSDocument;
import org.verapdf.exceptions.InvalidPasswordException;
import org.verapdf.extensions.ExtensionObjectType;
import org.verapdf.features.AbstractFeaturesExtractor;
import org.verapdf.features.FeatureExtractionResult;
import org.verapdf.features.FeatureExtractorConfig;
import org.verapdf.features.gf.GFFeatureParser;
import org.verapdf.gf.model.impl.arlington.GFADocument;
import org.verapdf.gf.model.impl.arlington.GFAObject;
import org.verapdf.gf.model.impl.containers.StaticContainers;
import org.verapdf.gf.model.impl.cos.GFCosDocument;
import org.verapdf.metadata.fixer.entity.PDFDocument;
import org.verapdf.metadata.fixer.gf.impl.model.PDFDocumentImpl;
import org.verapdf.parser.PDFFlavour;
import org.verapdf.pd.PDCatalog;
import org.verapdf.pd.PDDocument;
import org.verapdf.pd.PDMetadata;
import org.verapdf.pdfa.PDFAParser;
import org.verapdf.pdfa.flavours.PDFAFlavour;
import org.verapdf.pdfa.flavours.PDFFlavours;
import org.verapdf.tools.StaticResources;
import org.verapdf.xmp.XMPException;
import org.verapdf.xmp.containers.StaticXmpCoreContainers;
import org.verapdf.xmp.impl.VeraPDFMeta;

public class GFModelParser
implements PDFAParser {
    private static final ReleaseDetails greenfieldDetails = ReleaseDetails.addDetailsFromResource((String)"org/verapdf/release/validation-model.properties");
    private static final URI id = URI.create("http://pdfa.verapdf.org/parser#verapdf");
    private static final ComponentDetails details = Components.veraDetails((URI)id, (String)"VeraPDF Parser", (String)greenfieldDetails.getVersion(), (String)"veraPDF greenfield PDF parser.");
    private static final Logger logger = Logger.getLogger(GFModelParser.class.getCanonicalName());
    private static final String PDFUA_PREFIX = "ua";
    private final PDDocument document;
    private final PDFAFlavour flavour;

    private GFModelParser(InputStream docStream, PDFAFlavour flavour, PDFAFlavour defaultFlavour, String password, EnumSet<ExtensionObjectType> enabledExtensions) throws IOException {
        try {
            GFModelParser.clearStaticContainers();
            GFModelParser.initializeStaticResources(password);
            this.document = new PDDocument(docStream);
            this.flavour = GFModelParser.detectFlavour(this.document, flavour, defaultFlavour);
            GFModelParser.initializeStaticContainers(this.document, this.flavour, enabledExtensions);
        }
        catch (Throwable t) {
            this.close();
            throw t;
        }
    }

    private GFModelParser(File pdfFile, PDFAFlavour flavour, PDFAFlavour defaultFlavour, String password, EnumSet<ExtensionObjectType> enabledExtensions) throws IOException {
        try {
            GFModelParser.clearStaticContainers();
            GFModelParser.initializeStaticResources(password);
            this.document = new PDDocument(pdfFile.getAbsolutePath());
            this.flavour = GFModelParser.detectFlavour(this.document, flavour, defaultFlavour);
            GFModelParser.initializeStaticContainers(this.document, this.flavour, enabledExtensions);
        }
        catch (Throwable t) {
            this.close();
            throw t;
        }
    }

    private static PDFAFlavour detectFlavour(PDDocument document, PDFAFlavour flavour, PDFAFlavour defaultFlavour) {
        if (flavour == PDFAFlavour.NO_FLAVOUR || flavour == PDFAFlavour.NO_ARLINGTON_FLAVOUR) {
            return GFModelParser.obtainArlingtonFlavour(document, defaultFlavour != PDFAFlavour.NO_FLAVOUR && defaultFlavour != PDFAFlavour.NO_ARLINGTON_FLAVOUR ? defaultFlavour : PDFAFlavour.ARLINGTON1_4);
        }
        return flavour;
    }

    public static GFModelParser createModelWithFlavour(InputStream toLoad, PDFAFlavour flavour) throws ModelParsingException, EncryptedPdfException {
        return GFModelParser.createModelWithFlavour(toLoad, flavour, PDFAFlavour.NO_FLAVOUR);
    }

    public static GFModelParser createModelWithFlavour(InputStream toLoad, PDFAFlavour flavour, PDFAFlavour defaultFlavour) throws ModelParsingException, EncryptedPdfException {
        return GFModelParser.createModelWithFlavour(toLoad, flavour, defaultFlavour, null, EnumSet.noneOf(ExtensionObjectType.class));
    }

    public static GFModelParser createModelWithFlavour(InputStream toLoad, PDFAFlavour flavour, String password) throws ModelParsingException, EncryptedPdfException {
        return GFModelParser.createModelWithFlavour(toLoad, flavour, PDFAFlavour.NO_FLAVOUR, password, EnumSet.noneOf(ExtensionObjectType.class));
    }

    public static GFModelParser createModelWithFlavour(InputStream toLoad, PDFAFlavour flavour, PDFAFlavour defaultFlavour, String password, EnumSet<ExtensionObjectType> enabledExtensions) throws ModelParsingException, EncryptedPdfException {
        try {
            return new GFModelParser(toLoad, flavour, defaultFlavour, password, enabledExtensions);
        }
        catch (InvalidPasswordException excep) {
            throw new EncryptedPdfException("The PDF stream appears to be encrypted.", (Throwable)excep);
        }
        catch (IOException e) {
            throw new ModelParsingException("Couldn't parse stream", (Throwable)e);
        }
    }

    public static GFModelParser createModelWithFlavour(File pdfFile, PDFAFlavour flavour) throws ModelParsingException, EncryptedPdfException {
        return GFModelParser.createModelWithFlavour(pdfFile, flavour, PDFAFlavour.NO_FLAVOUR);
    }

    public static GFModelParser createModelWithFlavour(File pdfFile, PDFAFlavour flavour, PDFAFlavour defaultFlavour) throws ModelParsingException, EncryptedPdfException {
        return GFModelParser.createModelWithFlavour(pdfFile, flavour, defaultFlavour, null, EnumSet.noneOf(ExtensionObjectType.class));
    }

    public static GFModelParser createModelWithFlavour(File pdfFile, PDFAFlavour flavour, String password) throws ModelParsingException, EncryptedPdfException {
        return GFModelParser.createModelWithFlavour(pdfFile, flavour, PDFAFlavour.NO_FLAVOUR, password, EnumSet.noneOf(ExtensionObjectType.class));
    }

    public static GFModelParser createModelWithFlavour(File pdfFile, PDFAFlavour flavour, PDFAFlavour defaultFlavour, String password, EnumSet<ExtensionObjectType> enabledExtensions) throws ModelParsingException, EncryptedPdfException {
        try {
            return new GFModelParser(pdfFile, flavour, defaultFlavour, password, enabledExtensions);
        }
        catch (InvalidPasswordException excep) {
            throw new EncryptedPdfException("The PDF stream appears to be encrypted.", (Throwable)excep);
        }
        catch (IOException e) {
            throw new ModelParsingException("Couldn't parse stream", (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static PDFAFlavour obtainFlavour(PDDocument document, PDFAFlavour defaultFlavour) {
        if (document == null) return defaultFlavour;
        if (document.getCatalog() == null) {
            return defaultFlavour;
        }
        PDMetadata metadata = document.getCatalog().getMetadata();
        if (metadata == null) {
            return defaultFlavour;
        }
        try (InputStream is = metadata.getStream();){
            VeraPDFMeta veraPDFMeta = VeraPDFMeta.parse((InputStream)is);
            PDFAFlavour pdfaFlavour = GFModelParser.detectPDFAFlavour(veraPDFMeta);
            if (!PDFFlavours.isFlavour((PDFAFlavour)pdfaFlavour, (PDFAFlavour)PDFAFlavour.NO_FLAVOUR)) {
                PDFAFlavour pDFAFlavour = pdfaFlavour;
                return pDFAFlavour;
            }
            PDFAFlavour pdfuaFlavour = GFModelParser.detectPDFUAFlavour(veraPDFMeta);
            if (!PDFFlavours.isFlavour((PDFAFlavour)pdfuaFlavour, (PDFAFlavour)PDFAFlavour.NO_FLAVOUR)) {
                PDFAFlavour pDFAFlavour = pdfuaFlavour;
                return pDFAFlavour;
            }
            PDFAFlavour wtpdfFlavour = GFModelParser.detectWTPDFFlavour(veraPDFMeta);
            if (!PDFFlavours.isFlavour((PDFAFlavour)wtpdfFlavour, (PDFAFlavour)PDFAFlavour.NO_FLAVOUR)) {
                PDFAFlavour pDFAFlavour = wtpdfFlavour;
                return pDFAFlavour;
            }
            PDFAFlavour pDFAFlavour = defaultFlavour;
            return pDFAFlavour;
        }
        catch (IOException | XMPException e) {
            logger.log(Level.FINE, e.getMessage(), e);
            return defaultFlavour;
        }
    }

    private static PDFAFlavour obtainArlingtonFlavour(PDDocument document, PDFAFlavour defaultFlavour) {
        Float version;
        if (document == null) {
            return defaultFlavour;
        }
        COSDocument cosDocument = document.getDocument();
        Float f = version = cosDocument != null ? Float.valueOf(cosDocument.getHeader().getVersion()) : null;
        if (version == null) {
            PDCatalog catalog = document.getCatalog();
            ASAtom versionValue = catalog != null ? catalog.getNameKey(ASAtom.VERSION) : null;
            Float f2 = version = versionValue != null ? Float.valueOf(versionValue.getValue()) : null;
        }
        if (version == null) {
            return defaultFlavour;
        }
        if (version.floatValue() <= 1.4f) {
            version = Float.valueOf(1.4f);
        } else if (version.floatValue() <= 1.7f) {
            version = Float.valueOf(1.7f);
        }
        PDFAFlavour flavour = PDFAFlavour.byFlavourId((String)("arlington" + version));
        return flavour != PDFAFlavour.NO_FLAVOUR ? flavour : defaultFlavour;
    }

    private static PDFAFlavour detectPDFAFlavour(VeraPDFMeta veraPDFMeta) {
        try {
            Integer identificationPart = veraPDFMeta.getPDFAIdentificationPart();
            String identificationConformance = veraPDFMeta.getPDFAIdentificationConformance();
            if (identificationConformance == null) {
                identificationConformance = "";
            }
            return PDFAFlavour.byFlavourId((String)(identificationPart + identificationConformance));
        }
        catch (XMPException e) {
            logger.log(Level.FINE, e.getMessage(), e);
            return PDFAFlavour.NO_FLAVOUR;
        }
    }

    private static PDFAFlavour detectWTPDFFlavour(VeraPDFMeta veraPDFMeta) {
        if (veraPDFMeta.containsDeclaration("http://pdfa.org/declarations/wtpdf#accessibility1.0")) {
            return PDFAFlavour.WTPDF_1_0_ACCESSIBILITY;
        }
        if (veraPDFMeta.containsDeclaration("http://pdfa.org/declarations/wtpdf#reuse1.0")) {
            return PDFAFlavour.WTPDF_1_0_REUSE;
        }
        return PDFAFlavour.NO_FLAVOUR;
    }

    private static PDFAFlavour detectPDFUAFlavour(VeraPDFMeta veraPDFMeta) {
        try {
            Integer identificationPart = veraPDFMeta.getPDFUAIdentificationPart();
            return PDFAFlavour.byFlavourId((String)(PDFUA_PREFIX + identificationPart));
        }
        catch (XMPException e) {
            logger.log(Level.FINE, e.getMessage(), e);
            return PDFAFlavour.NO_FLAVOUR;
        }
    }

    private static void initializeStaticContainers(PDDocument document, PDFAFlavour flavour, EnumSet<ExtensionObjectType> enabledExtensions) {
        StaticResources.setDocument((PDDocument)document);
        StaticContainers.setFlavour(flavour);
        StaticContainers.setEnabledExtensions(enabledExtensions);
        StaticResources.setFlavour((PDFFlavour)PDFFlavour.NO_FLAVOUR);
    }

    private static void initializeStaticResources(String password) {
        StaticResources.setPassword((String)password);
    }

    private static void clearStaticContainers() {
        StaticContainers.clearAllContainers();
        StaticResources.clear();
        StaticXmpCoreContainers.clearAllContainers();
    }

    public PDDocument getPDDocument() {
        return this.document;
    }

    public org.verapdf.model.baselayer.Object getRoot() {
        if (PDFAFlavour.SpecificationFamily.ARLINGTON == this.flavour.getPart().getFamily()) {
            GFAObject.clearAllContainers();
            return new GFADocument(null, null, null);
        }
        return new GFCosDocument(this.document.getDocument());
    }

    public ComponentDetails getDetails() {
        return details;
    }

    public PDFAFlavour getFlavour() {
        return this.flavour;
    }

    public PDFDocument getPDFDocument() {
        return new PDFDocumentImpl(this.document);
    }

    public FeatureExtractionResult getFeatures(FeatureExtractorConfig config) {
        return GFFeatureParser.getFeaturesCollection((PDDocument)this.document, (FeatureExtractorConfig)config);
    }

    public FeatureExtractionResult getFeatures(FeatureExtractorConfig config, List<AbstractFeaturesExtractor> extractors) {
        return GFFeatureParser.getFeaturesCollection((PDDocument)this.document, extractors, (FeatureExtractorConfig)config);
    }

    public void close() {
        if (this.document != null) {
            this.document.close();
        }
    }
}

