/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.arlington;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSArray;
import org.verapdf.cos.COSBase;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.gf.model.impl.arlington.GFANumberTreeNodeLimitsArray;
import org.verapdf.gf.model.impl.arlington.GFANumberTreeNodeNumsArray;
import org.verapdf.gf.model.impl.arlington.GFANumberTreeNodesArray;
import org.verapdf.gf.model.impl.arlington.GFAObject;
import org.verapdf.gf.model.impl.containers.StaticContainers;
import org.verapdf.model.alayer.ANumberTreeNode;
import org.verapdf.model.alayer.ANumberTreeNodeLimitsArray;
import org.verapdf.model.alayer.ANumberTreeNodeNumsArray;
import org.verapdf.model.alayer.ANumberTreeNodesArray;
import org.verapdf.model.baselayer.Object;

public class GFANumberTreeNode
extends GFAObject
implements ANumberTreeNode {
    public GFANumberTreeNode(COSBase baseObject, COSBase parentObject, String keyName) {
        super(baseObject, parentObject, keyName, "ANumberTreeNode");
    }

    public List<? extends Object> getLinkedObjects(String link) {
        switch (link) {
            case "Kids": {
                return this.getKids();
            }
            case "Limits": {
                return this.getLimits();
            }
            case "Nums": {
                return this.getNums();
            }
        }
        return super.getLinkedObjects(link);
    }

    private List<ANumberTreeNodesArray> getKids() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_3: 
            case ARLINGTON1_4: 
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return this.getKids1_3();
            }
        }
        return Collections.emptyList();
    }

    private List<ANumberTreeNodesArray> getKids1_3() {
        COSObject object = this.getKidsValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_ARRAY) {
            ArrayList<GFANumberTreeNodesArray> list = new ArrayList<GFANumberTreeNodesArray>(1);
            list.add(new GFANumberTreeNodesArray((COSBase)((COSArray)object.getDirectBase()), this.baseObject, "Kids"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<ANumberTreeNodeLimitsArray> getLimits() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_3: 
            case ARLINGTON1_4: 
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return this.getLimits1_3();
            }
        }
        return Collections.emptyList();
    }

    private List<ANumberTreeNodeLimitsArray> getLimits1_3() {
        COSObject object = this.getLimitsValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_ARRAY) {
            ArrayList<GFANumberTreeNodeLimitsArray> list = new ArrayList<GFANumberTreeNodeLimitsArray>(1);
            list.add(new GFANumberTreeNodeLimitsArray((COSBase)((COSArray)object.getDirectBase()), this.baseObject, "Limits"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<ANumberTreeNodeNumsArray> getNums() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_3: 
            case ARLINGTON1_4: 
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return this.getNums1_3();
            }
        }
        return Collections.emptyList();
    }

    private List<ANumberTreeNodeNumsArray> getNums1_3() {
        COSObject object = this.getNumsValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_ARRAY) {
            ArrayList<GFANumberTreeNodeNumsArray> list = new ArrayList<GFANumberTreeNodeNumsArray>(1);
            list.add(new GFANumberTreeNodeNumsArray((COSBase)((COSArray)object.getDirectBase()), this.baseObject, "Nums"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    public Boolean getcontainsKids() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"Kids"));
    }

    public COSObject getKidsValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Kids"));
        return object;
    }

    public String getKidsType() {
        COSObject Kids = this.getKidsValue();
        return this.getObjectType(Kids);
    }

    public Boolean getKidsHasTypeArray() {
        COSObject Kids = this.getKidsValue();
        return GFANumberTreeNode.getHasTypeArray(Kids);
    }

    public Boolean getcontainsLimits() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"Limits"));
    }

    public COSObject getLimitsValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Limits"));
        return object;
    }

    public String getLimitsType() {
        COSObject Limits = this.getLimitsValue();
        return this.getObjectType(Limits);
    }

    public Boolean getLimitsHasTypeArray() {
        COSObject Limits = this.getLimitsValue();
        return GFANumberTreeNode.getHasTypeArray(Limits);
    }

    public Boolean getcontainsNums() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"Nums"));
    }

    public COSObject getNumsValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Nums"));
        return object;
    }

    public String getNumsType() {
        COSObject Nums = this.getNumsValue();
        return this.getObjectType(Nums);
    }

    public Boolean getNumsHasTypeArray() {
        COSObject Nums = this.getNumsValue();
        return GFANumberTreeNode.getHasTypeArray(Nums);
    }
}

