/**
 * This file is part of veraPDF Validation, a module of the veraPDF project.
 * Copyright (c) 2015, veraPDF Consortium <info@verapdf.org>
 * All rights reserved.
 *
 * veraPDF Validation is free software: you can redistribute it and/or modify
 * it under the terms of either:
 *
 * The GNU General public license GPLv3+.
 * You should have received a copy of the GNU General Public License
 * along with veraPDF Validation as the LICENSE.GPL file in the root of the source
 * tree.  If not, see http://www.gnu.org/licenses/ or
 * https://www.gnu.org/licenses/gpl-3.0.en.html.
 *
 * The Mozilla Public License MPLv2+.
 * You should have received a copy of the Mozilla Public License along with
 * veraPDF Validation as the LICENSE.MPL file in the root of the source tree.
 * If a copy of the MPL was not distributed with this file, you can obtain one at
 * http://mozilla.org/MPL/2.0/.
 */
package org.verapdf.gf.model.impl.arlington;

import org.verapdf.cos.*;
import org.verapdf.model.alayer.*;
import org.verapdf.gf.model.impl.containers.StaticContainers;
import org.verapdf.tools.StaticResources;
import java.util.*;
import org.verapdf.pd.PDNameTreeNode;
import org.verapdf.as.ASAtom;
import java.util.stream.Collectors;
import org.verapdf.pd.structure.PDNumberTreeNode;

public class GFAOptContentZoom extends GFAObject implements AOptContentZoom {

	public GFAOptContentZoom(COSBase baseObject, COSBase parentObject, String keyName) {
		super(baseObject, parentObject, keyName, "AOptContentZoom");
	}

	@Override
	public Boolean getcontainsmax() {
		return this.baseObject.knownKey(ASAtom.getASAtom("max"));
	}

	public COSObject getmaxDefaultValue() {
		switch (StaticContainers.getFlavour()) {
			case ARLINGTON1_5:
			case ARLINGTON1_6:
			case ARLINGTON1_7:
			case ARLINGTON2_0:
				return COSReal.construct(999999.9D);
		}
		return null;
	}

	public COSObject getmaxValue() {
		COSObject object = this.baseObject.getKey(ASAtom.getASAtom("max"));
		if (object == null || object.empty()) {
			object = getmaxDefaultValue();
		}
		return object;
	}

	@Override
	public Boolean getmaxHasTypeNumber() {
		COSObject object = getmaxValue();
		return getHasTypeNumber(object);
	}

	@Override
	public Double getmaxNumberValue() {
		COSObject object = getmaxValue();
		return getNumberValue(object);
	}

	@Override
	public Boolean getcontainsmin() {
		return this.baseObject.knownKey(ASAtom.getASAtom("min"));
	}

	public COSObject getminDefaultValue() {
		switch (StaticContainers.getFlavour()) {
			case ARLINGTON1_5:
			case ARLINGTON1_6:
			case ARLINGTON1_7:
			case ARLINGTON2_0:
				return COSReal.construct(0.0D);
		}
		return null;
	}

	public COSObject getminValue() {
		COSObject object = this.baseObject.getKey(ASAtom.getASAtom("min"));
		if (object == null || object.empty()) {
			object = getminDefaultValue();
		}
		return object;
	}

	@Override
	public Boolean getminHasTypeNumber() {
		COSObject object = getminValue();
		return getHasTypeNumber(object);
	}

	@Override
	public Double getminNumberValue() {
		COSObject object = getminValue();
		return getNumberValue(object);
	}

}
