/**
 * This file is part of veraPDF Validation, a module of the veraPDF project.
 * Copyright (c) 2015, veraPDF Consortium <info@verapdf.org>
 * All rights reserved.
 *
 * veraPDF Validation is free software: you can redistribute it and/or modify
 * it under the terms of either:
 *
 * The GNU General public license GPLv3+.
 * You should have received a copy of the GNU General Public License
 * along with veraPDF Validation as the LICENSE.GPL file in the root of the source
 * tree.  If not, see http://www.gnu.org/licenses/ or
 * https://www.gnu.org/licenses/gpl-3.0.en.html.
 *
 * The Mozilla Public License MPLv2+.
 * You should have received a copy of the Mozilla Public License along with
 * veraPDF Validation as the LICENSE.MPL file in the root of the source tree.
 * If a copy of the MPL was not distributed with this file, you can obtain one at
 * http://mozilla.org/MPL/2.0/.
 */
package org.verapdf.gf.model.impl.arlington;

import org.verapdf.cos.*;
import org.verapdf.model.alayer.*;
import org.verapdf.gf.model.impl.containers.StaticContainers;
import org.verapdf.tools.StaticResources;
import java.util.*;
import org.verapdf.pd.PDNameTreeNode;
import org.verapdf.as.ASAtom;
import java.util.stream.Collectors;
import org.verapdf.pd.structure.PDNumberTreeNode;

public class GFADevExtensions extends GFAObject implements ADevExtensions {

	public GFADevExtensions(COSBase baseObject, COSBase parentObject, String keyName) {
		super(baseObject, parentObject, keyName, "ADevExtensions");
	}

	@Override
	public Boolean getcontainsBaseVersion() {
		return this.baseObject.knownKey(ASAtom.getASAtom("BaseVersion"));
	}

	public COSObject getBaseVersionValue() {
		COSObject object = this.baseObject.getKey(ASAtom.getASAtom("BaseVersion"));
		return object;
	}

	@Override
	public Boolean getisBaseVersionIndirect() {
		COSObject object = getBaseVersionValue();
		return getisIndirect(object);
	}

	@Override
	public Boolean getBaseVersionHasTypeName() {
		COSObject object = getBaseVersionValue();
		return getHasTypeName(object);
	}

	@Override
	public String getBaseVersionNameValue() {
		COSObject object = getBaseVersionValue();
		return getNameValue(object);
	}

	@Override
	public Boolean getcontainsExtensionLevel() {
		return this.baseObject.knownKey(ASAtom.getASAtom("ExtensionLevel"));
	}

	public COSObject getExtensionLevelValue() {
		COSObject object = this.baseObject.getKey(ASAtom.getASAtom("ExtensionLevel"));
		return object;
	}

	@Override
	public Boolean getisExtensionLevelIndirect() {
		COSObject object = getExtensionLevelValue();
		return getisIndirect(object);
	}

	@Override
	public Boolean getExtensionLevelHasTypeInteger() {
		COSObject object = getExtensionLevelValue();
		return getHasTypeInteger(object);
	}

	@Override
	public Boolean getcontainsExtensionRevision() {
		return this.baseObject.knownKey(ASAtom.getASAtom("ExtensionRevision"));
	}

	public COSObject getExtensionRevisionValue() {
		COSObject object = this.baseObject.getKey(ASAtom.getASAtom("ExtensionRevision"));
		return object;
	}

	@Override
	public Boolean getisExtensionRevisionIndirect() {
		COSObject object = getExtensionRevisionValue();
		return getisIndirect(object);
	}

	@Override
	public Boolean getExtensionRevisionHasTypeStringText() {
		COSObject object = getExtensionRevisionValue();
		return getHasTypeStringText(object);
	}

	@Override
	public Boolean getcontainsType() {
		return this.baseObject.knownKey(ASAtom.getASAtom("Type"));
	}

	public COSObject getTypeValue() {
		COSObject object = this.baseObject.getKey(ASAtom.getASAtom("Type"));
		return object;
	}

	@Override
	public Boolean getisTypeIndirect() {
		COSObject object = getTypeValue();
		return getisIndirect(object);
	}

	@Override
	public Boolean getTypeHasTypeName() {
		COSObject object = getTypeValue();
		return getHasTypeName(object);
	}

	@Override
	public String getTypeNameValue() {
		COSObject object = getTypeValue();
		return getNameValue(object);
	}

	@Override
	public Boolean getcontainsURL() {
		return this.baseObject.knownKey(ASAtom.getASAtom("URL"));
	}

	public COSObject getURLValue() {
		COSObject object = this.baseObject.getKey(ASAtom.getASAtom("URL"));
		return object;
	}

	@Override
	public Boolean getisURLIndirect() {
		COSObject object = getURLValue();
		return getisIndirect(object);
	}

	@Override
	public Boolean getURLHasTypeString() {
		COSObject object = getURLValue();
		return getHasTypeString(object);
	}

}
