/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.arlington;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSArray;
import org.verapdf.cos.COSBase;
import org.verapdf.cos.COSDictionary;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.cos.COSStream;
import org.verapdf.gf.model.impl.arlington.GFA3DAnimationStyle;
import org.verapdf.gf.model.impl.arlington.GFA3DStreamNameTreeResources;
import org.verapdf.gf.model.impl.arlington.GFA3DView;
import org.verapdf.gf.model.impl.arlington.GFAArrayOf3DView;
import org.verapdf.gf.model.impl.arlington.GFAArrayOfCompressionFilterNames;
import org.verapdf.gf.model.impl.arlington.GFAArrayOfDecodeParams;
import org.verapdf.gf.model.impl.arlington.GFACalRGBColorSpace;
import org.verapdf.gf.model.impl.arlington.GFAFileSpecification;
import org.verapdf.gf.model.impl.arlington.GFAFilterCrypt;
import org.verapdf.gf.model.impl.arlington.GFAFilterFlateDecode;
import org.verapdf.gf.model.impl.arlington.GFAFilterLZWDecode;
import org.verapdf.gf.model.impl.arlington.GFAICCBasedColorSpace;
import org.verapdf.gf.model.impl.arlington.GFAObject;
import org.verapdf.gf.model.impl.arlington.GFAStream;
import org.verapdf.gf.model.impl.containers.StaticContainers;
import org.verapdf.model.alayer.A3DAnimationStyle;
import org.verapdf.model.alayer.A3DStream;
import org.verapdf.model.alayer.A3DStreamNameTreeResources;
import org.verapdf.model.alayer.A3DView;
import org.verapdf.model.alayer.AArrayOf3DView;
import org.verapdf.model.alayer.AArrayOfCompressionFilterNames;
import org.verapdf.model.alayer.AFileSpecification;
import org.verapdf.model.alayer.AStream;

public class GFA3DStream
extends GFAObject
implements A3DStream {
    public GFA3DStream(COSBase baseObject, COSBase parentObject, String keyName) {
        super(baseObject, parentObject, keyName, "A3DStream");
    }

    public List<? extends org.verapdf.model.baselayer.Object> getLinkedObjects(String link) {
        switch (link) {
            case "AN": {
                return this.getAN();
            }
            case "ColorSpace": {
                return this.getColorSpace();
            }
            case "DV": {
                return this.getDV();
            }
            case "DecodeParms": {
                return this.getDecodeParms();
            }
            case "F": {
                return this.getF();
            }
            case "FDecodeParms": {
                return this.getFDecodeParms();
            }
            case "FFilter": {
                return this.getFFilter();
            }
            case "Filter": {
                return this.getFilter();
            }
            case "OnInstantiate": {
                return this.getOnInstantiate();
            }
            case "Resources": {
                return this.getResources();
            }
            case "VA": {
                return this.getVA();
            }
        }
        return super.getLinkedObjects(link);
    }

    private List<A3DAnimationStyle> getAN() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return this.getAN1_7();
            }
        }
        return Collections.emptyList();
    }

    private List<A3DAnimationStyle> getAN1_7() {
        COSObject object = this.getANValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_DICT) {
            ArrayList<GFA3DAnimationStyle> list = new ArrayList<GFA3DAnimationStyle>(1);
            list.add(new GFA3DAnimationStyle((COSBase)((COSDictionary)object.getDirectBase()), this.baseObject, "AN"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<org.verapdf.model.baselayer.Object> getColorSpace() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON2_0: {
                return this.getColorSpace2_0();
            }
        }
        return Collections.emptyList();
    }

    private List<org.verapdf.model.baselayer.Object> getColorSpace2_0() {
        COSObject object = this.getColorSpaceValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_ARRAY) {
            org.verapdf.model.baselayer.Object result = this.getColorSpaceArray2_0(object.getDirectBase(), "ColorSpace");
            ArrayList<org.verapdf.model.baselayer.Object> list = new ArrayList<org.verapdf.model.baselayer.Object>(1);
            if (result != null) {
                list.add(result);
            }
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private org.verapdf.model.baselayer.Object getColorSpaceArray2_0(COSBase base, String keyName) {
        if (base.size() <= 0) {
            return null;
        }
        COSObject subtype = base.at(0);
        if (subtype == null) {
            return null;
        }
        String subtypeValue = subtype.getString();
        if (subtypeValue == null) {
            return null;
        }
        switch (subtypeValue) {
            case "CalRGB": {
                return new GFACalRGBColorSpace(base, this.baseObject, keyName);
            }
            case "ICCBased": {
                return new GFAICCBasedColorSpace(base, this.baseObject, keyName);
            }
        }
        return null;
    }

    private List<A3DView> getDV() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_7: 
            case ARLINGTON2_0: 
            case ARLINGTON1_6: {
                return this.getDV1_6();
            }
        }
        return Collections.emptyList();
    }

    private List<A3DView> getDV1_6() {
        COSObject object = this.getDVValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_DICT) {
            ArrayList<GFA3DView> list = new ArrayList<GFA3DView>(1);
            list.add(new GFA3DView((COSBase)((COSDictionary)object.getDirectBase()), this.baseObject, "DV"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<org.verapdf.model.baselayer.Object> getDecodeParms() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_7: 
            case ARLINGTON2_0: 
            case ARLINGTON1_6: {
                return this.getDecodeParms1_6();
            }
        }
        return Collections.emptyList();
    }

    private List<org.verapdf.model.baselayer.Object> getDecodeParms1_6() {
        COSObject object = this.getDecodeParmsValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_ARRAY) {
            ArrayList<GFAArrayOfDecodeParams> list = new ArrayList<GFAArrayOfDecodeParams>(1);
            list.add(new GFAArrayOfDecodeParams((COSBase)((COSArray)object.getDirectBase()), this.baseObject, "DecodeParms"));
            return Collections.unmodifiableList(list);
        }
        if (object.getType() == COSObjType.COS_DICT) {
            org.verapdf.model.baselayer.Object result = this.getDecodeParmsDictionary1_6(object.getDirectBase(), "DecodeParms");
            ArrayList<org.verapdf.model.baselayer.Object> list = new ArrayList<org.verapdf.model.baselayer.Object>(1);
            if (result != null) {
                list.add(result);
            }
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private org.verapdf.model.baselayer.Object getDecodeParmsDictionary1_6(COSBase base, String keyName) {
        COSObject subtype = this.baseObject.getKey(ASAtom.getASAtom((String)"Filter"));
        if (subtype == null) {
            return null;
        }
        String subtypeValue = subtype.getString();
        if (subtypeValue == null) {
            return null;
        }
        switch (subtypeValue) {
            case "Crypt": {
                return new GFAFilterCrypt(base, this.baseObject, keyName);
            }
            case "FlateDecode": {
                return new GFAFilterFlateDecode(base, this.baseObject, keyName);
            }
            case "LZWDecode": {
                return new GFAFilterLZWDecode(base, this.baseObject, keyName);
            }
        }
        return null;
    }

    private List<AFileSpecification> getF() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_7: 
            case ARLINGTON2_0: 
            case ARLINGTON1_6: {
                return this.getF1_6();
            }
        }
        return Collections.emptyList();
    }

    private List<AFileSpecification> getF1_6() {
        COSObject object = this.getFValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_DICT) {
            ArrayList<GFAFileSpecification> list = new ArrayList<GFAFileSpecification>(1);
            list.add(new GFAFileSpecification((COSBase)((COSDictionary)object.getDirectBase()), this.baseObject, "F"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<org.verapdf.model.baselayer.Object> getFDecodeParms() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_7: 
            case ARLINGTON2_0: 
            case ARLINGTON1_6: {
                return this.getFDecodeParms1_6();
            }
        }
        return Collections.emptyList();
    }

    private List<org.verapdf.model.baselayer.Object> getFDecodeParms1_6() {
        COSObject object = this.getFDecodeParmsValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_ARRAY) {
            ArrayList<GFAArrayOfDecodeParams> list = new ArrayList<GFAArrayOfDecodeParams>(1);
            list.add(new GFAArrayOfDecodeParams((COSBase)((COSArray)object.getDirectBase()), this.baseObject, "FDecodeParms"));
            return Collections.unmodifiableList(list);
        }
        if (object.getType() == COSObjType.COS_DICT) {
            org.verapdf.model.baselayer.Object result = this.getFDecodeParmsDictionary1_6(object.getDirectBase(), "FDecodeParms");
            ArrayList<org.verapdf.model.baselayer.Object> list = new ArrayList<org.verapdf.model.baselayer.Object>(1);
            if (result != null) {
                list.add(result);
            }
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private org.verapdf.model.baselayer.Object getFDecodeParmsDictionary1_6(COSBase base, String keyName) {
        COSObject subtype = this.baseObject.getKey(ASAtom.getASAtom((String)"FFilter"));
        if (subtype == null) {
            return null;
        }
        String subtypeValue = subtype.getString();
        if (subtypeValue == null) {
            return null;
        }
        switch (subtypeValue) {
            case "Crypt": {
                return new GFAFilterCrypt(base, this.baseObject, keyName);
            }
            case "FlateDecode": {
                return new GFAFilterFlateDecode(base, this.baseObject, keyName);
            }
            case "LZWDecode": {
                return new GFAFilterLZWDecode(base, this.baseObject, keyName);
            }
        }
        return null;
    }

    private List<AArrayOfCompressionFilterNames> getFFilter() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_7: 
            case ARLINGTON2_0: 
            case ARLINGTON1_6: {
                return this.getFFilter1_6();
            }
        }
        return Collections.emptyList();
    }

    private List<AArrayOfCompressionFilterNames> getFFilter1_6() {
        COSObject object = this.getFFilterValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_ARRAY) {
            ArrayList<GFAArrayOfCompressionFilterNames> list = new ArrayList<GFAArrayOfCompressionFilterNames>(1);
            list.add(new GFAArrayOfCompressionFilterNames((COSBase)((COSArray)object.getDirectBase()), this.baseObject, "FFilter"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<AArrayOfCompressionFilterNames> getFilter() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_7: 
            case ARLINGTON2_0: 
            case ARLINGTON1_6: {
                return this.getFilter1_6();
            }
        }
        return Collections.emptyList();
    }

    private List<AArrayOfCompressionFilterNames> getFilter1_6() {
        COSObject object = this.getFilterValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_ARRAY) {
            ArrayList<GFAArrayOfCompressionFilterNames> list = new ArrayList<GFAArrayOfCompressionFilterNames>(1);
            list.add(new GFAArrayOfCompressionFilterNames((COSBase)((COSArray)object.getDirectBase()), this.baseObject, "Filter"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<AStream> getOnInstantiate() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_7: 
            case ARLINGTON2_0: 
            case ARLINGTON1_6: {
                return this.getOnInstantiate1_6();
            }
        }
        return Collections.emptyList();
    }

    private List<AStream> getOnInstantiate1_6() {
        COSObject object = this.getOnInstantiateValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_STREAM) {
            ArrayList<GFAStream> list = new ArrayList<GFAStream>(1);
            list.add(new GFAStream((COSBase)((COSStream)object.getDirectBase()), this.baseObject, "OnInstantiate"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<A3DStreamNameTreeResources> getResources() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_7: 
            case ARLINGTON2_0: 
            case ARLINGTON1_6: {
                return this.getResources1_6();
            }
        }
        return Collections.emptyList();
    }

    private List<A3DStreamNameTreeResources> getResources1_6() {
        COSObject object = this.getResourcesValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_DICT) {
            ArrayList<GFA3DStreamNameTreeResources> list = new ArrayList<GFA3DStreamNameTreeResources>(1);
            list.add(new GFA3DStreamNameTreeResources((COSBase)((COSDictionary)object.getDirectBase()), this.baseObject, "Resources"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<AArrayOf3DView> getVA() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_7: 
            case ARLINGTON2_0: 
            case ARLINGTON1_6: {
                return this.getVA1_6();
            }
        }
        return Collections.emptyList();
    }

    private List<AArrayOf3DView> getVA1_6() {
        COSObject object = this.getVAValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_ARRAY) {
            ArrayList<GFAArrayOf3DView> list = new ArrayList<GFAArrayOf3DView>(1);
            list.add(new GFAArrayOf3DView((COSBase)((COSArray)object.getDirectBase()), this.baseObject, "VA"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    public Boolean getcontainsAN() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"AN"));
    }

    public COSObject getANValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"AN"));
        return object;
    }

    public Boolean getANHasTypeDictionary() {
        COSObject object = this.getANValue();
        return GFA3DStream.getHasTypeDictionary(object);
    }

    public Boolean getcontainsColorSpace() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"ColorSpace"));
    }

    public COSObject getColorSpaceValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"ColorSpace"));
        return object;
    }

    public Boolean getColorSpaceHasTypeArray() {
        COSObject object = this.getColorSpaceValue();
        return GFA3DStream.getHasTypeArray(object);
    }

    public Boolean getColorSpaceHasTypeName() {
        COSObject object = this.getColorSpaceValue();
        return GFA3DStream.getHasTypeName(object);
    }

    public String getColorSpaceNameValue() {
        COSObject object = this.getColorSpaceValue();
        return GFA3DStream.getNameValue(object);
    }

    public Boolean getcontainsDL() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"DL"));
    }

    public COSObject getDLValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"DL"));
        return object;
    }

    public Boolean getDLHasTypeInteger() {
        COSObject object = this.getDLValue();
        return GFA3DStream.getHasTypeInteger(object);
    }

    public Long getDLIntegerValue() {
        COSObject object = this.getDLValue();
        return GFA3DStream.getIntegerValue(object);
    }

    public Boolean getcontainsDV() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"DV"));
    }

    public COSObject getDVValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"DV"));
        return object;
    }

    public Boolean getDVHasTypeDictionary() {
        COSObject object = this.getDVValue();
        return GFA3DStream.getHasTypeDictionary(object);
    }

    public Boolean getDVHasTypeInteger() {
        COSObject object = this.getDVValue();
        return GFA3DStream.getHasTypeInteger(object);
    }

    public Boolean getDVHasTypeName() {
        COSObject object = this.getDVValue();
        return GFA3DStream.getHasTypeName(object);
    }

    public Boolean getDVHasTypeString() {
        COSObject object = this.getDVValue();
        return GFA3DStream.getHasTypeString(object);
    }

    public Long getDVIntegerValue() {
        COSObject object = this.getDVValue();
        return GFA3DStream.getIntegerValue(object);
    }

    public String getDVNameValue() {
        COSObject object = this.getDVValue();
        return GFA3DStream.getNameValue(object);
    }

    public Boolean getcontainsDecodeParms() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"DecodeParms"));
    }

    public COSObject getDecodeParmsValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"DecodeParms"));
        return object;
    }

    public Boolean getDecodeParmsHasTypeArray() {
        COSObject object = this.getDecodeParmsValue();
        return GFA3DStream.getHasTypeArray(object);
    }

    public Boolean getDecodeParmsHasTypeDictionary() {
        COSObject object = this.getDecodeParmsValue();
        return GFA3DStream.getHasTypeDictionary(object);
    }

    public Long getDecodeParmsArraySize() {
        COSObject object = this.getDecodeParmsValue();
        return GFA3DStream.getArraySize(object);
    }

    public Boolean getcontainsF() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"F"));
    }

    public COSObject getFValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"F"));
        return object;
    }

    public Boolean getFHasTypeDictionary() {
        COSObject object = this.getFValue();
        return GFA3DStream.getHasTypeDictionary(object);
    }

    public Boolean getFHasTypeString() {
        COSObject object = this.getFValue();
        return GFA3DStream.getHasTypeString(object);
    }

    public Boolean getcontainsFDecodeParms() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"FDecodeParms"));
    }

    public COSObject getFDecodeParmsValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"FDecodeParms"));
        return object;
    }

    public Boolean getFDecodeParmsHasTypeArray() {
        COSObject object = this.getFDecodeParmsValue();
        return GFA3DStream.getHasTypeArray(object);
    }

    public Boolean getFDecodeParmsHasTypeDictionary() {
        COSObject object = this.getFDecodeParmsValue();
        return GFA3DStream.getHasTypeDictionary(object);
    }

    public Long getFDecodeParmsArraySize() {
        COSObject object = this.getFDecodeParmsValue();
        return GFA3DStream.getArraySize(object);
    }

    public Boolean getcontainsFFilter() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"FFilter"));
    }

    public COSObject getFFilterValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"FFilter"));
        return object;
    }

    public Boolean getFFilterHasTypeArray() {
        COSObject object = this.getFFilterValue();
        return GFA3DStream.getHasTypeArray(object);
    }

    public Boolean getFFilterHasTypeName() {
        COSObject object = this.getFFilterValue();
        return GFA3DStream.getHasTypeName(object);
    }

    public String getFFilterNameValue() {
        COSObject object = this.getFFilterValue();
        return GFA3DStream.getNameValue(object);
    }

    public Long getFFilterArraySize() {
        COSObject object = this.getFFilterValue();
        return GFA3DStream.getArraySize(object);
    }

    public Boolean getcontainsFilter() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"Filter"));
    }

    public COSObject getFilterValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Filter"));
        return object;
    }

    public Boolean getFilterHasTypeArray() {
        COSObject object = this.getFilterValue();
        return GFA3DStream.getHasTypeArray(object);
    }

    public Boolean getFilterHasTypeName() {
        COSObject object = this.getFilterValue();
        return GFA3DStream.getHasTypeName(object);
    }

    public String getFilterNameValue() {
        COSObject object = this.getFilterValue();
        return GFA3DStream.getNameValue(object);
    }

    public Long getFilterArraySize() {
        COSObject object = this.getFilterValue();
        return GFA3DStream.getArraySize(object);
    }

    public Boolean getcontainsLength() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"Length"));
    }

    public COSObject getLengthValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Length"));
        return object;
    }

    public Boolean getLengthHasTypeInteger() {
        COSObject object = this.getLengthValue();
        return GFA3DStream.getHasTypeInteger(object);
    }

    public Boolean getcontainsOnInstantiate() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"OnInstantiate"));
    }

    public COSObject getOnInstantiateValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"OnInstantiate"));
        return object;
    }

    public Boolean getisOnInstantiateIndirect() {
        COSObject object = this.getOnInstantiateValue();
        return GFA3DStream.getisIndirect(object);
    }

    public Boolean getOnInstantiateHasTypeStream() {
        COSObject object = this.getOnInstantiateValue();
        return GFA3DStream.getHasTypeStream(object);
    }

    public Boolean getcontainsResources() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"Resources"));
    }

    public COSObject getResourcesValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Resources"));
        return object;
    }

    public Boolean getResourcesHasTypeNameTree() {
        COSObject object = this.getResourcesValue();
        return GFA3DStream.getHasTypeNameTree(object);
    }

    public Boolean getcontainsSubtype() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"Subtype"));
    }

    public COSObject getSubtypeValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Subtype"));
        return object;
    }

    public Boolean getSubtypeHasTypeName() {
        COSObject object = this.getSubtypeValue();
        return GFA3DStream.getHasTypeName(object);
    }

    public String getSubtypeNameValue() {
        COSObject object = this.getSubtypeValue();
        return GFA3DStream.getNameValue(object);
    }

    public Boolean getcontainsType() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"Type"));
    }

    public COSObject getTypeValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Type"));
        return object;
    }

    public Boolean getTypeHasTypeName() {
        COSObject object = this.getTypeValue();
        return GFA3DStream.getHasTypeName(object);
    }

    public String getTypeNameValue() {
        COSObject object = this.getTypeValue();
        return GFA3DStream.getNameValue(object);
    }

    public Boolean getcontainsVA() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"VA"));
    }

    public COSObject getVAValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"VA"));
        return object;
    }

    public Boolean getVAHasTypeArray() {
        COSObject object = this.getVAValue();
        return GFA3DStream.getHasTypeArray(object);
    }

    public Long getVAArraySize() {
        COSObject object = this.getVAValue();
        return GFA3DStream.getArraySize(object);
    }
}

