/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.arlington;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSArray;
import org.verapdf.cos.COSBase;
import org.verapdf.cos.COSDictionary;
import org.verapdf.cos.COSName;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.cos.COSStream;
import org.verapdf.gf.model.impl.arlington.GFAFieldMDPTransformParameters;
import org.verapdf.gf.model.impl.arlington.GFAObject;
import org.verapdf.gf.model.impl.arlington.GFAStream;
import org.verapdf.gf.model.impl.arlington.GFA_UniversalArray;
import org.verapdf.gf.model.impl.arlington.GFA_UniversalDictionary;
import org.verapdf.gf.model.impl.containers.StaticContainers;
import org.verapdf.model.alayer.AFieldMDPTransformParameters;
import org.verapdf.model.alayer.ASignatureReferenceFieldMDP;
import org.verapdf.model.baselayer.Object;

public class GFASignatureReferenceFieldMDP
extends GFAObject
implements ASignatureReferenceFieldMDP {
    public GFASignatureReferenceFieldMDP(COSBase baseObject, COSBase parentObject, String keyName) {
        super(baseObject, parentObject, keyName, "ASignatureReferenceFieldMDP");
    }

    public List<? extends Object> getLinkedObjects(String link) {
        switch (link) {
            case "Data": {
                return this.getData();
            }
            case "TransformParams": {
                return this.getTransformParams();
            }
        }
        return super.getLinkedObjects(link);
    }

    private List<Object> getData() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return this.getData1_5();
            }
        }
        return Collections.emptyList();
    }

    private List<Object> getData1_5() {
        COSObject object = this.getDataValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_ARRAY) {
            ArrayList<GFA_UniversalArray> list = new ArrayList<GFA_UniversalArray>(1);
            list.add(new GFA_UniversalArray((COSBase)((COSArray)object.getDirectBase()), this.baseObject, "Data"));
            return Collections.unmodifiableList(list);
        }
        if (object.getType() == COSObjType.COS_DICT) {
            ArrayList<GFA_UniversalDictionary> list = new ArrayList<GFA_UniversalDictionary>(1);
            list.add(new GFA_UniversalDictionary((COSBase)((COSDictionary)object.getDirectBase()), this.baseObject, "Data"));
            return Collections.unmodifiableList(list);
        }
        if (object.getType() == COSObjType.COS_STREAM) {
            ArrayList<GFAStream> list = new ArrayList<GFAStream>(1);
            list.add(new GFAStream((COSBase)((COSStream)object.getDirectBase()), this.baseObject, "Data"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<AFieldMDPTransformParameters> getTransformParams() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return this.getTransformParams1_5();
            }
        }
        return Collections.emptyList();
    }

    private List<AFieldMDPTransformParameters> getTransformParams1_5() {
        COSObject object = this.getTransformParamsValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_DICT) {
            ArrayList<GFAFieldMDPTransformParameters> list = new ArrayList<GFAFieldMDPTransformParameters>(1);
            list.add(new GFAFieldMDPTransformParameters((COSBase)((COSDictionary)object.getDirectBase()), this.baseObject, "TransformParams"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    public Boolean getcontainsData() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"Data"));
    }

    public COSObject getDataValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Data"));
        return object;
    }

    public Boolean getisDataIndirect() {
        COSObject object = this.getDataValue();
        return GFASignatureReferenceFieldMDP.getisIndirect(object);
    }

    public Boolean getDataHasTypeArray() {
        COSObject object = this.getDataValue();
        return GFASignatureReferenceFieldMDP.getHasTypeArray(object);
    }

    public Boolean getDataHasTypeBoolean() {
        COSObject object = this.getDataValue();
        return GFASignatureReferenceFieldMDP.getHasTypeBoolean(object);
    }

    public Boolean getDataHasTypeDictionary() {
        COSObject object = this.getDataValue();
        return GFASignatureReferenceFieldMDP.getHasTypeDictionary(object);
    }

    public Boolean getDataHasTypeInteger() {
        COSObject object = this.getDataValue();
        return GFASignatureReferenceFieldMDP.getHasTypeInteger(object);
    }

    public Boolean getDataHasTypeName() {
        COSObject object = this.getDataValue();
        return GFASignatureReferenceFieldMDP.getHasTypeName(object);
    }

    public Boolean getDataHasTypeStream() {
        COSObject object = this.getDataValue();
        return GFASignatureReferenceFieldMDP.getHasTypeStream(object);
    }

    public Boolean getDataHasTypeString() {
        COSObject object = this.getDataValue();
        return GFASignatureReferenceFieldMDP.getHasTypeString(object);
    }

    public Boolean getcontainsDigestMethod() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"DigestMethod"));
    }

    public COSObject getDigestMethodDefaultValue() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: {
                return COSName.construct((String)"MD5");
            }
            case ARLINGTON2_0: {
                return this.gethasExtensionISO_TS_32001() != false ? COSName.construct((String)"SHA256") : null;
            }
        }
        return null;
    }

    public COSObject getDigestMethodValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"DigestMethod"));
        if (object == null || object.empty()) {
            object = this.getDigestMethodDefaultValue();
        }
        return object;
    }

    public Boolean getDigestMethodHasTypeName() {
        COSObject object = this.getDigestMethodValue();
        return GFASignatureReferenceFieldMDP.getHasTypeName(object);
    }

    public String getDigestMethodNameValue() {
        COSObject object = this.getDigestMethodValue();
        return GFASignatureReferenceFieldMDP.getNameValue(object);
    }

    public Boolean getcontainsTransformMethod() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"TransformMethod"));
    }

    public COSObject getTransformMethodValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"TransformMethod"));
        return object;
    }

    public Boolean getTransformMethodHasTypeName() {
        COSObject object = this.getTransformMethodValue();
        return GFASignatureReferenceFieldMDP.getHasTypeName(object);
    }

    public String getTransformMethodNameValue() {
        COSObject object = this.getTransformMethodValue();
        return GFASignatureReferenceFieldMDP.getNameValue(object);
    }

    public Boolean getcontainsTransformParams() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"TransformParams"));
    }

    public COSObject getTransformParamsValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"TransformParams"));
        return object;
    }

    public Boolean getTransformParamsHasTypeDictionary() {
        COSObject object = this.getTransformParamsValue();
        return GFASignatureReferenceFieldMDP.getHasTypeDictionary(object);
    }

    public Boolean getcontainsType() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"Type"));
    }

    public COSObject getTypeValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Type"));
        return object;
    }

    public Boolean getTypeHasTypeName() {
        COSObject object = this.getTypeValue();
        return GFASignatureReferenceFieldMDP.getHasTypeName(object);
    }

    public String getTypeNameValue() {
        COSObject object = this.getTypeValue();
        return GFASignatureReferenceFieldMDP.getNameValue(object);
    }

    public Boolean gethasExtensionISO_TS_32001() {
        return false;
    }
}

