/**
 * This file is part of veraPDF Validation, a module of the veraPDF project.
 * Copyright (c) 2015, veraPDF Consortium <info@verapdf.org>
 * All rights reserved.
 *
 * veraPDF Validation is free software: you can redistribute it and/or modify
 * it under the terms of either:
 *
 * The GNU General public license GPLv3+.
 * You should have received a copy of the GNU General Public License
 * along with veraPDF Validation as the LICENSE.GPL file in the root of the source
 * tree.  If not, see http://www.gnu.org/licenses/ or
 * https://www.gnu.org/licenses/gpl-3.0.en.html.
 *
 * The Mozilla Public License MPLv2+.
 * You should have received a copy of the Mozilla Public License along with
 * veraPDF Validation as the LICENSE.MPL file in the root of the source tree.
 * If a copy of the MPL was not distributed with this file, you can obtain one at
 * http://mozilla.org/MPL/2.0/.
 */
package org.verapdf.gf.model.impl.arlington;

import org.verapdf.cos.*;
import org.verapdf.model.alayer.*;
import org.verapdf.gf.model.impl.containers.StaticContainers;
import org.verapdf.tools.StaticResources;
import java.util.*;
import org.verapdf.pd.PDNameTreeNode;
import org.verapdf.as.ASAtom;
import java.util.stream.Collectors;
import org.verapdf.pd.structure.PDNumberTreeNode;

public class GFAFilterJBIG2Decode extends GFAObject implements AFilterJBIG2Decode {

	public GFAFilterJBIG2Decode(COSBase baseObject, COSBase parentObject, String keyName) {
		super(baseObject, parentObject, keyName, "AFilterJBIG2Decode");
	}

	@Override
	public List<? extends org.verapdf.model.baselayer.Object> getLinkedObjects(String link) {
		switch (link) {
			case "JBIG2Globals":
				return getJBIG2Globals();
			default:
				return super.getLinkedObjects(link);
		}
	}

	private List<AStream> getJBIG2Globals() {
		switch (StaticContainers.getFlavour()) {
			case ARLINGTON1_4:
			case ARLINGTON1_5:
			case ARLINGTON1_6:
			case ARLINGTON1_7:
			case ARLINGTON2_0:
				return getJBIG2Globals1_4();
			default:
				return Collections.emptyList();
		}
	}

	private List<AStream> getJBIG2Globals1_4() {
		COSObject object = getJBIG2GlobalsValue();
		if (object == null) {
			return Collections.emptyList();
		}
		if (object.getType() == COSObjType.COS_STREAM) {
			List<AStream> list = new ArrayList<>(1);
			list.add(new GFAStream((COSStream)object.getDirectBase(), this.baseObject, "JBIG2Globals"));
			return Collections.unmodifiableList(list);
		}
		return Collections.emptyList();
	}

	@Override
	public Boolean getcontainsJBIG2Globals() {
		return this.baseObject.knownKey(ASAtom.getASAtom("JBIG2Globals"));
	}

	public COSObject getJBIG2GlobalsValue() {
		COSObject object = this.baseObject.getKey(ASAtom.getASAtom("JBIG2Globals"));
		return object;
	}

	@Override
	public Boolean getisJBIG2GlobalsIndirect() {
		COSObject JBIG2Globals = getJBIG2GlobalsValue();
		return getisIndirect(JBIG2Globals);
	}

	@Override
	public Boolean getJBIG2GlobalsHasTypeStream() {
		COSObject JBIG2Globals = getJBIG2GlobalsValue();
		return getHasTypeStream(JBIG2Globals);
	}

}
