/**
 * This file is part of veraPDF Validation, a module of the veraPDF project.
 * Copyright (c) 2015, veraPDF Consortium <info@verapdf.org>
 * All rights reserved.
 *
 * veraPDF Validation is free software: you can redistribute it and/or modify
 * it under the terms of either:
 *
 * The GNU General public license GPLv3+.
 * You should have received a copy of the GNU General Public License
 * along with veraPDF Validation as the LICENSE.GPL file in the root of the source
 * tree.  If not, see http://www.gnu.org/licenses/ or
 * https://www.gnu.org/licenses/gpl-3.0.en.html.
 *
 * The Mozilla Public License MPLv2+.
 * You should have received a copy of the Mozilla Public License along with
 * veraPDF Validation as the LICENSE.MPL file in the root of the source tree.
 * If a copy of the MPL was not distributed with this file, you can obtain one at
 * http://mozilla.org/MPL/2.0/.
 */
package org.verapdf.gf.model.impl.arlington;

import org.verapdf.cos.*;
import org.verapdf.model.alayer.*;
import org.verapdf.gf.model.impl.containers.StaticContainers;
import org.verapdf.tools.StaticResources;
import java.util.*;
import org.verapdf.pd.PDNameTreeNode;
import org.verapdf.as.ASAtom;
import java.util.stream.Collectors;
import org.verapdf.pd.structure.PDNumberTreeNode;

public class GFAFilterLZWDecode extends GFAObject implements AFilterLZWDecode {

	public GFAFilterLZWDecode(COSBase baseObject, COSBase parentObject, String keyName) {
		super(baseObject, parentObject, keyName, "AFilterLZWDecode");
	}

	@Override
	public Boolean getcontainsBitsPerComponent() {
		return this.baseObject.knownKey(ASAtom.getASAtom("BitsPerComponent"));
	}

	public COSObject getBitsPerComponentDefaultValue() {
		return COSInteger.construct(8L);
	}

	public COSObject getBitsPerComponentValue() {
		COSObject object = this.baseObject.getKey(ASAtom.getASAtom("BitsPerComponent"));
		if (object == null || object.empty()) {
			object = getBitsPerComponentDefaultValue();
		}
		return object;
	}

	@Override
	public Boolean getBitsPerComponentHasTypeInteger() {
		COSObject BitsPerComponent = getBitsPerComponentValue();
		return getHasTypeInteger(BitsPerComponent);
	}

	@Override
	public Long getBitsPerComponentIntegerValue() {
		COSObject BitsPerComponent = getBitsPerComponentValue();
		return getIntegerValue(BitsPerComponent);
	}

	@Override
	public Boolean getcontainsColors() {
		return this.baseObject.knownKey(ASAtom.getASAtom("Colors"));
	}

	public COSObject getColorsDefaultValue() {
		return COSInteger.construct(1L);
	}

	public COSObject getColorsValue() {
		COSObject object = this.baseObject.getKey(ASAtom.getASAtom("Colors"));
		if (object == null || object.empty()) {
			object = getColorsDefaultValue();
		}
		return object;
	}

	@Override
	public Boolean getColorsHasTypeInteger() {
		COSObject Colors = getColorsValue();
		return getHasTypeInteger(Colors);
	}

	@Override
	public Long getColorsIntegerValue() {
		COSObject Colors = getColorsValue();
		return getIntegerValue(Colors);
	}

	@Override
	public Boolean getcontainsColumns() {
		return this.baseObject.knownKey(ASAtom.getASAtom("Columns"));
	}

	public COSObject getColumnsDefaultValue() {
		return COSInteger.construct(1L);
	}

	public COSObject getColumnsValue() {
		COSObject object = this.baseObject.getKey(ASAtom.getASAtom("Columns"));
		if (object == null || object.empty()) {
			object = getColumnsDefaultValue();
		}
		return object;
	}

	@Override
	public Boolean getColumnsHasTypeInteger() {
		COSObject Columns = getColumnsValue();
		return getHasTypeInteger(Columns);
	}

	@Override
	public Boolean getcontainsEarlyChange() {
		return this.baseObject.knownKey(ASAtom.getASAtom("EarlyChange"));
	}

	public COSObject getEarlyChangeDefaultValue() {
		return COSInteger.construct(1L);
	}

	public COSObject getEarlyChangeValue() {
		COSObject object = this.baseObject.getKey(ASAtom.getASAtom("EarlyChange"));
		if (object == null || object.empty()) {
			object = getEarlyChangeDefaultValue();
		}
		return object;
	}

	@Override
	public Boolean getEarlyChangeHasTypeInteger() {
		COSObject EarlyChange = getEarlyChangeValue();
		return getHasTypeInteger(EarlyChange);
	}

	@Override
	public Long getEarlyChangeIntegerValue() {
		COSObject EarlyChange = getEarlyChangeValue();
		return getIntegerValue(EarlyChange);
	}

	@Override
	public Boolean getcontainsPredictor() {
		return this.baseObject.knownKey(ASAtom.getASAtom("Predictor"));
	}

	public COSObject getPredictorValue() {
		COSObject object = this.baseObject.getKey(ASAtom.getASAtom("Predictor"));
		return object;
	}

	@Override
	public Boolean getPredictorHasTypeInteger() {
		COSObject Predictor = getPredictorValue();
		return getHasTypeInteger(Predictor);
	}

	@Override
	public Long getPredictorIntegerValue() {
		COSObject Predictor = getPredictorValue();
		return getIntegerValue(Predictor);
	}

}
