/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.arlington;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSArray;
import org.verapdf.cos.COSBase;
import org.verapdf.cos.COSName;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.cos.COSReal;
import org.verapdf.gf.model.impl.arlington.GFAArrayOf_4ColourSpaceEntries;
import org.verapdf.gf.model.impl.arlington.GFAObject;
import org.verapdf.gf.model.impl.containers.StaticContainers;
import org.verapdf.model.alayer.A3DRenderMode;
import org.verapdf.model.alayer.AArrayOf_4ColourSpaceEntries;
import org.verapdf.model.baselayer.Object;

public class GFA3DRenderMode
extends GFAObject
implements A3DRenderMode {
    public GFA3DRenderMode(COSBase baseObject, COSBase parentObject, String keyName) {
        super(baseObject, parentObject, keyName, "A3DRenderMode");
    }

    public List<? extends Object> getLinkedObjects(String link) {
        switch (link) {
            case "AC": {
                return this.getAC();
            }
            case "FC": {
                return this.getFC();
            }
        }
        return super.getLinkedObjects(link);
    }

    private List<AArrayOf_4ColourSpaceEntries> getAC() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return this.getAC1_7();
            }
        }
        return Collections.emptyList();
    }

    private List<AArrayOf_4ColourSpaceEntries> getAC1_7() {
        COSObject object = this.getACValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_ARRAY) {
            ArrayList<GFAArrayOf_4ColourSpaceEntries> list = new ArrayList<GFAArrayOf_4ColourSpaceEntries>(1);
            list.add(new GFAArrayOf_4ColourSpaceEntries((COSBase)((COSArray)object.getDirectBase()), this.baseObject, "AC"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<AArrayOf_4ColourSpaceEntries> getFC() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return this.getFC1_7();
            }
        }
        return Collections.emptyList();
    }

    private List<AArrayOf_4ColourSpaceEntries> getFC1_7() {
        COSObject object = this.getFCValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_ARRAY) {
            ArrayList<GFAArrayOf_4ColourSpaceEntries> list = new ArrayList<GFAArrayOf_4ColourSpaceEntries>(1);
            list.add(new GFAArrayOf_4ColourSpaceEntries((COSBase)((COSArray)object.getDirectBase()), this.baseObject, "FC"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    public Boolean getcontainsAC() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"AC"));
    }

    public COSObject getACValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"AC"));
        return object;
    }

    public Boolean getACHasTypeArray() {
        COSObject AC = this.getACValue();
        return GFA3DRenderMode.getHasTypeArray(AC);
    }

    public Boolean getcontainsCV() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"CV"));
    }

    public COSObject getCVDefaultValue() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return COSReal.construct((double)45.0);
            }
        }
        return null;
    }

    public COSObject getCVValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"CV"));
        if (object == null || object.empty()) {
            object = this.getCVDefaultValue();
        }
        return object;
    }

    public Boolean getCVHasTypeNumber() {
        COSObject CV = this.getCVValue();
        return GFA3DRenderMode.getHasTypeNumber(CV);
    }

    public Boolean getcontainsFC() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"FC"));
    }

    public COSObject getFCDefaultValue() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return COSName.construct((String)"BG");
            }
        }
        return null;
    }

    public COSObject getFCValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"FC"));
        if (object == null || object.empty()) {
            object = this.getFCDefaultValue();
        }
        return object;
    }

    public Boolean getFCHasTypeArray() {
        COSObject FC = this.getFCValue();
        return GFA3DRenderMode.getHasTypeArray(FC);
    }

    public Boolean getFCHasTypeName() {
        COSObject FC = this.getFCValue();
        return GFA3DRenderMode.getHasTypeName(FC);
    }

    public String getFCNameValue() {
        COSObject FC = this.getFCValue();
        return GFA3DRenderMode.getNameValue(FC);
    }

    public Boolean getcontainsO() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"O"));
    }

    public COSObject getODefaultValue() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return COSReal.construct((double)0.5);
            }
        }
        return null;
    }

    public COSObject getOValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"O"));
        if (object == null || object.empty()) {
            object = this.getODefaultValue();
        }
        return object;
    }

    public Boolean getOHasTypeNumber() {
        COSObject O = this.getOValue();
        return GFA3DRenderMode.getHasTypeNumber(O);
    }

    public Double getONumberValue() {
        COSObject O = this.getOValue();
        return GFA3DRenderMode.getNumberValue(O);
    }

    public Boolean getcontainsSubtype() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"Subtype"));
    }

    public COSObject getSubtypeValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Subtype"));
        return object;
    }

    public Boolean getSubtypeHasTypeName() {
        COSObject Subtype = this.getSubtypeValue();
        return GFA3DRenderMode.getHasTypeName(Subtype);
    }

    public String getSubtypeNameValue() {
        COSObject Subtype = this.getSubtypeValue();
        return GFA3DRenderMode.getNameValue(Subtype);
    }

    public Boolean getcontainsType() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"Type"));
    }

    public COSObject getTypeValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Type"));
        return object;
    }

    public Boolean getTypeHasTypeName() {
        COSObject Type2 = this.getTypeValue();
        return GFA3DRenderMode.getHasTypeName(Type2);
    }

    public String getTypeNameValue() {
        COSObject Type2 = this.getTypeValue();
        return GFA3DRenderMode.getNameValue(Type2);
    }
}

