/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.arlington;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSArray;
import org.verapdf.cos.COSBase;
import org.verapdf.cos.COSDictionary;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.cos.COSStream;
import org.verapdf.gf.model.impl.arlington.GFADataEntry;
import org.verapdf.gf.model.impl.arlington.GFAObject;
import org.verapdf.gf.model.impl.arlington.GFAStream;
import org.verapdf.gf.model.impl.arlington.GFA_UniversalArray;
import org.verapdf.gf.model.impl.arlington.GFA_UniversalDictionary;
import org.verapdf.gf.model.impl.containers.StaticContainers;
import org.verapdf.model.alayer.AData;
import org.verapdf.model.alayer.ADataEntry;
import org.verapdf.model.baselayer.Object;

public class GFAData
extends GFAObject
implements AData {
    public GFAData(COSBase baseObject, COSBase parentObject, String keyName) {
        super(baseObject, parentObject, keyName, "AData");
    }

    public List<? extends Object> getLinkedObjects(String link) {
        switch (link) {
            case "Entries": {
                return this.getEntries();
            }
            case "Private": {
                return this.getPrivate();
            }
        }
        return super.getLinkedObjects(link);
    }

    private List<ADataEntry> getEntries() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_3: 
            case ARLINGTON1_4: 
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return this.getEntries1_3();
            }
        }
        return Collections.emptyList();
    }

    private List<ADataEntry> getEntries1_3() {
        LinkedList<GFADataEntry> list = new LinkedList<GFADataEntry>();
        for (ASAtom key : this.baseObject.getKeySet()) {
            if ("LastModified".equals(key.getValue()) || "Private".equals(key.getValue())) continue;
            COSObject object = this.baseObject.getKey(key);
            list.add(new GFADataEntry(object != null ? object.get() : null, this.baseObject, this.parentObject, this.keyName, key.getValue()));
        }
        return Collections.unmodifiableList(list);
    }

    private List<Object> getPrivate() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_3: 
            case ARLINGTON1_4: 
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return this.getPrivate1_3();
            }
        }
        return Collections.emptyList();
    }

    private List<Object> getPrivate1_3() {
        COSObject object = this.getPrivateValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_ARRAY) {
            ArrayList<GFA_UniversalArray> list = new ArrayList<GFA_UniversalArray>(1);
            list.add(new GFA_UniversalArray((COSBase)((COSArray)object.getDirectBase()), this.baseObject, "Private"));
            return Collections.unmodifiableList(list);
        }
        if (object.getType() == COSObjType.COS_DICT) {
            ArrayList<GFA_UniversalDictionary> list = new ArrayList<GFA_UniversalDictionary>(1);
            list.add(new GFA_UniversalDictionary((COSBase)((COSDictionary)object.getDirectBase()), this.baseObject, "Private"));
            return Collections.unmodifiableList(list);
        }
        if (object.getType() == COSObjType.COS_STREAM) {
            ArrayList<GFAStream> list = new ArrayList<GFAStream>(1);
            list.add(new GFAStream((COSBase)((COSStream)object.getDirectBase()), this.baseObject, "Private"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    public Boolean getcontainsLastModified() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"LastModified"));
    }

    public COSObject getLastModifiedValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"LastModified"));
        return object;
    }

    public Boolean getLastModifiedHasTypeDate() {
        COSObject LastModified = this.getLastModifiedValue();
        return GFAData.getHasTypeDate(LastModified);
    }

    public Boolean getcontainsPrivate() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"Private"));
    }

    public COSObject getPrivateValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Private"));
        return object;
    }

    public Boolean getisPrivateIndirect() {
        COSObject Private = this.getPrivateValue();
        return GFAData.getisIndirect(Private);
    }

    public Boolean getPrivateHasTypeArray() {
        COSObject Private = this.getPrivateValue();
        return GFAData.getHasTypeArray(Private);
    }

    public Boolean getPrivateHasTypeBoolean() {
        COSObject Private = this.getPrivateValue();
        return GFAData.getHasTypeBoolean(Private);
    }

    public Boolean getPrivateHasTypeDictionary() {
        COSObject Private = this.getPrivateValue();
        return GFAData.getHasTypeDictionary(Private);
    }

    public Boolean getPrivateHasTypeInteger() {
        COSObject Private = this.getPrivateValue();
        return GFAData.getHasTypeInteger(Private);
    }

    public Boolean getPrivateHasTypeName() {
        COSObject Private = this.getPrivateValue();
        return GFAData.getHasTypeName(Private);
    }

    public Boolean getPrivateHasTypeNumber() {
        COSObject Private = this.getPrivateValue();
        return GFAData.getHasTypeNumber(Private);
    }

    public Boolean getPrivateHasTypeStream() {
        COSObject Private = this.getPrivateValue();
        return GFAData.getHasTypeStream(Private);
    }

    public Boolean getPrivateHasTypeString() {
        COSObject Private = this.getPrivateValue();
        return GFAData.getHasTypeString(Private);
    }
}

