/**
 * This file is part of veraPDF Validation, a module of the veraPDF project.
 * Copyright (c) 2015, veraPDF Consortium <info@verapdf.org>
 * All rights reserved.
 *
 * veraPDF Validation is free software: you can redistribute it and/or modify
 * it under the terms of either:
 *
 * The GNU General public license GPLv3+.
 * You should have received a copy of the GNU General Public License
 * along with veraPDF Validation as the LICENSE.GPL file in the root of the source
 * tree.  If not, see http://www.gnu.org/licenses/ or
 * https://www.gnu.org/licenses/gpl-3.0.en.html.
 *
 * The Mozilla Public License MPLv2+.
 * You should have received a copy of the Mozilla Public License along with
 * veraPDF Validation as the LICENSE.MPL file in the root of the source tree.
 * If a copy of the MPL was not distributed with this file, you can obtain one at
 * http://mozilla.org/MPL/2.0/.
 */
package org.verapdf.gf.model.impl.arlington;

import org.verapdf.cos.*;
import org.verapdf.model.alayer.*;
import org.verapdf.gf.model.impl.containers.StaticContainers;
import org.verapdf.tools.StaticResources;
import java.util.*;
import org.verapdf.pd.PDNameTreeNode;
import org.verapdf.as.ASAtom;
import java.util.stream.Collectors;
import org.verapdf.pd.structure.PDNumberTreeNode;

public class GFACIP4_ColorIntent extends GFAObject implements ACIP4_ColorIntent {

	public GFACIP4_ColorIntent(COSBase baseObject, COSBase parentObject, String keyName) {
		super(baseObject, parentObject, keyName, "ACIP4_ColorIntent");
	}

	@Override
	public List<? extends org.verapdf.model.baselayer.Object> getLinkedObjects(String link) {
		switch (link) {
			case "CIP4_Coatings":
				return getCIP4_Coatings();
			default:
				return super.getLinkedObjects(link);
		}
	}

	private List<AArrayOfCIP4_Coatings> getCIP4_Coatings() {
		switch (StaticContainers.getFlavour()) {
			case ARLINGTON1_7:
			case ARLINGTON2_0:
				return getCIP4_Coatings1_7();
			default:
				return Collections.emptyList();
		}
	}

	private List<AArrayOfCIP4_Coatings> getCIP4_Coatings1_7() {
		COSObject object = getCIP4_CoatingsValue();
		if (object == null) {
			return Collections.emptyList();
		}
		if (object.getType() == COSObjType.COS_ARRAY) {
			List<AArrayOfCIP4_Coatings> list = new ArrayList<>(1);
			list.add(new GFAArrayOfCIP4_Coatings((COSArray)object.getDirectBase(), this.baseObject, "CIP4_Coatings"));
			return Collections.unmodifiableList(list);
		}
		return Collections.emptyList();
	}

	@Override
	public Boolean getcontainsCIP4_Coatings() {
		return this.baseObject.knownKey(ASAtom.getASAtom("CIP4_Coatings"));
	}

	public COSObject getCIP4_CoatingsValue() {
		COSObject object = this.baseObject.getKey(ASAtom.getASAtom("CIP4_Coatings"));
		return object;
	}

	@Override
	public String getCIP4_CoatingsType() {
		COSObject CIP4_Coatings = getCIP4_CoatingsValue();
		return getObjectType(CIP4_Coatings);
	}

	@Override
	public Boolean getCIP4_CoatingsHasTypeArray() {
		COSObject CIP4_Coatings = getCIP4_CoatingsValue();
		return getHasTypeArray(CIP4_Coatings);
	}

	@Override
	public Boolean getcontainsType() {
		return this.baseObject.knownKey(ASAtom.getASAtom("Type"));
	}

	public COSObject getTypeValue() {
		COSObject object = this.baseObject.getKey(ASAtom.getASAtom("Type"));
		return object;
	}

	@Override
	public String getTypeType() {
		COSObject Type = getTypeValue();
		return getObjectType(Type);
	}

	@Override
	public Boolean getTypeHasTypeName() {
		COSObject Type = getTypeValue();
		return getHasTypeName(Type);
	}

	@Override
	public String getTypeNameValue() {
		COSObject Type = getTypeValue();
		return getNameValue(Type);
	}

}
