/**
 * This file is part of veraPDF Validation, a module of the veraPDF project.
 * Copyright (c) 2015, veraPDF Consortium <info@verapdf.org>
 * All rights reserved.
 *
 * veraPDF Validation is free software: you can redistribute it and/or modify
 * it under the terms of either:
 *
 * The GNU General public license GPLv3+.
 * You should have received a copy of the GNU General Public License
 * along with veraPDF Validation as the LICENSE.GPL file in the root of the source
 * tree.  If not, see http://www.gnu.org/licenses/ or
 * https://www.gnu.org/licenses/gpl-3.0.en.html.
 *
 * The Mozilla Public License MPLv2+.
 * You should have received a copy of the Mozilla Public License along with
 * veraPDF Validation as the LICENSE.MPL file in the root of the source tree.
 * If a copy of the MPL was not distributed with this file, you can obtain one at
 * http://mozilla.org/MPL/2.0/.
 */
package org.verapdf.gf.model.impl.arlington;

import org.verapdf.cos.*;
import org.verapdf.model.alayer.*;
import org.verapdf.gf.model.impl.containers.StaticContainers;
import org.verapdf.tools.StaticResources;
import java.util.*;
import org.verapdf.pd.PDNameTreeNode;
import org.verapdf.as.ASAtom;
import java.util.stream.Collectors;
import org.verapdf.pd.structure.PDNumberTreeNode;

public class GFAExtensions extends GFAObject implements AExtensions {

	public GFAExtensions(COSBase baseObject, COSBase parentObject, String keyName) {
		super(baseObject, parentObject, keyName, "AExtensions");
	}

	@Override
	public List<? extends org.verapdf.model.baselayer.Object> getLinkedObjects(String link) {
		switch (link) {
			case "Entries":
				return getEntries();
			case "GTSm":
				return getGTSm();
			case "ISO_":
				return getISO_();
			default:
				return super.getLinkedObjects(link);
		}
	}

	private List<AExtensionsEntry> getEntries() {
		switch (StaticContainers.getFlavour()) {
			case ARLINGTON1_7:
			case ARLINGTON2_0:
				return getEntries1_7();
			default:
				return Collections.emptyList();
		}
	}

	private List<AExtensionsEntry> getEntries1_7() {
		List<AExtensionsEntry> list = new LinkedList<>();
		for (ASAtom key : baseObject.getKeySet()) {
			if ("GTSm".equals(key.getValue()) || "ISO_".equals(key.getValue()) || "Type".equals(key.getValue())) {
				continue;
			}
			COSObject object = this.baseObject.getKey(key);
			list.add(new GFAExtensionsEntry(object != null ? object.get() : null, this.baseObject, this.parentObject, keyName, key.getValue()));
		}
		return Collections.unmodifiableList(list);
	}

	private List<org.verapdf.model.baselayer.Object> getGTSm() {
		switch (StaticContainers.getFlavour()) {
			case ARLINGTON1_7:
				return getGTSm1_7();
			case ARLINGTON2_0:
				return getGTSm2_0();
			default:
				return Collections.emptyList();
		}
	}

	private List<org.verapdf.model.baselayer.Object> getGTSm1_7() {
		COSObject object = getGTSmValue();
		if (object == null) {
			return Collections.emptyList();
		}
		if (object.getType() == COSObjType.COS_DICT) {
			List<AGTSm_DevExtensions> list = new ArrayList<>(1);
			list.add(new GFAGTSm_DevExtensions((COSDictionary)object.getDirectBase(), this.baseObject, "GTSm"));
			return Collections.unmodifiableList(list);
		}
		return Collections.emptyList();
	}

	private List<org.verapdf.model.baselayer.Object> getGTSm2_0() {
		COSObject object = getGTSmValue();
		if (object == null) {
			return Collections.emptyList();
		}
		if (object.getType() == COSObjType.COS_ARRAY) {
			List<AArrayOfDevExtensions> list = new ArrayList<>(1);
			list.add(new GFAArrayOfDevExtensions((COSArray)object.getDirectBase(), this.baseObject, "GTSm"));
			return Collections.unmodifiableList(list);
		}
		if (object.getType() == COSObjType.COS_DICT) {
			List<AGTSm_DevExtensions> list = new ArrayList<>(1);
			list.add(new GFAGTSm_DevExtensions((COSDictionary)object.getDirectBase(), this.baseObject, "GTSm"));
			return Collections.unmodifiableList(list);
		}
		return Collections.emptyList();
	}

	private List<org.verapdf.model.baselayer.Object> getISO_() {
		switch (StaticContainers.getFlavour()) {
			case ARLINGTON1_7:
				return getISO_1_7();
			case ARLINGTON2_0:
				return getISO_2_0();
			default:
				return Collections.emptyList();
		}
	}

	private List<org.verapdf.model.baselayer.Object> getISO_1_7() {
		COSObject object = getISO_Value();
		if (object == null) {
			return Collections.emptyList();
		}
		if (object.getType() == COSObjType.COS_DICT) {
			List<AISO_DevExtensions> list = new ArrayList<>(1);
			list.add(new GFAISO_DevExtensions((COSDictionary)object.getDirectBase(), this.baseObject, "ISO_"));
			return Collections.unmodifiableList(list);
		}
		return Collections.emptyList();
	}

	private List<org.verapdf.model.baselayer.Object> getISO_2_0() {
		COSObject object = getISO_Value();
		if (object == null) {
			return Collections.emptyList();
		}
		if (object.getType() == COSObjType.COS_ARRAY) {
			List<AArrayOfDevExtensions> list = new ArrayList<>(1);
			list.add(new GFAArrayOfDevExtensions((COSArray)object.getDirectBase(), this.baseObject, "ISO_"));
			return Collections.unmodifiableList(list);
		}
		if (object.getType() == COSObjType.COS_DICT) {
			List<AISO_DevExtensions> list = new ArrayList<>(1);
			list.add(new GFAISO_DevExtensions((COSDictionary)object.getDirectBase(), this.baseObject, "ISO_"));
			return Collections.unmodifiableList(list);
		}
		return Collections.emptyList();
	}

	@Override
	public Boolean getcontainsGTSm() {
		return this.baseObject.knownKey(ASAtom.getASAtom("GTSm"));
	}

	public COSObject getGTSmValue() {
		COSObject object = this.baseObject.getKey(ASAtom.getASAtom("GTSm"));
		return object;
	}

	@Override
	public Boolean getisGTSmIndirect() {
		COSObject GTSm = getGTSmValue();
		return getisIndirect(GTSm);
	}

	@Override
	public String getGTSmType() {
		COSObject GTSm = getGTSmValue();
		return getObjectType(GTSm);
	}

	@Override
	public Boolean getGTSmHasTypeArray() {
		COSObject GTSm = getGTSmValue();
		return getHasTypeArray(GTSm);
	}

	@Override
	public Boolean getGTSmHasTypeDictionary() {
		COSObject GTSm = getGTSmValue();
		return getHasTypeDictionary(GTSm);
	}

	@Override
	public Boolean getcontainsISO_() {
		return this.baseObject.knownKey(ASAtom.getASAtom("ISO_"));
	}

	public COSObject getISO_Value() {
		COSObject object = this.baseObject.getKey(ASAtom.getASAtom("ISO_"));
		return object;
	}

	@Override
	public Boolean getisISO_Indirect() {
		COSObject ISO_ = getISO_Value();
		return getisIndirect(ISO_);
	}

	@Override
	public String getISO_Type() {
		COSObject ISO_ = getISO_Value();
		return getObjectType(ISO_);
	}

	@Override
	public Boolean getISO_HasTypeArray() {
		COSObject ISO_ = getISO_Value();
		return getHasTypeArray(ISO_);
	}

	@Override
	public Boolean getISO_HasTypeDictionary() {
		COSObject ISO_ = getISO_Value();
		return getHasTypeDictionary(ISO_);
	}

	@Override
	public Boolean getcontainsType() {
		return this.baseObject.knownKey(ASAtom.getASAtom("Type"));
	}

	public COSObject getTypeValue() {
		COSObject object = this.baseObject.getKey(ASAtom.getASAtom("Type"));
		return object;
	}

	@Override
	public Boolean getisTypeIndirect() {
		COSObject Type = getTypeValue();
		return getisIndirect(Type);
	}

	@Override
	public String getTypeType() {
		COSObject Type = getTypeValue();
		return getObjectType(Type);
	}

	@Override
	public Boolean getTypeHasTypeName() {
		COSObject Type = getTypeValue();
		return getHasTypeName(Type);
	}

	@Override
	public String getTypeNameValue() {
		COSObject Type = getTypeValue();
		return getNameValue(Type);
	}

}
