/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.arlington;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSArray;
import org.verapdf.cos.COSBase;
import org.verapdf.cos.COSKey;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.cos.COSString;
import org.verapdf.extensions.ExtensionObjectType;
import org.verapdf.gf.model.impl.containers.StaticContainers;
import org.verapdf.model.GenericModelObject;
import org.verapdf.model.alayer.AObject;
import org.verapdf.pd.PDCatalog;
import org.verapdf.pd.PDDocument;
import org.verapdf.pd.PDNameTreeNode;
import org.verapdf.pd.PDNamesDictionary;
import org.verapdf.pd.PDPage;
import org.verapdf.tools.StaticResources;

public class GFAObject
extends GenericModelObject
implements AObject {
    private static final List<String> standardFonts = new LinkedList<String>();
    private static final ThreadLocal<Set<COSKey>> keysSet = new ThreadLocal();
    private static final ThreadLocal<Set<COSKey>> afKeysSet = new ThreadLocal();
    protected static final String PDF_DATE_FORMAT_REGEX = "(D:)?(\\d\\d){2,7}(([Z+-]\\d\\d'(\\d\\d'?)?)?|Z)";
    protected final COSBase baseObject;
    protected COSBase parentObject;
    protected String keyName;

    public GFAObject(COSBase baseObject, COSBase parentObject, String objectType) {
        super(objectType);
        this.baseObject = baseObject;
        this.parentObject = parentObject;
        if (baseObject != null && baseObject.getType() == COSObjType.COS_DICT && baseObject.knownKey(ASAtom.AF).booleanValue()) {
            GFAObject.processAF(baseObject);
        }
    }

    public GFAObject(COSBase baseObject, COSBase parentObject, String keyName, String objectType) {
        this(baseObject, parentObject, objectType);
        this.keyName = keyName;
    }

    public String getID() {
        COSKey key = this.baseObject != null ? this.baseObject.getObjectKey() : null;
        return key != null ? this.getObjectType() + " " + key.toString() : null;
    }

    public String getExtraContext() {
        return this.keyName == null || this.keyName.isEmpty() ? null : this.keyName;
    }

    public Long getsize() {
        return (long)this.baseObject.size();
    }

    public String getkeyName() {
        return this.keyName;
    }

    public String getkeysString() {
        return GFAObject.getkeysString(new COSObject(this.baseObject));
    }

    public Long getnumberOfPages() {
        return StaticResources.getDocument().getPages().size();
    }

    public Long getfileSize() {
        return StaticResources.getDocument().getDocument().getFileSize();
    }

    public Boolean getisPDFTagged() {
        PDDocument document = StaticResources.getDocument();
        PDCatalog catalog = document.getCatalog();
        if (catalog == null) {
            return false;
        }
        COSObject markInfoObject = catalog.getKey(ASAtom.MARK_INFO);
        if (markInfoObject == null || markInfoObject.empty()) {
            return false;
        }
        COSBase markInfo = markInfoObject.getDirectBase();
        if (markInfo.getType() == COSObjType.COS_DICT) {
            return Objects.equals(markInfo.getBooleanKey(ASAtom.MARKED), true);
        }
        return false;
    }

    public String getObjectType(COSObject object) {
        if (object.getType() == COSObjType.COS_ARRAY) {
            return "Array";
        }
        if (object.getType() == COSObjType.COS_BOOLEAN) {
            return "Boolean";
        }
        if (object.getType() == COSObjType.COS_DICT) {
            return "Dictionary";
        }
        if (object.getType() == COSObjType.COS_INTEGER) {
            return "Integer";
        }
        if (object.getType() == COSObjType.COS_NAME) {
            return "Name";
        }
        if (object.getType() == COSObjType.COS_NULL) {
            return "Null";
        }
        if (object.getType() == COSObjType.COS_REAL) {
            return "Number";
        }
        if (object.getType() == COSObjType.COS_STREAM) {
            return "Stream";
        }
        if (object.getType() == COSObjType.COS_STRING) {
            return "String";
        }
        return null;
    }

    public Boolean getnotStandard14Font() {
        COSObject type = this.baseObject.getKey(ASAtom.TYPE);
        if (type == null || type.getType() != COSObjType.COS_NAME || type.getName() != ASAtom.FONT) {
            return false;
        }
        COSObject subtype = this.baseObject.getKey(ASAtom.SUBTYPE);
        if (subtype == null || subtype.getType() != COSObjType.COS_NAME || subtype.getName() != ASAtom.TYPE1) {
            return false;
        }
        COSObject baseFont = this.baseObject.getKey(ASAtom.BASE_FONT);
        if (baseFont == null || baseFont.getType() != COSObjType.COS_NAME) {
            return true;
        }
        return !standardFonts.contains(baseFont.getString());
    }

    public static Double getRectHeight(COSObject object) {
        if (object == null || object.getType() != COSObjType.COS_ARRAY || object.size() != 4) {
            return null;
        }
        COSObject bottom = object.at(1);
        COSObject top = object.at(3);
        if (bottom == null || bottom.getType() != COSObjType.COS_INTEGER && bottom.getType() != COSObjType.COS_REAL) {
            return null;
        }
        if (top == null || top.getType() != COSObjType.COS_INTEGER && top.getType() != COSObjType.COS_REAL) {
            return null;
        }
        return top.getReal() - bottom.getReal();
    }

    public static Double getRectWidth(COSObject object) {
        if (object == null || object.getType() != COSObjType.COS_ARRAY || object.size() != 4) {
            return null;
        }
        COSObject left = object.at(0);
        COSObject right = object.at(2);
        if (left == null || left.getType() != COSObjType.COS_INTEGER && left.getType() != COSObjType.COS_REAL) {
            return null;
        }
        if (right == null || right.getType() != COSObjType.COS_INTEGER && right.getType() != COSObjType.COS_REAL) {
            return null;
        }
        return right.getReal() - left.getReal();
    }

    public static Boolean getisIndirect(COSObject object) {
        return object != null && object.get() != null && object.get().isIndirect() != false;
    }

    public static Boolean getimageIsStructContentItem(COSObject object) {
        return object.isIndirect() != false && GFAObject.getKeysSet().contains(object.getKey());
    }

    public static Long getArraySize(COSObject object) {
        if (object != null && object.getType() == COSObjType.COS_ARRAY) {
            return (long)object.size();
        }
        return null;
    }

    public static Boolean getisArraySortAscending(COSObject object, int number) {
        if (object == null || object.getType() != COSObjType.COS_ARRAY) {
            return false;
        }
        Long previousNumber = null;
        for (int i = 0; i < object.size(); i += number) {
            COSObject elem = object.at(i);
            if (elem == null || elem.getType() != COSObjType.COS_INTEGER) {
                return false;
            }
            if (previousNumber != null && previousNumber > elem.getInteger()) {
                return false;
            }
            previousNumber = elem.getInteger();
        }
        return true;
    }

    public static String getkeysString(COSObject object) {
        Set set = object.getKeySet();
        return set == null ? "" : set.stream().map(ASAtom::getValue).collect(Collectors.joining("&"));
    }

    public static String getEntriesString(COSObject object) {
        if (object == null) {
            return null;
        }
        if (object.getType() == COSObjType.COS_NAME) {
            return object.getString();
        }
        if (object.getType() != COSObjType.COS_ARRAY) {
            return null;
        }
        LinkedList<String> names = new LinkedList<String>();
        for (COSObject elem : (COSArray)object.getDirectBase()) {
            if (elem.getType() != COSObjType.COS_NAME) continue;
            names.add(elem.getString());
        }
        return String.join((CharSequence)"&", names);
    }

    public Boolean getisEncryptedWrapper() {
        PDDocument document = StaticResources.getDocument();
        if (document == null) {
            return false;
        }
        PDCatalog catalog = document.getCatalog();
        if (catalog == null) {
            return false;
        }
        PDNamesDictionary names = catalog.getNamesDictionary();
        if (names == null) {
            return false;
        }
        PDNameTreeNode embeddedFiles = names.getEmbeddedFiles();
        if (embeddedFiles == null) {
            return false;
        }
        for (COSObject embeddedFile : embeddedFiles) {
            COSObject relationship = embeddedFile.getKey(ASAtom.AF_RELATIONSHIP);
            if (relationship == null || relationship.getType() != COSObjType.COS_NAME || relationship.getName() != ASAtom.getASAtom((String)"EncryptedPayload")) continue;
            return true;
        }
        return false;
    }

    public static Boolean hasCycle(COSObject object, ASAtom entryName) {
        if (object == null) {
            return false;
        }
        HashSet<COSKey> visitedKeys = new HashSet<COSKey>();
        while (!object.empty() && object.knownKey(entryName).booleanValue()) {
            if (object.getKey() != null) {
                if (visitedKeys.contains(object.getKey())) {
                    return true;
                }
                visitedKeys.add(object.getKey());
            }
            object = object.getKey(entryName);
        }
        return false;
    }

    public COSObject getInheritableValue(ASAtom key) {
        COSObject keyObject = null;
        HashSet<COSKey> visitedKeys = new HashSet<COSKey>();
        for (COSObject currentObject = this.baseObject.getKey(ASAtom.getASAtom((String)"Parent")); (keyObject == null || keyObject.empty()) && currentObject != null && !currentObject.empty(); currentObject = currentObject.getKey(ASAtom.getASAtom((String)"Parent"))) {
            keyObject = currentObject.getKey(key);
            if (currentObject.getKey() == null) continue;
            if (visitedKeys.contains(currentObject.getKey())) break;
            visitedKeys.add(currentObject.getKey());
        }
        return keyObject;
    }

    protected static COSObject getPageObject(COSObject object) {
        if (object != null && object.getType() == COSObjType.COS_STRING) {
            PDNamesDictionary names = StaticResources.getDocument().getCatalog().getNamesDictionary();
            if (names == null) {
                return null;
            }
            PDNameTreeNode dests = names.getDests();
            if (dests == null) {
                return null;
            }
            object = dests.getObject(object.getString());
        }
        Long pageNumber = null;
        if (object != null && object.getType() == COSObjType.COS_INTEGER) {
            pageNumber = object.getInteger();
        }
        if (pageNumber == null || pageNumber >= (long)StaticResources.getDocument().getPages().size()) {
            return null;
        }
        return ((PDPage)StaticResources.getDocument().getPages().get(pageNumber.intValue())).getObject();
    }

    public Boolean isContainsInheritableValue(ASAtom key) {
        COSObject currentObject;
        HashSet<COSKey> visitedKeys = new HashSet<COSKey>();
        for (currentObject = new COSObject(this.baseObject); currentObject != null && !currentObject.empty() && !currentObject.knownKey(key).booleanValue(); currentObject = currentObject.getKey(ASAtom.getASAtom((String)"Parent"))) {
            if (currentObject.getKey() == null) continue;
            if (visitedKeys.contains(currentObject.getKey())) break;
            visitedKeys.add(currentObject.getKey());
        }
        return currentObject != null && !currentObject.empty() && currentObject.knownKey(key) != false;
    }

    public static void processAF(COSBase object) {
        COSObject RF;
        COSObject AF = object.getKey(ASAtom.getASAtom((String)"AF"));
        if (AF == null) {
            return;
        }
        COSObject EF = AF.getKey(ASAtom.getASAtom((String)"EF"));
        if (EF != null) {
            COSObject UF;
            COSObject F = EF.getKey(ASAtom.getASAtom((String)"F"));
            if (F != null) {
                GFAObject.getAFKeysSet().add(F.getObjectKey());
            }
            if ((UF = EF.getKey(ASAtom.getASAtom((String)"UF"))) != null) {
                GFAObject.getAFKeysSet().add(UF.getObjectKey());
            }
        }
        if ((RF = AF.getKey(ASAtom.getASAtom((String)"RF"))) != null) {
            COSObject UF;
            COSObject F = RF.getKey(ASAtom.getASAtom((String)"F"));
            if (F != null && F.getType() == COSObjType.COS_ARRAY) {
                for (int i = 1; i < F.size(); i += 2) {
                    COSObject obj = F.at(i);
                    if (obj == null) continue;
                    GFAObject.getAFKeysSet().add(obj.getObjectKey());
                }
            }
            if ((UF = RF.getKey(ASAtom.getASAtom((String)"UF"))) != null && UF.getType() == COSObjType.COS_ARRAY) {
                for (int i = 1; i < UF.size(); i += 2) {
                    COSObject obj = UF.at(i);
                    if (obj == null) continue;
                    GFAObject.getAFKeysSet().add(obj.getObjectKey());
                }
            }
        }
    }

    public Boolean getisAssociatedFile() {
        if (this.baseObject.getObjectKey() != null) {
            return GFAObject.getAFKeysSet().contains(this.baseObject.getObjectKey());
        }
        return false;
    }

    public Boolean gethasExtensionAAPL() {
        return StaticContainers.getEnabledExtensions().contains(ExtensionObjectType.AAPL);
    }

    public Boolean gethasExtensionADBE_Extn3() {
        return StaticContainers.getEnabledExtensions().contains(ExtensionObjectType.ADBE_Extn3);
    }

    public Boolean gethasExtensionETSI_PAdES() {
        return StaticContainers.getEnabledExtensions().contains(ExtensionObjectType.ETSI_PAdES);
    }

    public Boolean gethasExtensionISO_19005_3() {
        return StaticContainers.getEnabledExtensions().contains(ExtensionObjectType.ISO_19005_3);
    }

    public Boolean gethasExtensionISO_19593() {
        return StaticContainers.getEnabledExtensions().contains(ExtensionObjectType.ISO_19593);
    }

    public Boolean gethasExtensionISO_21812() {
        return StaticContainers.getEnabledExtensions().contains(ExtensionObjectType.ISO_21812);
    }

    public Boolean gethasExtensionISO_TS_24064() {
        return StaticContainers.getEnabledExtensions().contains(ExtensionObjectType.ISO_TS_24064);
    }

    public Boolean gethasExtensionISO_TS_24654() {
        return StaticContainers.getEnabledExtensions().contains(ExtensionObjectType.ISO_TS_24654);
    }

    public Boolean gethasExtensionISO_TS_32001() {
        return StaticContainers.getEnabledExtensions().contains(ExtensionObjectType.ISO_TS_32001);
    }

    public Boolean gethasExtensionISO_TS_32004() {
        return StaticContainers.getEnabledExtensions().contains(ExtensionObjectType.ISO_TS_32004);
    }

    public Boolean gethasExtensionISO_TS_32007() {
        return StaticContainers.getEnabledExtensions().contains(ExtensionObjectType.ISO_TS_32007);
    }

    public Boolean gethasExtensionMalforms() {
        return StaticContainers.getEnabledExtensions().contains(ExtensionObjectType.Malforms);
    }

    public Boolean gethasExtensionOpenOffice() {
        return StaticContainers.getEnabledExtensions().contains(ExtensionObjectType.OpenOffice);
    }

    public Boolean gethasExtensionPDF_VT2() {
        return StaticContainers.getEnabledExtensions().contains(ExtensionObjectType.PDF_VT2);
    }

    public Boolean gethasExtensionWTPDF() {
        return StaticContainers.getEnabledExtensions().contains(ExtensionObjectType.WTPDF);
    }

    public static Boolean getHasTypeArray(COSObject object) {
        return object != null && object.getType() == COSObjType.COS_ARRAY;
    }

    public static Long getBitmaskValue(COSObject object) {
        if (object != null && object.getType() == COSObjType.COS_INTEGER) {
            return object.getInteger();
        }
        return null;
    }

    public static Boolean getHasTypeBitmask(COSObject object) {
        return object != null && object.getType() == COSObjType.COS_INTEGER;
    }

    public static Boolean getBooleanValue(COSObject object) {
        if (object != null && object.getType() == COSObjType.COS_BOOLEAN) {
            return object.getBoolean();
        }
        return null;
    }

    public static Boolean getHasTypeBoolean(COSObject object) {
        return object != null && object.getType() == COSObjType.COS_BOOLEAN;
    }

    public static String getDateValue(COSObject object) {
        if (object != null && object.getType() == COSObjType.COS_STRING && object.getString().matches(PDF_DATE_FORMAT_REGEX)) {
            return object.getString();
        }
        return null;
    }

    public static Boolean getHasTypeDate(COSObject object) {
        return object != null && object.getType() == COSObjType.COS_STRING && object.getString().matches(PDF_DATE_FORMAT_REGEX);
    }

    public static Boolean getHasTypeDictionary(COSObject object) {
        return object != null && object.getType() == COSObjType.COS_DICT;
    }

    public static Long getIntegerValue(COSObject object) {
        if (object != null && object.getType() == COSObjType.COS_INTEGER) {
            return object.getInteger();
        }
        return null;
    }

    public static Boolean getHasTypeInteger(COSObject object) {
        return object != null && object.getType() == COSObjType.COS_INTEGER;
    }

    public static Boolean getHasTypeMatrix(COSObject object) {
        if (object == null || object.getType() != COSObjType.COS_ARRAY || object.size() != 6) {
            return false;
        }
        for (COSObject elem : (COSArray)object.getDirectBase()) {
            if (elem != null && (elem.getType() == COSObjType.COS_REAL || elem.getType() == COSObjType.COS_INTEGER)) continue;
            return false;
        }
        return true;
    }

    public static String getNameValue(COSObject object) {
        if (object != null && object.getType() == COSObjType.COS_NAME) {
            return object.getString();
        }
        return null;
    }

    public static Boolean getHasTypeName(COSObject object) {
        return object != null && object.getType() == COSObjType.COS_NAME;
    }

    public static Boolean getHasTypeNameTree(COSObject object) {
        return object != null && object.getType() == COSObjType.COS_DICT;
    }

    public static Boolean getHasTypeNull(COSObject object) {
        return object != null && object.getType() == COSObjType.COS_NULL;
    }

    public static Double getNumberValue(COSObject object) {
        if (object != null && object.getType().isNumber()) {
            return object.getReal();
        }
        return null;
    }

    public static Boolean getHasTypeNumber(COSObject object) {
        return object != null && object.getType().isNumber();
    }

    public static Boolean getHasTypeNumberTree(COSObject object) {
        return object != null && object.getType() == COSObjType.COS_DICT;
    }

    public static Boolean getHasTypeRectangle(COSObject object) {
        if (object == null || object.getType() != COSObjType.COS_ARRAY || object.size() != 4) {
            return false;
        }
        for (COSObject elem : (COSArray)object.getDirectBase()) {
            if (elem != null && (elem.getType() == COSObjType.COS_REAL || elem.getType() == COSObjType.COS_INTEGER)) continue;
            return false;
        }
        return true;
    }

    public static Boolean getHasTypeStream(COSObject object) {
        return object != null && object.getType() == COSObjType.COS_STREAM;
    }

    public static String getStringValue(COSObject object) {
        if (object != null && object.getType() == COSObjType.COS_STRING) {
            return object.getString();
        }
        return null;
    }

    public static Boolean getHasTypeString(COSObject object) {
        return object != null && object.getType() == COSObjType.COS_STRING;
    }

    public static String getStringAsciiValue(COSObject object) {
        if (object != null && object.getType() == COSObjType.COS_STRING) {
            return ((COSString)object.getDirectBase()).getASCIIString();
        }
        return null;
    }

    public static Boolean getHasTypeStringAscii(COSObject object) {
        return object != null && object.getType() == COSObjType.COS_STRING && ((COSString)object.getDirectBase()).isASCIIString();
    }

    public static String getStringByteValue(COSObject object) {
        if (object != null && object.getType() == COSObjType.COS_STRING) {
            return object.getString();
        }
        return null;
    }

    public static Boolean getHasTypeStringByte(COSObject object) {
        return object != null && object.getType() == COSObjType.COS_STRING;
    }

    public static String getStringTextValue(COSObject object) {
        if (object != null && object.getType() == COSObjType.COS_STRING) {
            return object.getString();
        }
        return null;
    }

    public static Boolean getHasTypeStringText(COSObject object) {
        return object != null && object.getType() == COSObjType.COS_STRING && ((COSString)object.getDirectBase()).isTextString();
    }

    public static Set<COSKey> getKeysSet() {
        if (keysSet.get() == null) {
            keysSet.set(new HashSet());
        }
        return keysSet.get();
    }

    public static void setKeysSet(Set<COSKey> keysSet) {
        GFAObject.keysSet.set(keysSet);
    }

    public static Set<COSKey> getAFKeysSet() {
        if (afKeysSet.get() == null) {
            afKeysSet.set(new HashSet());
        }
        return afKeysSet.get();
    }

    public static void setAFKeysSet(Set<COSKey> afKeysSet) {
        GFAObject.afKeysSet.set(afKeysSet);
    }

    public static void clearAllContainers() {
        keysSet.set(new HashSet());
        afKeysSet.set(new HashSet());
    }

    static {
        standardFonts.add("Times-Roman");
        standardFonts.add("Helvetica");
        standardFonts.add("Courier");
        standardFonts.add("Symbol");
        standardFonts.add("Times-Bold");
        standardFonts.add("Helvetica-Bold");
        standardFonts.add("Courier-Bold");
        standardFonts.add("ZapfDingbats");
        standardFonts.add("Times-Italic");
        standardFonts.add("Helvetica-Oblique");
        standardFonts.add("Courier-Oblique");
        standardFonts.add("Times-BoldItalic");
        standardFonts.add("Helvetica-BoldOblique");
        standardFonts.add("Courier-BoldOblique");
    }
}

