/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.arlington;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSBase;
import org.verapdf.cos.COSDictionary;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.gf.model.impl.arlington.GFAMac;
import org.verapdf.gf.model.impl.arlington.GFAObject;
import org.verapdf.gf.model.impl.containers.StaticContainers;
import org.verapdf.model.alayer.AAFEmbeddedFileParameter;
import org.verapdf.model.alayer.AMac;
import org.verapdf.model.baselayer.Object;

public class GFAAFEmbeddedFileParameter
extends GFAObject
implements AAFEmbeddedFileParameter {
    public GFAAFEmbeddedFileParameter(COSBase baseObject, COSBase parentObject, String keyName) {
        super(baseObject, parentObject, keyName, "AAFEmbeddedFileParameter");
    }

    public List<? extends Object> getLinkedObjects(String link) {
        switch (link) {
            case "Mac": {
                return this.getMac();
            }
        }
        return super.getLinkedObjects(link);
    }

    private List<AMac> getMac() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_7: {
                if (this.gethasExtensionISO_19005_3().booleanValue()) {
                    return this.getMac1_7();
                }
                return Collections.emptyList();
            }
            case ARLINGTON2_0: {
                return this.getMac1_7();
            }
        }
        return Collections.emptyList();
    }

    private List<AMac> getMac1_7() {
        COSObject object = this.getMacValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_DICT) {
            ArrayList<GFAMac> list = new ArrayList<GFAMac>(1);
            list.add(new GFAMac((COSBase)((COSDictionary)object.getDirectBase()), this.baseObject, "Mac"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    public Boolean getcontainsCheckSum() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"CheckSum"));
    }

    public COSObject getCheckSumValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"CheckSum"));
        return object;
    }

    public String getCheckSumType() {
        COSObject CheckSum = this.getCheckSumValue();
        return this.getObjectType(CheckSum);
    }

    public Boolean getCheckSumHasTypeStringByte() {
        COSObject CheckSum = this.getCheckSumValue();
        return GFAAFEmbeddedFileParameter.getHasTypeStringByte(CheckSum);
    }

    public Long getCheckSumStringSize() {
        COSObject CheckSum = this.getCheckSumValue();
        if (CheckSum != null && CheckSum.getType() == COSObjType.COS_STRING) {
            return CheckSum.getString().length();
        }
        return null;
    }

    public Boolean getcontainsCreationDate() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"CreationDate"));
    }

    public COSObject getCreationDateValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"CreationDate"));
        return object;
    }

    public String getCreationDateType() {
        COSObject CreationDate = this.getCreationDateValue();
        return this.getObjectType(CreationDate);
    }

    public Boolean getCreationDateHasTypeDate() {
        COSObject CreationDate = this.getCreationDateValue();
        return GFAAFEmbeddedFileParameter.getHasTypeDate(CreationDate);
    }

    public Boolean getcontainsMac() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"Mac"));
    }

    public COSObject getMacValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Mac"));
        return object;
    }

    public String getMacType() {
        COSObject Mac = this.getMacValue();
        return this.getObjectType(Mac);
    }

    public Boolean getMacHasTypeDictionary() {
        COSObject Mac = this.getMacValue();
        return GFAAFEmbeddedFileParameter.getHasTypeDictionary(Mac);
    }

    public Boolean getcontainsModDate() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"ModDate"));
    }

    public COSObject getModDateValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"ModDate"));
        return object;
    }

    public String getModDateType() {
        COSObject ModDate = this.getModDateValue();
        return this.getObjectType(ModDate);
    }

    public Boolean getModDateHasTypeDate() {
        COSObject ModDate = this.getModDateValue();
        return GFAAFEmbeddedFileParameter.getHasTypeDate(ModDate);
    }

    public Boolean getcontainsSize() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"Size"));
    }

    public COSObject getSizeValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Size"));
        return object;
    }

    public String getSizeType() {
        COSObject Size = this.getSizeValue();
        return this.getObjectType(Size);
    }

    public Boolean getSizeHasTypeInteger() {
        COSObject Size = this.getSizeValue();
        return GFAAFEmbeddedFileParameter.getHasTypeInteger(Size);
    }

    public Long getSizeIntegerValue() {
        COSObject Size = this.getSizeValue();
        return GFAAFEmbeddedFileParameter.getIntegerValue(Size);
    }
}

