/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.verapdf.ReleaseDetails;
import org.verapdf.component.ComponentDetails;
import org.verapdf.component.Components;
import org.verapdf.containers.StaticCoreContainers;
import org.verapdf.core.EncryptedPdfException;
import org.verapdf.core.ModelParsingException;
import org.verapdf.cos.COSDocument;
import org.verapdf.exceptions.InvalidPasswordException;
import org.verapdf.extensions.ExtensionObjectType;
import org.verapdf.features.AbstractFeaturesExtractor;
import org.verapdf.features.FeatureExtractionResult;
import org.verapdf.features.FeatureExtractorConfig;
import org.verapdf.features.gf.GFFeatureParser;
import org.verapdf.gf.model.impl.arlington.GFADocument;
import org.verapdf.gf.model.impl.arlington.GFAObject;
import org.verapdf.gf.model.impl.containers.StaticContainers;
import org.verapdf.gf.model.impl.cos.GFCosDocument;
import org.verapdf.metadata.fixer.entity.PDFDocument;
import org.verapdf.metadata.fixer.gf.impl.model.PDFDocumentImpl;
import org.verapdf.parser.PDFFlavour;
import org.verapdf.pd.PDCatalog;
import org.verapdf.pd.PDDocument;
import org.verapdf.pd.PDMetadata;
import org.verapdf.pdfa.PDFAParser;
import org.verapdf.pdfa.flavours.PDFAFlavour;
import org.verapdf.pdfa.flavours.PDFFlavours;
import org.verapdf.tools.StaticResources;
import org.verapdf.xmp.XMPException;
import org.verapdf.xmp.containers.StaticXmpCoreContainers;
import org.verapdf.xmp.impl.VeraPDFMeta;

public class GFModelParser
implements PDFAParser {
    private static final ReleaseDetails greenfieldDetails = ReleaseDetails.addDetailsFromResource((String)"org/verapdf/release/validation-model.properties");
    private static final URI id = URI.create("http://pdfa.verapdf.org/parser#verapdf");
    private static final ComponentDetails details = Components.veraDetails((URI)id, (String)"VeraPDF Parser", (String)greenfieldDetails.getVersion(), (String)"veraPDF greenfield PDF parser.");
    private static final Logger logger = Logger.getLogger(GFModelParser.class.getCanonicalName());
    private static final String PDFUA_PREFIX = "ua";
    private final PDDocument document;
    private List<PDFAFlavour> flavour;

    private GFModelParser(InputStream docStream, PDFAFlavour flavour, PDFAFlavour defaultFlavour, String password, EnumSet<ExtensionObjectType> enabledExtensions) throws IOException {
        try {
            GFModelParser.clearStaticContainers();
            GFModelParser.initializeStaticResources(password);
            this.document = new PDDocument(docStream);
            this.setFlavours(GFModelParser.detectFlavour(this.document, flavour, defaultFlavour));
            GFModelParser.initializeStaticContainers(this.document, enabledExtensions);
        }
        catch (Throwable t) {
            this.close();
            throw t;
        }
    }

    private GFModelParser(File pdfFile, PDFAFlavour flavour, PDFAFlavour defaultFlavour, String password, EnumSet<ExtensionObjectType> enabledExtensions) throws IOException {
        try {
            GFModelParser.clearStaticContainers();
            GFModelParser.initializeStaticResources(password);
            this.document = new PDDocument(pdfFile.getAbsolutePath());
            this.setFlavours(GFModelParser.detectFlavour(this.document, flavour, defaultFlavour));
            GFModelParser.initializeStaticContainers(this.document, enabledExtensions);
        }
        catch (Throwable t) {
            this.close();
            throw t;
        }
    }

    private static List<PDFAFlavour> detectFlavour(PDDocument document, PDFAFlavour flavour, PDFAFlavour defaultFlavour) {
        return flavour == PDFAFlavour.NO_FLAVOUR || flavour == PDFAFlavour.NO_ARLINGTON_FLAVOUR ? GFModelParser.obtainArlingtonFlavour(document, defaultFlavour) : Collections.singletonList(flavour);
    }

    public static GFModelParser createModelWithFlavour(InputStream toLoad, PDFAFlavour flavour) throws ModelParsingException, EncryptedPdfException {
        return GFModelParser.createModelWithFlavour(toLoad, flavour, PDFAFlavour.NO_FLAVOUR);
    }

    public static GFModelParser createModelWithFlavour(InputStream toLoad, PDFAFlavour flavour, PDFAFlavour defaultFlavour) throws ModelParsingException, EncryptedPdfException {
        return GFModelParser.createModelWithFlavour(toLoad, flavour, defaultFlavour, null, EnumSet.noneOf(ExtensionObjectType.class));
    }

    public static GFModelParser createModelWithFlavour(InputStream toLoad, PDFAFlavour flavour, String password) throws ModelParsingException, EncryptedPdfException {
        return GFModelParser.createModelWithFlavour(toLoad, flavour, PDFAFlavour.NO_FLAVOUR, password, EnumSet.noneOf(ExtensionObjectType.class));
    }

    public static GFModelParser createModelWithFlavour(InputStream toLoad, PDFAFlavour flavour, PDFAFlavour defaultFlavour, String password, EnumSet<ExtensionObjectType> enabledExtensions) throws ModelParsingException, EncryptedPdfException {
        try {
            return new GFModelParser(toLoad, flavour, defaultFlavour, password, enabledExtensions);
        }
        catch (InvalidPasswordException excep) {
            throw new EncryptedPdfException("The PDF stream appears to be encrypted.", (Throwable)excep);
        }
        catch (IOException e) {
            throw new ModelParsingException("Couldn't parse stream", (Throwable)e);
        }
    }

    public static GFModelParser createModelWithFlavour(File pdfFile, PDFAFlavour flavour) throws ModelParsingException, EncryptedPdfException {
        return GFModelParser.createModelWithFlavour(pdfFile, flavour, PDFAFlavour.NO_FLAVOUR);
    }

    public static GFModelParser createModelWithFlavour(File pdfFile, PDFAFlavour flavour, PDFAFlavour defaultFlavour) throws ModelParsingException, EncryptedPdfException {
        return GFModelParser.createModelWithFlavour(pdfFile, flavour, defaultFlavour, null, EnumSet.noneOf(ExtensionObjectType.class));
    }

    public static GFModelParser createModelWithFlavour(File pdfFile, PDFAFlavour flavour, String password) throws ModelParsingException, EncryptedPdfException {
        return GFModelParser.createModelWithFlavour(pdfFile, flavour, PDFAFlavour.NO_FLAVOUR, password, EnumSet.noneOf(ExtensionObjectType.class));
    }

    public static GFModelParser createModelWithFlavour(File pdfFile, PDFAFlavour flavour, PDFAFlavour defaultFlavour, String password, EnumSet<ExtensionObjectType> enabledExtensions) throws ModelParsingException, EncryptedPdfException {
        try {
            return new GFModelParser(pdfFile, flavour, defaultFlavour, password, enabledExtensions);
        }
        catch (InvalidPasswordException excep) {
            throw new EncryptedPdfException("The PDF stream appears to be encrypted.", (Throwable)excep);
        }
        catch (IOException e) {
            throw new ModelParsingException("Couldn't parse stream", (Throwable)e);
        }
    }

    private static List<PDFAFlavour> obtainFlavours(PDDocument document, PDFAFlavour defaultFlavour) {
        LinkedList<PDFAFlavour> linkedList;
        block12: {
            if (document == null || document.getCatalog() == null) {
                return Collections.singletonList(defaultFlavour);
            }
            PDMetadata metadata = document.getCatalog().getMetadata();
            if (metadata == null) {
                return Collections.singletonList(defaultFlavour);
            }
            LinkedList<PDFAFlavour> flavours = new LinkedList<PDFAFlavour>();
            InputStream is = metadata.getStream();
            try {
                PDFAFlavour pdfuaFlavour;
                VeraPDFMeta veraPDFMeta = VeraPDFMeta.parse((InputStream)is);
                PDFAFlavour pdfaFlavour = GFModelParser.detectPDFAFlavour(veraPDFMeta);
                if (!PDFFlavours.isFlavour((PDFAFlavour)pdfaFlavour, (PDFAFlavour)PDFAFlavour.NO_FLAVOUR)) {
                    flavours.add(pdfaFlavour);
                }
                if (!PDFFlavours.isFlavour((PDFAFlavour)(pdfuaFlavour = GFModelParser.detectPDFUAFlavour(veraPDFMeta)), (PDFAFlavour)PDFAFlavour.NO_FLAVOUR)) {
                    flavours.add(pdfuaFlavour);
                }
                flavours.addAll(GFModelParser.detectWTPDFFlavour(veraPDFMeta));
                List<PDFAFlavour> list = linkedList = flavours.isEmpty() ? Collections.singletonList(defaultFlavour) : flavours;
                if (is == null) break block12;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | XMPException e) {
                    logger.log(Level.FINE, e.getMessage(), e);
                    return Collections.singletonList(defaultFlavour);
                }
            }
            is.close();
        }
        return linkedList;
    }

    private static List<PDFAFlavour> obtainArlingtonFlavour(PDDocument document, PDFAFlavour defaultFlavour) {
        if (document == null) {
            return GFModelParser.getDefaultFlavours(defaultFlavour);
        }
        COSDocument cosDocument = document.getDocument();
        Float version = cosDocument != null ? Float.valueOf(cosDocument.getHeader().getVersion()) : null;
        PDCatalog catalog = document.getCatalog();
        Float catalogVersion = catalog.getFloatVersion();
        if (catalogVersion != null && (version == null || version.floatValue() < catalogVersion.floatValue())) {
            version = catalogVersion;
        }
        if (version == null) {
            return GFModelParser.getDefaultFlavours(defaultFlavour);
        }
        if (version.floatValue() <= 1.4f) {
            version = Float.valueOf(1.4f);
        } else if (version.floatValue() <= 1.7f) {
            version = Float.valueOf(1.7f);
        }
        PDFAFlavour flavour = PDFAFlavour.byFlavourId((String)("arlington" + version));
        return flavour != PDFAFlavour.NO_FLAVOUR ? Collections.singletonList(flavour) : GFModelParser.getDefaultFlavours(defaultFlavour);
    }

    private static List<PDFAFlavour> getDefaultFlavours(PDFAFlavour defaultFlavour) {
        return defaultFlavour == PDFAFlavour.NO_FLAVOUR || defaultFlavour == PDFAFlavour.NO_ARLINGTON_FLAVOUR ? Collections.emptyList() : Collections.singletonList(defaultFlavour);
    }

    private static PDFAFlavour detectPDFAFlavour(VeraPDFMeta veraPDFMeta) {
        try {
            Integer identificationPart = veraPDFMeta.getPDFAIdentificationPart();
            String identificationConformance = veraPDFMeta.getPDFAIdentificationConformance();
            if (identificationConformance == null) {
                identificationConformance = "";
            }
            return PDFAFlavour.byFlavourId((String)(identificationPart + identificationConformance));
        }
        catch (XMPException e) {
            logger.log(Level.FINE, e.getMessage(), e);
            return PDFAFlavour.NO_FLAVOUR;
        }
    }

    private static List<PDFAFlavour> detectWTPDFFlavour(VeraPDFMeta veraPDFMeta) {
        LinkedList<PDFAFlavour> wtpdfFlavours = new LinkedList<PDFAFlavour>();
        if (veraPDFMeta.containsDeclaration("http://pdfa.org/declarations/wtpdf#accessibility1.0")) {
            wtpdfFlavours.add(PDFAFlavour.WTPDF_1_0_ACCESSIBILITY);
        }
        if (veraPDFMeta.containsDeclaration("http://pdfa.org/declarations/wtpdf#reuse1.0")) {
            wtpdfFlavours.add(PDFAFlavour.WTPDF_1_0_REUSE);
        }
        return wtpdfFlavours;
    }

    private static PDFAFlavour detectPDFUAFlavour(VeraPDFMeta veraPDFMeta) {
        try {
            Integer identificationPart = veraPDFMeta.getPDFUAIdentificationPart();
            return PDFAFlavour.byFlavourId((String)(PDFUA_PREFIX + identificationPart));
        }
        catch (XMPException e) {
            logger.log(Level.FINE, e.getMessage(), e);
            return PDFAFlavour.NO_FLAVOUR;
        }
    }

    private static void initializeStaticContainers(PDDocument document, EnumSet<ExtensionObjectType> enabledExtensions) {
        StaticResources.setDocument((PDDocument)document);
        StaticContainers.setEnabledExtensions(enabledExtensions);
        StaticResources.setFlavour(Collections.singletonList(PDFFlavour.NO_FLAVOUR));
    }

    public static List<PDFFlavour> getPDFFlavours(List<PDFAFlavour> flavours) {
        LinkedList<PDFFlavour> resultFlavours = new LinkedList<PDFFlavour>();
        for (PDFAFlavour flavour : flavours) {
            resultFlavours.add(flavour != null ? PDFFlavour.valueOf((String)flavour.name()) : null);
        }
        return resultFlavours;
    }

    private static void initializeStaticResources(String password) {
        StaticResources.setPassword((String)password);
    }

    private static void clearStaticContainers() {
        StaticContainers.clearAllContainers();
        StaticCoreContainers.clearAllContainers();
        StaticResources.clear();
        StaticXmpCoreContainers.clearAllContainers();
    }

    public PDDocument getPDDocument() {
        return this.document;
    }

    public org.verapdf.model.baselayer.Object getRoot() {
        if (PDFAFlavour.SpecificationFamily.ARLINGTON == this.flavour.get(0).getPart().getFamily()) {
            GFAObject.clearAllContainers();
            return new GFADocument(null, null, null);
        }
        return new GFCosDocument(this.document.getDocument());
    }

    public ComponentDetails getDetails() {
        return details;
    }

    public PDFAFlavour getFlavour() {
        return this.flavour.get(0);
    }

    public List<PDFAFlavour> getFlavours() {
        return this.flavour;
    }

    public void setFlavours(List<PDFAFlavour> flavours) {
        this.flavour = flavours;
        StaticContainers.setFlavour(this.flavour);
        StaticCoreContainers.setFlavour(this.flavour);
        StaticResources.setFlavour(Collections.singletonList(PDFFlavour.NO_FLAVOUR));
    }

    public PDFDocument getPDFDocument() {
        return new PDFDocumentImpl(this.document);
    }

    public FeatureExtractionResult getFeatures(FeatureExtractorConfig config) {
        return GFFeatureParser.getFeaturesCollection((PDDocument)this.document, (FeatureExtractorConfig)config);
    }

    public FeatureExtractionResult getFeatures(FeatureExtractorConfig config, List<AbstractFeaturesExtractor> extractors) {
        return GFFeatureParser.getFeaturesCollection((PDDocument)this.document, extractors, (FeatureExtractorConfig)config);
    }

    public void close() {
        if (this.document != null) {
            this.document.close();
        }
    }
}

