/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.operator.base;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.verapdf.cos.COSArray;
import org.verapdf.cos.COSBase;
import org.verapdf.cos.COSInteger;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.gf.model.impl.cos.GFCosInteger;
import org.verapdf.gf.model.impl.cos.GFCosNumber;
import org.verapdf.model.GenericModelObject;
import org.verapdf.model.coslayer.CosInteger;
import org.verapdf.model.coslayer.CosNumber;
import org.verapdf.model.operator.Operator;

public class GFOperator
extends GenericModelObject
implements Operator {
    public static final int MAX_NUMBER_OF_ELEMENTS = 1;
    protected final List<COSBase> arguments;

    protected GFOperator(List<COSBase> arguments, String opType) {
        super(opType);
        this.arguments = arguments;
    }

    protected List<CosNumber> getLastNumber() {
        COSBase base;
        if (!this.arguments.isEmpty() && (base = this.arguments.get(this.arguments.size() - 1)).getType().isNumber()) {
            ArrayList<GFCosNumber> cosNumbers = new ArrayList<GFCosNumber>(1);
            cosNumbers.add(GFCosNumber.fromPDFParserNumber(base));
            return Collections.unmodifiableList(cosNumbers);
        }
        return Collections.emptyList();
    }

    protected List<CosInteger> getLastInteger() {
        COSBase number;
        if (!this.arguments.isEmpty() && (number = this.arguments.get(this.arguments.size() - 1)).getType() == COSObjType.COS_INTEGER) {
            ArrayList<GFCosInteger> list = new ArrayList<GFCosInteger>(1);
            list.add(new GFCosInteger((COSInteger)number));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    protected List<CosNumber> getListOfNumbers() {
        ArrayList<CosNumber> list = new ArrayList<CosNumber>();
        for (COSBase base : this.arguments) {
            if (base.getType() == COSObjType.COS_ARRAY) {
                GFOperator.addArrayElementsAsNumbers(list, (COSArray)base);
                continue;
            }
            if (!base.getType().isNumber()) continue;
            list.add(GFCosNumber.fromPDFParserNumber(base));
        }
        return Collections.unmodifiableList(list);
    }

    private static void addArrayElementsAsNumbers(List<CosNumber> list, COSArray base) {
        for (COSObject arg : base) {
            list.add(GFCosNumber.fromPDFParserNumber(arg.get()));
        }
    }
}

