/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.arlington;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSArray;
import org.verapdf.cos.COSBase;
import org.verapdf.cos.COSDictionary;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.gf.model.impl.arlington.GFAArrayOfStreamsGeneral;
import org.verapdf.gf.model.impl.arlington.GFAObject;
import org.verapdf.gf.model.impl.arlington.GFAVRIMap;
import org.verapdf.gf.model.impl.containers.StaticContainers;
import org.verapdf.model.alayer.AArrayOfStreamsGeneral;
import org.verapdf.model.alayer.ADSS;
import org.verapdf.model.alayer.AVRIMap;
import org.verapdf.model.baselayer.Object;

public class GFADSS
extends GFAObject
implements ADSS {
    public GFADSS(COSBase baseObject, COSBase parentObject, String keyName) {
        super(baseObject, parentObject, keyName, "ADSS");
    }

    public List<? extends Object> getLinkedObjects(String link) {
        switch (link) {
            case "CRLs": {
                return this.getCRLs();
            }
            case "Certs": {
                return this.getCerts();
            }
            case "OCSPs": {
                return this.getOCSPs();
            }
            case "VRI": {
                return this.getVRI();
            }
        }
        return super.getLinkedObjects(link);
    }

    private List<AArrayOfStreamsGeneral> getCRLs() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_7: {
                if (this.gethasExtensionETSI_PAdES().booleanValue()) {
                    return this.getCRLs1_7();
                }
                return Collections.emptyList();
            }
            case ARLINGTON2_0: {
                return this.getCRLs1_7();
            }
        }
        return Collections.emptyList();
    }

    private List<AArrayOfStreamsGeneral> getCRLs1_7() {
        COSObject object = this.getCRLsValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_ARRAY) {
            ArrayList<GFAArrayOfStreamsGeneral> list = new ArrayList<GFAArrayOfStreamsGeneral>(1);
            list.add(new GFAArrayOfStreamsGeneral((COSBase)((COSArray)object.getDirectBase()), this.baseObject, "CRLs"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<AArrayOfStreamsGeneral> getCerts() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_7: {
                if (this.gethasExtensionETSI_PAdES().booleanValue()) {
                    return this.getCerts1_7();
                }
                return Collections.emptyList();
            }
            case ARLINGTON2_0: {
                return this.getCerts1_7();
            }
        }
        return Collections.emptyList();
    }

    private List<AArrayOfStreamsGeneral> getCerts1_7() {
        COSObject object = this.getCertsValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_ARRAY) {
            ArrayList<GFAArrayOfStreamsGeneral> list = new ArrayList<GFAArrayOfStreamsGeneral>(1);
            list.add(new GFAArrayOfStreamsGeneral((COSBase)((COSArray)object.getDirectBase()), this.baseObject, "Certs"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<AArrayOfStreamsGeneral> getOCSPs() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_7: {
                if (this.gethasExtensionETSI_PAdES().booleanValue()) {
                    return this.getOCSPs1_7();
                }
                return Collections.emptyList();
            }
            case ARLINGTON2_0: {
                return this.getOCSPs1_7();
            }
        }
        return Collections.emptyList();
    }

    private List<AArrayOfStreamsGeneral> getOCSPs1_7() {
        COSObject object = this.getOCSPsValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_ARRAY) {
            ArrayList<GFAArrayOfStreamsGeneral> list = new ArrayList<GFAArrayOfStreamsGeneral>(1);
            list.add(new GFAArrayOfStreamsGeneral((COSBase)((COSArray)object.getDirectBase()), this.baseObject, "OCSPs"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<AVRIMap> getVRI() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_7: {
                if (this.gethasExtensionETSI_PAdES().booleanValue()) {
                    return this.getVRI1_7();
                }
                return Collections.emptyList();
            }
            case ARLINGTON2_0: {
                return this.getVRI1_7();
            }
        }
        return Collections.emptyList();
    }

    private List<AVRIMap> getVRI1_7() {
        COSObject object = this.getVRIValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_DICT) {
            ArrayList<GFAVRIMap> list = new ArrayList<GFAVRIMap>(1);
            list.add(new GFAVRIMap((COSBase)((COSDictionary)object.getDirectBase()), this.baseObject, "VRI"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    public Boolean getcontainsCRLs() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"CRLs"));
    }

    public COSObject getCRLsValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"CRLs"));
        return object;
    }

    public String getCRLsType() {
        COSObject CRLs = this.getCRLsValue();
        return this.getObjectType(CRLs);
    }

    public Boolean getCRLsHasTypeArray() {
        COSObject CRLs = this.getCRLsValue();
        return GFADSS.getHasTypeArray(CRLs);
    }

    public Boolean getcontainsCerts() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"Certs"));
    }

    public COSObject getCertsValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Certs"));
        return object;
    }

    public String getCertsType() {
        COSObject Certs = this.getCertsValue();
        return this.getObjectType(Certs);
    }

    public Boolean getCertsHasTypeArray() {
        COSObject Certs = this.getCertsValue();
        return GFADSS.getHasTypeArray(Certs);
    }

    public Boolean getcontainsOCSPs() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"OCSPs"));
    }

    public COSObject getOCSPsValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"OCSPs"));
        return object;
    }

    public String getOCSPsType() {
        COSObject OCSPs = this.getOCSPsValue();
        return this.getObjectType(OCSPs);
    }

    public Boolean getOCSPsHasTypeArray() {
        COSObject OCSPs = this.getOCSPsValue();
        return GFADSS.getHasTypeArray(OCSPs);
    }

    public Boolean getcontainsType() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"Type"));
    }

    public COSObject getTypeValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Type"));
        return object;
    }

    public String getTypeType() {
        COSObject Type2 = this.getTypeValue();
        return this.getObjectType(Type2);
    }

    public Boolean getTypeHasTypeName() {
        COSObject Type2 = this.getTypeValue();
        return GFADSS.getHasTypeName(Type2);
    }

    public String getTypeNameValue() {
        COSObject Type2 = this.getTypeValue();
        return GFADSS.getNameValue(Type2);
    }

    public Boolean getcontainsVRI() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"VRI"));
    }

    public COSObject getVRIValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"VRI"));
        return object;
    }

    public String getVRIType() {
        COSObject VRI = this.getVRIValue();
        return this.getObjectType(VRI);
    }

    public Boolean getVRIHasTypeDictionary() {
        COSObject VRI = this.getVRIValue();
        return GFADSS.getHasTypeDictionary(VRI);
    }
}

