/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.pd;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSArray;
import org.verapdf.cos.COSDictionary;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.gf.model.impl.pd.GFPDOCConfig;
import org.verapdf.gf.model.impl.pd.GFPDObject;
import org.verapdf.model.baselayer.Object;
import org.verapdf.model.pdlayer.PDOCConfig;
import org.verapdf.model.pdlayer.PDOCProperties;
import org.verapdf.pd.PDObject;
import org.verapdf.pd.optionalcontent.PDOptionalContentProperties;

public class GFPDOCProperties
extends GFPDObject
implements PDOCProperties {
    private static final Logger LOGGER = Logger.getLogger(GFPDOCProperties.class.getCanonicalName());
    public static final String OC_PROPERTIES_TYPE = "PDOCProperties";
    public static final String D = "D";
    public static final String CONFIGS = "Configs";

    public GFPDOCProperties(PDOptionalContentProperties simplePDObject) {
        super((PDObject)simplePDObject, OC_PROPERTIES_TYPE);
    }

    public List<? extends Object> getLinkedObjects(String link) {
        switch (link) {
            case "D": {
                return this.getD();
            }
            case "Configs": {
                return this.getConfigs();
            }
        }
        return super.getLinkedObjects(link);
    }

    private List<PDOCConfig> getD() {
        ArrayList<PDOCConfig> result = new ArrayList<PDOCConfig>(1);
        COSObject contentProperties = this.simplePDObject.getObject();
        if (contentProperties.getType() == COSObjType.COS_DICT) {
            COSObject defaultConfig = contentProperties.getKey(ASAtom.D);
            if (!defaultConfig.empty() && defaultConfig.getType() == COSObjType.COS_DICT) {
                List groupNames = ((PDOptionalContentProperties)this.simplePDObject).getGroupNames();
                GFPDOCConfig pdConfig = new GFPDOCConfig(new PDObject(defaultConfig), groupNames, false);
                result.add(pdConfig);
                return result;
            }
        } else {
            LOGGER.log(Level.SEVERE, "Invalid object type of the default optional configuration dictionary. Returning empty config.");
            GFPDOCConfig config = new GFPDOCConfig(new PDObject(COSDictionary.construct()));
            result.add(config);
            return result;
        }
        return result;
    }

    private List<PDOCConfig> getConfigs() {
        COSObject contentProperties = this.simplePDObject.getObject();
        if (contentProperties.getType() != COSObjType.COS_DICT) {
            return Collections.emptyList();
        }
        List<String> names = GFPDOCProperties.getDName((COSDictionary)contentProperties.getDirectBase());
        List groupNames = ((PDOptionalContentProperties)this.simplePDObject).getGroupNames();
        COSObject configs = contentProperties.getKey(ASAtom.CONFIGS);
        if (!configs.empty() && configs.getType() == COSObjType.COS_ARRAY) {
            ArrayList<PDOCConfig> result = new ArrayList<PDOCConfig>();
            for (COSObject config : (COSArray)configs.getDirectBase()) {
                if (!config.empty() && config.getType() == COSObjType.COS_DICT) {
                    GFPDOCConfig pdConfig = new GFPDOCConfig(new PDObject(config), groupNames, names.contains(config.getStringKey(ASAtom.NAME)));
                    String name = pdConfig.getName();
                    if (name != null) {
                        names.add(name);
                    }
                    result.add(pdConfig);
                    continue;
                }
                LOGGER.log(Level.SEVERE, "Invalid object type of the configuration dictionary. Ignoring config.");
            }
            return result;
        }
        return Collections.emptyList();
    }

    private static List<String> getDName(COSDictionary contentProperties) {
        String name;
        ArrayList<String> result = new ArrayList<String>();
        COSObject defaultConfig = contentProperties.getKey(ASAtom.D);
        if (defaultConfig.getType() == COSObjType.COS_DICT && (name = defaultConfig.getStringKey(ASAtom.NAME)) != null) {
            result.add(name);
        }
        return result;
    }

    public Boolean getcontainsConfigs() {
        COSObject configs = this.simplePDObject.getKey(ASAtom.CONFIGS);
        if (!configs.empty() && configs.getType() == COSObjType.COS_ARRAY) {
            for (COSObject config : (COSArray)configs.getDirectBase()) {
                if (config.empty() || config.getType() != COSObjType.COS_DICT) continue;
                return true;
            }
        }
        return false;
    }
}

