/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.pd;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSArray;
import org.verapdf.cos.COSKey;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.gf.model.impl.containers.StaticContainers;
import org.verapdf.gf.model.impl.pd.GFPDObject;
import org.verapdf.gf.model.impl.pd.GFPDStructElem;
import org.verapdf.gf.model.impl.pd.gfse.GFSEFactory;
import org.verapdf.model.pdlayer.PDStructTreeNode;
import org.verapdf.pd.PDObject;
import org.verapdf.pd.structure.PDStructElem;
import org.verapdf.pdfa.flavours.PDFFlavours;
import org.verapdf.tools.TaggedPDFHelper;

public abstract class GFPDStructTreeNode
extends GFPDObject
implements PDStructTreeNode {
    private static final Logger LOGGER = Logger.getLogger(GFPDStructTreeNode.class.getCanonicalName());
    public static final String CHILDREN = "K";
    private List<GFPDStructElem> children;

    protected GFPDStructTreeNode(org.verapdf.pd.structure.PDStructTreeNode structTreeNodeDictionary, String type) {
        super((PDObject)structTreeNodeDictionary, type);
    }

    public String getkidsStandardTypes() {
        if (PDFFlavours.isWCAGFlavour(StaticContainers.getFlavour())) {
            return this.getChildrenStandardTypes().stream().filter(type -> type != null && !"Artifact".equals(type)).collect(Collectors.joining("&"));
        }
        return this.getChildrenStandardTypes().stream().filter(Objects::nonNull).collect(Collectors.joining("&"));
    }

    public Boolean gethasContentItems() {
        return GFPDStructTreeNode.gethasContentItems(this);
    }

    private static Boolean gethasContentItems(GFPDStructTreeNode structElem) {
        COSObject children = structElem.simplePDObject.getKey(ASAtom.K);
        if (children == null) {
            return false;
        }
        if (TaggedPDFHelper.isContentItem((COSObject)children)) {
            return true;
        }
        if (children.getType() == COSObjType.COS_ARRAY) {
            for (COSObject elem : (COSArray)children.getDirectBase()) {
                if (!TaggedPDFHelper.isContentItem((COSObject)elem)) continue;
                return true;
            }
        }
        for (GFPDStructElem child : structElem.getChildren()) {
            if (!PDStructElem.isPassThroughTag((String)child.getstandardType()) || !GFPDStructTreeNode.gethasContentItems(child).booleanValue()) continue;
            return true;
        }
        return false;
    }

    public List<? extends org.verapdf.model.baselayer.Object> getLinkedObjects(String link) {
        switch (link) {
            case "K": {
                return this.getChildren();
            }
        }
        return super.getLinkedObjects(link);
    }

    public List<String> getChildrenStandardTypes() {
        return GFPDStructTreeNode.getChildrenStandardTypes(this);
    }

    private static List<String> getChildrenStandardTypes(GFPDStructTreeNode element) {
        ArrayList<String> res = new ArrayList<String>();
        for (GFPDStructElem child : element.getChildren()) {
            String elementStandardType = child.getstandardType();
            if (PDStructElem.isPassThroughTag((String)elementStandardType)) {
                res.addAll(GFPDStructTreeNode.getChildrenStandardTypes(child));
                continue;
            }
            res.add(elementStandardType);
        }
        return Collections.unmodifiableList(res);
    }

    private List<GFPDStructElem> getChildren() {
        if (this.children == null) {
            List elements = ((org.verapdf.pd.structure.PDStructTreeNode)this.simplePDObject).getStructChildren();
            if (!elements.isEmpty()) {
                if (PDFFlavours.isPDFUARelatedFlavour(StaticContainers.getFlavour())) {
                    this.checkChildrenParent(elements);
                }
                ArrayList<GFPDStructElem> res = new ArrayList<GFPDStructElem>(elements.size());
                for (PDStructElem element : elements) {
                    res.add(GFSEFactory.createTypedStructElem(element));
                }
                this.children = Collections.unmodifiableList(res);
            } else {
                this.children = Collections.emptyList();
            }
        }
        return this.children;
    }

    public List<GFPDStructElem> getStructuralSignificanceChildren() {
        List<GFPDStructElem> children = this.getChildren();
        LinkedList<GFPDStructElem> result = new LinkedList<GFPDStructElem>();
        for (GFPDStructElem child : children) {
            if (PDStructElem.isPassThroughTag((String)child.getstandardType())) {
                result.addAll(child.getStructuralSignificanceChildren());
                continue;
            }
            result.add(child);
        }
        return result;
    }

    private void checkChildrenParent(List<PDStructElem> elements) {
        COSKey key = this.simplePDObject.getObject().getObjectKey();
        for (PDStructElem element : elements) {
            PDStructElem parent = element.getParent();
            if (parent == null || parent.getObject().getObjectKey() != null && Objects.equals(parent.getObject().getObjectKey(), key)) continue;
            LOGGER.log(Level.WARNING, String.format("The value of P key of struct element %s is different from the actual parent struct element %s", element.getObject().getObjectKey() != null ? element.getObject().getObjectKey() : "", key != null ? key : ""));
        }
    }
}

