/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.pd.font;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSDictionary;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.gf.model.factory.operators.RenderingMode;
import org.verapdf.gf.model.impl.pd.GFPDContentStream;
import org.verapdf.gf.model.impl.pd.font.GFPDSimpleFont;
import org.verapdf.gf.model.impl.pd.util.PDResourcesHandler;
import org.verapdf.model.pdlayer.PDContentStream;
import org.verapdf.pd.PDType3CharProc;
import org.verapdf.pd.font.PDSimpleFont;
import org.verapdf.pd.font.PDType3Font;

public class GFPDType3Font
extends GFPDSimpleFont
implements org.verapdf.model.pdlayer.PDType3Font {
    private static final Logger LOGGER = Logger.getLogger(GFPDType3Font.class.getCanonicalName());
    public static final String TYPE3_FONT_TYPE = "PDType3Font";
    public static final String CHAR_STRINGS = "charStrings";
    private PDResourcesHandler resources;
    private Map<String, PDContentStream> charStrings = null;

    public GFPDType3Font(PDType3Font font, RenderingMode renderingMode, PDResourcesHandler resources) {
        super((PDSimpleFont)font, renderingMode, TYPE3_FONT_TYPE);
        this.resources = resources;
    }

    @Override
    public Boolean getisStandard() {
        return false;
    }

    @Override
    public List<? extends org.verapdf.model.baselayer.Object> getLinkedObjects(String link) {
        if (CHAR_STRINGS.equals(link)) {
            return this.getCharStrings();
        }
        return super.getLinkedObjects(link);
    }

    private List<PDContentStream> getCharStrings() {
        if (this.charStrings == null) {
            this.parseCharStrings();
        }
        return new ArrayList<PDContentStream>(this.charStrings.values());
    }

    public Map<String, PDContentStream> getCharProcStreams() {
        if (this.charStrings == null) {
            this.parseCharStrings();
        }
        return Collections.unmodifiableMap(this.charStrings);
    }

    private void parseCharStrings() {
        COSDictionary charProcDict = ((PDType3Font)this.pdFont).getCharProcDict();
        if (charProcDict != null) {
            Set keySet = charProcDict.getKeySet();
            HashMap<String, GFPDContentStream> map = new HashMap<String, GFPDContentStream>(keySet.size());
            for (ASAtom glyphName : keySet) {
                COSObject charProcStream = charProcDict.getKey(glyphName);
                if (!charProcStream.empty() && charProcDict.getType() == COSObjType.COS_DICT) {
                    PDType3CharProc charProc = new PDType3CharProc(charProcStream);
                    GFPDContentStream contentStream = new GFPDContentStream((org.verapdf.pd.PDContentStream)charProc, this.resources);
                    map.put(glyphName.getValue(), contentStream);
                    continue;
                }
                LOGGER.log(Level.FINE, "Invalid entry in the char proc dictionary.");
            }
            this.charStrings = Collections.unmodifiableMap(map);
        } else {
            this.charStrings = Collections.emptyMap();
        }
    }
}

