/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.pd;

import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.gf.model.impl.pd.GFPDObject;
import org.verapdf.model.pdlayer.PDOCConfig;
import org.verapdf.pd.PDObject;

public class GFPDOCConfig
extends GFPDObject
implements PDOCConfig {
    public static final Logger LOGGER = Logger.getLogger(GFPDOCConfig.class.getCanonicalName());
    public static final String OC_CONFIG_TYPE = "PDOCConfig";
    public static final String EVENT_KEY = "Event";
    private final List<String> groupNames;
    private final boolean duplicateName;

    public GFPDOCConfig(PDObject simplePDObject) {
        super(simplePDObject, OC_CONFIG_TYPE);
        this.groupNames = null;
        this.duplicateName = false;
    }

    public GFPDOCConfig(PDObject simplePDObject, List<String> groupNames, boolean duplicateName) {
        super(simplePDObject, OC_CONFIG_TYPE);
        this.groupNames = groupNames;
        this.duplicateName = duplicateName;
    }

    public Boolean getdoesOrderContainAllOCGs() {
        COSObject order = this.simplePDObject.getKey(ASAtom.ORDER);
        if (!order.empty()) {
            if (order.getType() == COSObjType.COS_ARRAY) {
                int groupsInOrder = 0;
                for (int i = 0; i < order.size(); ++i) {
                    COSObject element = order.at(i);
                    if (element.getType() == COSObjType.COS_ARRAY) {
                        groupsInOrder += element.size().intValue();
                        if (this.checkCOSArrayInOrder(element).booleanValue()) continue;
                        return Boolean.FALSE;
                    }
                    if (element.getType() == COSObjType.COS_STRING) {
                        ++groupsInOrder;
                        if (this.checkCOSStringInOrder(element).booleanValue()) continue;
                        return Boolean.FALSE;
                    }
                    if (element.getType() == COSObjType.COS_DICT) {
                        ++groupsInOrder;
                        if (this.checkCOSDictionaryInOrder(element).booleanValue()) continue;
                        return Boolean.FALSE;
                    }
                    LOGGER.log(Level.FINE, "Invalid object type in order array. Ignoring the object.");
                }
                if (groupsInOrder < this.groupNames.size()) {
                    return Boolean.FALSE;
                }
            } else {
                LOGGER.log(Level.FINE, "Invalid object type of Order entry. Ignoring the Order entry.");
            }
        }
        return Boolean.TRUE;
    }

    public String getAS() {
        COSObject asArray = this.simplePDObject.getKey(ASAtom.AS);
        if (!asArray.empty()) {
            String result = "";
            if (asArray.getType() == COSObjType.COS_ARRAY) {
                for (int i = 0; i < asArray.size(); ++i) {
                    COSObject element = asArray.at(i);
                    if (element.getType() == COSObjType.COS_DICT) {
                        String event = element.getStringKey(ASAtom.EVENT);
                        if (event == null || event.isEmpty()) continue;
                        result = result.concat(event);
                        continue;
                    }
                    LOGGER.log(Level.FINE, "Invalid object type in the AS array. Ignoring the object.");
                }
                return result;
            }
            LOGGER.log(Level.FINE, "Invalid object type of AS entry. Ignoring the entry.");
            return result;
        }
        return null;
    }

    public Boolean gethasDuplicateName() {
        return this.duplicateName;
    }

    public String getName() {
        return this.simplePDObject.getObject().getStringKey(ASAtom.NAME);
    }

    private Boolean checkCOSArrayInOrder(COSObject array) {
        for (int i = 0; i < array.size(); ++i) {
            COSObject element = array.at(i);
            if (!(element.getType() == COSObjType.COS_STRING ? this.checkCOSStringInOrder(element) == false : element.getType() == COSObjType.COS_DICT && this.checkCOSDictionaryInOrder(element) == false)) continue;
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    private Boolean checkCOSStringInOrder(COSObject element) {
        return !this.groupNames.contains(element.getString());
    }

    private Boolean checkCOSDictionaryInOrder(COSObject element) {
        return this.groupNames.contains(element.getStringKey(ASAtom.NAME));
    }
}

