/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.external;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.verapdf.as.ASAtom;
import org.verapdf.as.io.ASInputStream;
import org.verapdf.core.VeraPDFException;
import org.verapdf.cos.COSKey;
import org.verapdf.cos.COSStream;
import org.verapdf.gf.model.GFModelParser;
import org.verapdf.gf.model.impl.containers.StaticContainers;
import org.verapdf.gf.model.impl.external.GFExternal;
import org.verapdf.gf.model.impl.pd.colors.GFPDSeparation;
import org.verapdf.model.external.EmbeddedFile;
import org.verapdf.model.operator.Glyph;
import org.verapdf.model.pdlayer.PDFont;
import org.verapdf.parser.PDFFlavour;
import org.verapdf.pd.PDDocument;
import org.verapdf.pd.colors.PDColorSpace;
import org.verapdf.pd.font.FontProgram;
import org.verapdf.pd.font.cmap.CMap;
import org.verapdf.pd.structure.PDStructureNameSpace;
import org.verapdf.pdfa.PDFAParser;
import org.verapdf.pdfa.PDFAValidator;
import org.verapdf.pdfa.flavours.PDFAFlavour;
import org.verapdf.pdfa.results.ValidationResult;
import org.verapdf.pdfa.validation.validators.ValidatorFactory;
import org.verapdf.tools.StaticResources;
import org.verapdf.tools.TaggedPDFRoleMapHelper;
import org.verapdf.xmp.containers.StaticXmpCoreContainers;

public class GFEmbeddedFile
extends GFExternal
implements EmbeddedFile {
    private static final Logger LOGGER = Logger.getLogger(GFEmbeddedFile.class.getCanonicalName());
    public static final String EMBEDDED_FILE_TYPE = "EmbeddedFile";
    private final COSStream stream;
    private PDDocument document;
    private PDFAFlavour flavour;
    private String password;
    private TaggedPDFRoleMapHelper roleMapHelper;
    private Map<String, List<GFPDSeparation>> separations;
    private Map<COSKey, Set<COSKey>> structElementsRefs;
    private List<String> inconsistentSeparations;
    private Map<String, org.verapdf.model.pdlayer.PDColorSpace> cachedColorSpaces;
    private Set<String> noteIDSet;
    private Set<COSKey> xFormKeysSet;
    private Set<COSKey> fileSpecificationKeys;
    private Map<COSKey, Set<COSKey>> destinationToStructParentsMap;
    private Stack<COSKey> transparencyVisitedContentStreams;
    private Map<String, PDFont> cachedPDFonts;
    private Map<String, Map<String, Glyph>> cachedGlyphs;
    private boolean validPDF;
    private Integer lastHeadingNestingLevel;
    private PDColorSpace currentTransparencyColorSpace;
    private Map<String, CMap> cMapCache;
    private Map<COSKey, PDStructureNameSpace> structureNameSpaceCache;
    private Map<String, FontProgram> cachedFonts;
    private Map<String, String> namespaceToPrefixMap;
    private Map<String, String> prefixToNamespaceMap;

    public GFEmbeddedFile(COSStream stream) {
        super(EMBEDDED_FILE_TYPE);
        this.stream = stream;
    }

    public String getSubtype() {
        if (this.stream != null) {
            return this.stream.getNameKeyStringValue(ASAtom.SUBTYPE);
        }
        return null;
    }

    public Boolean getisValidPDFA12() {
        if (this.stream == null) {
            return Boolean.TRUE;
        }
        boolean retVal = false;
        this.saveStaticContainersState();
        try (ASInputStream unfilteredStream = this.stream.getData(COSStream.FilterFlags.DECODE);){
            retVal = GFEmbeddedFile.isValidPdfaStream((InputStream)unfilteredStream, PDFAFlavour.PDFA_1_B);
            if (!retVal) {
                unfilteredStream.reset();
                retVal = GFEmbeddedFile.isValidPdfaStream((InputStream)unfilteredStream, PDFAFlavour.PDFA_2_B);
            }
        }
        catch (IOException | VeraPDFException e) {
            LOGGER.log(Level.FINE, "Exception during validation of embedded file", e);
        }
        this.restoreSavedSCState();
        return retVal;
    }

    public Boolean getisValidPDFA124() {
        if (this.stream == null) {
            return Boolean.TRUE;
        }
        boolean retVal = false;
        this.saveStaticContainersState();
        try (ASInputStream unfilteredStream = this.stream.getData(COSStream.FilterFlags.DECODE);){
            retVal = GFEmbeddedFile.isValidPdfaStream((InputStream)unfilteredStream, PDFAFlavour.PDFA_1_B);
            if (!retVal) {
                unfilteredStream.reset();
                retVal = GFEmbeddedFile.isValidPdfaStream((InputStream)unfilteredStream, PDFAFlavour.PDFA_2_B);
            }
            if (!retVal) {
                unfilteredStream.reset();
                retVal = GFEmbeddedFile.isValidPdfaStream((InputStream)unfilteredStream, PDFAFlavour.PDFA_4);
            }
        }
        catch (IOException | VeraPDFException e) {
            LOGGER.log(Level.FINE, "Exception during validation of embedded file", e);
        }
        this.restoreSavedSCState();
        return retVal;
    }

    private static boolean isValidPdfaStream(InputStream toValidate, PDFAFlavour flavour) throws VeraPDFException {
        try (GFModelParser parser = GFModelParser.createModelWithFlavour(toValidate, flavour);){
            PDFAValidator validator = ValidatorFactory.createValidator((PDFAFlavour)flavour, (boolean)false, (int)1);
            ValidationResult result = validator.validate((PDFAParser)parser);
            parser.close();
            boolean bl = result.isCompliant();
            return bl;
        }
    }

    private void saveStaticContainersState() {
        this.document = StaticResources.getDocument();
        this.flavour = StaticContainers.getFlavour();
        this.password = StaticResources.getPassword();
        this.roleMapHelper = StaticResources.getRoleMapHelper();
        this.separations = StaticContainers.getSeparations();
        this.structElementsRefs = StaticContainers.getStructElementsRefs();
        this.inconsistentSeparations = StaticContainers.getInconsistentSeparations();
        this.cachedColorSpaces = StaticContainers.getCachedColorSpaces();
        this.cachedPDFonts = StaticContainers.getCachedFonts();
        this.fileSpecificationKeys = StaticContainers.getFileSpecificationKeys();
        this.destinationToStructParentsMap = StaticContainers.getDestinationToStructParentsMap();
        this.noteIDSet = StaticContainers.getNoteIDSet();
        this.xFormKeysSet = StaticContainers.getXFormKeysSet();
        this.transparencyVisitedContentStreams = StaticContainers.getTransparencyVisitedContentStreams();
        this.validPDF = StaticContainers.getValidPDF();
        this.lastHeadingNestingLevel = StaticContainers.getLastHeadingNestingLevel();
        this.cachedGlyphs = StaticContainers.getCachedGlyphs();
        this.currentTransparencyColorSpace = StaticContainers.getCurrentTransparencyColorSpace();
        Map cMaps = StaticResources.getcMapCache();
        this.cMapCache = cMaps == null ? null : new HashMap(cMaps);
        Map structureNameSpaceMap = StaticResources.getStructureNameSpaceCache();
        this.structureNameSpaceCache = structureNameSpaceMap == null ? null : new HashMap(structureNameSpaceMap);
        Map cachedFonts = StaticResources.getCachedFonts();
        this.cachedFonts = cachedFonts == null ? null : new HashMap(cachedFonts);
        this.namespaceToPrefixMap = StaticXmpCoreContainers.getNamespaceToPrefixMap();
        this.prefixToNamespaceMap = StaticXmpCoreContainers.getPrefixToNamespaceMap();
    }

    private void restoreSavedSCState() {
        StaticContainers.setFlavour(this.flavour);
        StaticContainers.setSeparations(this.separations);
        StaticContainers.setStructElementsRefs(this.structElementsRefs);
        StaticContainers.setInconsistentSeparations(this.inconsistentSeparations);
        StaticContainers.setCachedColorSpaces(this.cachedColorSpaces);
        StaticContainers.setCachedFonts(this.cachedPDFonts);
        StaticContainers.setFileSpecificationKeys(this.fileSpecificationKeys);
        StaticContainers.setDestinationToStructParentsMap(this.destinationToStructParentsMap);
        StaticContainers.setNoteIDSet(this.noteIDSet);
        StaticContainers.setXFormKeysSet(this.xFormKeysSet);
        StaticContainers.setTransparencyVisitedContentStreams(this.transparencyVisitedContentStreams);
        StaticContainers.setValidPDF(this.validPDF);
        StaticContainers.setLastHeadingNestingLevel(this.lastHeadingNestingLevel);
        StaticContainers.setCachedGlyphs(this.cachedGlyphs);
        StaticContainers.setCurrentTransparencyColorSpace(this.currentTransparencyColorSpace);
        StaticResources.setDocument((PDDocument)this.document);
        StaticResources.setPassword((String)this.password);
        StaticResources.setRoleMapHelper((TaggedPDFRoleMapHelper)this.roleMapHelper);
        StaticResources.setcMapCache(this.cMapCache);
        StaticResources.setStructureNameSpaceCache(this.structureNameSpaceCache);
        StaticResources.setCachedFonts(this.cachedFonts);
        StaticResources.setFlavour(this.flavour != null ? PDFFlavour.valueOf((String)this.flavour.name()) : null);
        StaticXmpCoreContainers.setNamespaceToPrefixMap(this.namespaceToPrefixMap);
        StaticXmpCoreContainers.setPrefixToNamespaceMap(this.prefixToNamespaceMap);
    }
}

