/**
 * This file is part of veraPDF XMP Library Core for Arlington PDF Model, a module of the veraPDF project.
 * Copyright (c) 2015-2025, veraPDF Consortium <info@verapdf.org>
 * All rights reserved.
 *
 * veraPDF XMP Library Core for Arlington PDF Model is free software: you can redistribute it and/or modify
 * it under the terms of either:
 *
 * The GNU General public license GPLv3+.
 * You should have received a copy of the GNU General Public License
 * along with veraPDF XMP Library Core for Arlington PDF Model as the LICENSE.GPL file in the root of the source
 * tree.  If not, see http://www.gnu.org/licenses/ or
 * https://www.gnu.org/licenses/gpl-3.0.en.html.
 *
 * The Mozilla Public License MPLv2+.
 * You should have received a copy of the Mozilla Public License along with
 * veraPDF XMP Library Core for Arlington PDF Model as the LICENSE.MPL file in the root of the source tree.
 * If a copy of the MPL was not distributed with this file, you can obtain one at
 * http://mozilla.org/MPL/2.0/.
 */
// =================================================================================================
// ADOBE SYSTEMS INCORPORATED
// Copyright 2006 Adobe Systems Incorporated
// All Rights Reserved
//
// NOTICE:  Adobe permits you to use, modify, and distribute this file in accordance with the terms
// of the Adobe license agreement accompanying it.
// =================================================================================================

package org.verapdf.xmp.properties;

import org.verapdf.xmp.options.AliasOptions;


/**
 * This interface is used to return info about an alias.
 * 
 * @since   27.01.2006
 */
public interface XMPAliasInfo
{
	/**
	 * @return Returns Returns the namespace URI for the base property.
	 */
	String getNamespace();


	/**
	 * @return Returns the default prefix for the given base property. 
	 */
	String getPrefix();

	
	/**
	 * @return Returns the path of the base property.
	 */
	String getPropName();

	
	/**
	 * @return Returns the kind of the alias. This can be a direct alias
	 *         (ARRAY), a simple property to an ordered array
	 *         (ARRAY_ORDERED), to an alternate array
	 *         (ARRAY_ALTERNATE) or to an alternate text array
	 *         (ARRAY_ALT_TEXT).
	 */
	AliasOptions getAliasForm();
}