/**
 * This file is part of veraPDF XMP Library Core for Jakarta EE, a module of the veraPDF project.
 * Copyright (c) 2015-2025, veraPDF Consortium <info@verapdf.org>
 * All rights reserved.
 *
 * veraPDF XMP Library Core for Jakarta EE is free software: you can redistribute it and/or modify
 * it under the terms of either:
 *
 * The GNU General public license GPLv3+.
 * You should have received a copy of the GNU General Public License
 * along with veraPDF XMP Library Core for Jakarta EE as the LICENSE.GPL file in the root of the source
 * tree.  If not, see http://www.gnu.org/licenses/ or
 * https://www.gnu.org/licenses/gpl-3.0.en.html.
 *
 * The Mozilla Public License MPLv2+.
 * You should have received a copy of the Mozilla Public License along with
 * veraPDF XMP Library Core for Jakarta EE as the LICENSE.MPL file in the root of the source tree.
 * If a copy of the MPL was not distributed with this file, you can obtain one at
 * http://mozilla.org/MPL/2.0/.
 */
package org.verapdf.xmp.impl;

import org.verapdf.xmp.XMPConst;
import org.verapdf.xmp.XMPException;
import org.verapdf.xmp.options.PropertyOptions;

public class VeraPDFExtensionSchemaProperty {

    private static final String NAME = "name";
    private static final String VALUE_TYPE = "valueType";
    private static final String CATEGORY = "category";
    private static final String DESCRIPTION = "description";
    private static final String PDFA_PROPERTY_PREFIX = "pdfaProperty";

    private final VeraPDFXMPNode xmpNode;

    public VeraPDFExtensionSchemaProperty(VeraPDFXMPNode xmpNode) {
        this.xmpNode = xmpNode;
    }

    public String getName() {
        for (VeraPDFXMPNode child : this.xmpNode.getChildren()) {
            if (XMPConst.NS_PDFA_PROPERTY.equals(child.getNamespaceURI()) && NAME.equals(child.getName())) {
                return child.getValue();
            }
        }
        return null;
    }

    public XMPNode getXmpNode() {
        return xmpNode.getOriginalNode();
    }

    public static VeraPDFExtensionSchemaProperty createPropertyDefinitionNode(String name, String valueType, String category, String description) throws XMPException {
        XMPNode node = new XMPNode(XMPConst.ARRAY_ITEM_NAME,"", new PropertyOptions(PropertyOptions.STRUCT), "rdf");
        node.addChild(new XMPNode(PDFA_PROPERTY_PREFIX + ":" + NAME, name, 
                new PropertyOptions(PropertyOptions.NO_OPTIONS), PDFA_PROPERTY_PREFIX));
        node.addChild(new XMPNode(PDFA_PROPERTY_PREFIX + ":" + VALUE_TYPE, valueType, 
                new PropertyOptions(PropertyOptions.NO_OPTIONS), PDFA_PROPERTY_PREFIX));
        node.addChild(new XMPNode(PDFA_PROPERTY_PREFIX + ":" + CATEGORY, category, 
                new PropertyOptions(PropertyOptions.NO_OPTIONS), PDFA_PROPERTY_PREFIX));
        node.addChild(new XMPNode(PDFA_PROPERTY_PREFIX + ":" + DESCRIPTION, description, 
                new PropertyOptions(PropertyOptions.NO_OPTIONS), PDFA_PROPERTY_PREFIX));
        return new VeraPDFExtensionSchemaProperty(VeraPDFXMPNode.fromXMPNode(node));
    }
}
