/**
 * This file is part of veraPDF XMP Library Core for Jakarta EE, a module of the veraPDF project.
 * Copyright (c) 2015-2025, veraPDF Consortium <info@verapdf.org>
 * All rights reserved.
 *
 * veraPDF XMP Library Core for Jakarta EE is free software: you can redistribute it and/or modify
 * it under the terms of either:
 *
 * The GNU General public license GPLv3+.
 * You should have received a copy of the GNU General Public License
 * along with veraPDF XMP Library Core for Jakarta EE as the LICENSE.GPL file in the root of the source
 * tree.  If not, see http://www.gnu.org/licenses/ or
 * https://www.gnu.org/licenses/gpl-3.0.en.html.
 *
 * The Mozilla Public License MPLv2+.
 * You should have received a copy of the Mozilla Public License along with
 * veraPDF XMP Library Core for Jakarta EE as the LICENSE.MPL file in the root of the source tree.
 * If a copy of the MPL was not distributed with this file, you can obtain one at
 * http://mozilla.org/MPL/2.0/.
 */
package org.verapdf.xmp.impl;

import org.verapdf.xmp.XMPException;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class VeraPDFExtensionSchemasContainer {
    
    public static final String PDFA_SCHEMA_PREFIX = "pdfaSchema";
    public static final String PDFA_PROPERTY_PREFIX = "pdfaProperty";
    public static final String NAMESPACE_URI = "namespaceURI";

    private final VeraPDFXMPNode veraPDFXMPNode;

    public VeraPDFExtensionSchemasContainer(VeraPDFXMPNode veraPDFXMPNode) {
        this.veraPDFXMPNode = veraPDFXMPNode;
    }
    
    public void addExtensionSchemaDefinition(VeraPDFExtensionSchemaDefinition veraPDFExtensionSchemaDefinition) throws XMPException {
        veraPDFXMPNode.getOriginalNode().addChild(veraPDFExtensionSchemaDefinition.getXmpNode());
    }
    
    public VeraPDFExtensionSchemaProperty getPropertyDefinition(String namespaceURI, String prefix, String name) {
        VeraPDFExtensionSchemaDefinition definition = getExtensionSchemaDefinitionXMPNode(namespaceURI, prefix);
        if (definition != null) {
            for (VeraPDFExtensionSchemaProperty propertyDefinitionXMPNode : definition.getExtensionSchemaProperties()) {
                if (Objects.equals(propertyDefinitionXMPNode.getName(), name)) {
                    return propertyDefinitionXMPNode;
                }
            }
        }
        return null;
    }

    public VeraPDFExtensionSchemaDefinition getExtensionSchemaDefinitionXMPNode(String namespaceURI, String prefix) {
        for (VeraPDFExtensionSchemaDefinition definition : getExtensionSchemaDefinitions()) {
            if (Objects.equals(definition.getNamespaceURI(), namespaceURI) && Objects.equals(definition.getPrefix(), prefix)) {
                return definition;
            }
        }
        return null;
    }

    private List<VeraPDFExtensionSchemaDefinition> getExtensionSchemaDefinitions() {
        if (this.veraPDFXMPNode != null && this.veraPDFXMPNode.getOptions().isArray()) {
            List<VeraPDFExtensionSchemaDefinition> res = new ArrayList<>();
            for (VeraPDFXMPNode node : this.veraPDFXMPNode.getChildren()) {
                res.add(new VeraPDFExtensionSchemaDefinition(node));
            }
            return Collections.unmodifiableList(res);
        }
        return Collections.emptyList();
    }
}
