/**
 * This file is part of veraPDF PDF/A XMP Library Core, a module of the veraPDF project.
 * Copyright (c) 2015, veraPDF Consortium <info@verapdf.org>
 * All rights reserved.
 *
 * veraPDF PDF/A XMP Library Core is free software: you can redistribute it and/or modify
 * it under the terms of either:
 *
 * The GNU General public license GPLv3+.
 * You should have received a copy of the GNU General Public License
 * along with veraPDF PDF/A XMP Library Core as the LICENSE.GPL file in the root of the source
 * tree.  If not, see http://www.gnu.org/licenses/ or
 * https://www.gnu.org/licenses/gpl-3.0.en.html.
 *
 * The Mozilla Public License MPLv2+.
 * You should have received a copy of the Mozilla Public License along with
 * veraPDF PDF/A XMP Library Core as the LICENSE.MPL file in the root of the source tree.
 * If a copy of the MPL was not distributed with this file, you can obtain one at
 * http://mozilla.org/MPL/2.0/.
 */
// =================================================================================================
// ADOBE SYSTEMS INCORPORATED
// Copyright 2006 Adobe Systems Incorporated
// All Rights Reserved
//
// NOTICE:  Adobe permits you to use, modify, and distribute this file in accordance with the terms
// of the Adobe license agreement accompanying it.
// =================================================================================================

package org.verapdf.xmp;

/**
 * XMP Toolkit Version Information.
 * <p>
 * Version information for the XMP toolkit is stored in the jar-library and available through a
 * runtime call, {@link XMPMetaFactory#getVersionInfo()},  addition static version numbers are
 * defined in "version.properties". 
 * 
 * @since 23.01.2006
 */
public interface XMPVersionInfo
{
	/** @return Returns the primary release number, the "1" in version "1.2.3". */
	int getMajor();


	/** @return Returns the secondary release number, the "2" in version "1.2.3". */
	int getMinor();


	/** @return Returns the tertiary release number, the "3" in version "1.2.3". */
	int getMicro();


	/** @return Returns a rolling build number, monotonically increasing in a release. */
	int getBuild();


	/** @return Returns true if this is a debug build. */
	boolean isDebug();
	
	
	/** @return Returns a comprehensive version information string. */
	String getMessage();
}