/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.wcag.algorithms.entities.tables;

import java.util.ArrayList;
import java.util.List;
import org.verapdf.wcag.algorithms.entities.content.TextInfoChunk;
import org.verapdf.wcag.algorithms.entities.enums.SemanticType;
import org.verapdf.wcag.algorithms.entities.tables.TableToken;
import org.verapdf.wcag.algorithms.entities.tables.TableTokenRow;
import org.verapdf.wcag.algorithms.semanticalgorithms.tables.TableCluster;

public class TableCell
extends TextInfoChunk {
    private final List<TableTokenRow> content = new ArrayList<TableTokenRow>();
    private SemanticType semanticType = null;

    public TableCell() {
    }

    public TableCell(SemanticType semanticType) {
        this();
        this.semanticType = semanticType;
    }

    public TableCell(TableTokenRow row, SemanticType semanticType) {
        super(row.getBoundingBox(), row.getFontSize(), row.getBaseLine());
        this.content.add(row);
        this.semanticType = semanticType;
    }

    public TableCell(TableCluster cluster, SemanticType semanticType) {
        super(cluster.getBoundingBox(), cluster.getFontSize(), cluster.getBaseLine());
        this.content.addAll(cluster.getRows());
        this.semanticType = semanticType;
    }

    public void setSemanticType(SemanticType semanticType) {
        this.semanticType = semanticType;
    }

    public SemanticType getSemanticType() {
        return this.semanticType;
    }

    public void add(TableTokenRow row) {
        this.content.add(row);
        super.add(row);
    }

    public List<TableTokenRow> getContent() {
        return this.content;
    }

    public TableTokenRow getFirstTokenRow() {
        if (this.content.isEmpty()) {
            return null;
        }
        return this.content.get(0);
    }

    public TableTokenRow getLastTokenRow() {
        if (this.content.isEmpty()) {
            return null;
        }
        return this.content.get(this.content.size() - 1);
    }

    public boolean isEmpty() {
        return this.content.isEmpty();
    }

    public void merge(TableCell other) {
        if (other.isEmpty()) {
            return;
        }
        this.content.addAll(other.getContent());
        super.add(other);
    }

    public boolean isTextCell() {
        for (TableTokenRow tableTokenRow : this.content) {
            if (tableTokenRow.getType() == TableToken.TableTokenType.TEXT) continue;
            return false;
        }
        return true;
    }

    public String getString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (TableTokenRow tokenRow : this.content) {
            stringBuilder.append(tokenRow.getString());
        }
        return stringBuilder.toString();
    }
}

