/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.wcag.algorithms.entities.tables.tableBorders;

import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.verapdf.wcag.algorithms.entities.INode;
import org.verapdf.wcag.algorithms.entities.content.LineChunk;
import org.verapdf.wcag.algorithms.entities.geometry.BoundingBox;
import org.verapdf.wcag.algorithms.entities.geometry.Vertex;
import org.verapdf.wcag.algorithms.entities.tables.Table;
import org.verapdf.wcag.algorithms.entities.tables.TableBorderBuilder;
import org.verapdf.wcag.algorithms.entities.tables.tableBorders.TableBorderCell;
import org.verapdf.wcag.algorithms.entities.tables.tableBorders.TableBorderRow;

public class TableBorder {
    public static final double TABLE_BORDER_EPSILON = 0.55;
    private final List<Double> xCoordinates = new LinkedList<Double>();
    private final List<Double> xWidths = new LinkedList<Double>();
    private final List<Double> yCoordinates;
    private final List<Double> yWidths;
    private final TableBorderRow[] rows;
    private final BoundingBox boundingBox;
    private final int numberOfRows;
    private final int numberOfColumns;
    private final Long id;
    private INode node;

    public TableBorder(TableBorderBuilder builder) {
        this.calculateXCoordinates(builder);
        this.yCoordinates = new LinkedList<Double>();
        this.yWidths = new LinkedList<Double>();
        this.calculateYCoordinates(builder);
        this.boundingBox = new BoundingBox(builder.getBoundingBox());
        this.numberOfRows = this.yCoordinates.size() - 1;
        this.numberOfColumns = this.xCoordinates.size() - 1;
        this.rows = new TableBorderRow[this.numberOfRows];
        if (this.numberOfColumns > 1 && this.numberOfRows > 1) {
            this.createMatrix(builder);
        }
        this.id = Table.getNextTableListId();
    }

    private void calculateXCoordinates(TableBorderBuilder builder) {
        List vertexes = builder.getVertexes().stream().sorted(new Vertex.VertexComparatorX()).collect(Collectors.toList());
        double x1 = ((Vertex)vertexes.get(0)).getLeftX();
        double x2 = ((Vertex)vertexes.get(0)).getRightX();
        for (Vertex v : vertexes) {
            if (x2 < v.getLeftX() - 0.011) {
                this.xCoordinates.add(0.5 * (x1 + x2));
                this.xWidths.add(x2 - x1);
                x1 = v.getLeftX();
                x2 = v.getRightX();
                continue;
            }
            if (!(x2 < v.getRightX())) continue;
            x2 = v.getRightX();
        }
        this.xCoordinates.add(0.5 * (x1 + x2));
        this.xWidths.add(x2 - x1);
    }

    public TableBorderRow[] getRows() {
        return this.rows;
    }

    public int getNumberOfRowsWithContent() {
        int numberOfRowsWithContent = 0;
        for (TableBorderRow row : this.rows) {
            if (row.getNumberOfCellWithContent() <= 0) continue;
            ++numberOfRowsWithContent;
        }
        return numberOfRowsWithContent;
    }

    private void calculateYCoordinates(TableBorderBuilder builder) {
        List vertexes = builder.getVertexes().stream().sorted(new Vertex.VertexComparatorY()).collect(Collectors.toList());
        double y1 = ((Vertex)vertexes.get(0)).getTopY();
        double y2 = ((Vertex)vertexes.get(0)).getBottomY();
        for (Vertex v : vertexes) {
            if (y2 > v.getTopY() + 0.011) {
                this.yCoordinates.add(0.5 * (y1 + y2));
                this.yWidths.add(y1 - y2);
                y1 = v.getTopY();
                y2 = v.getBottomY();
                continue;
            }
            if (!(y2 > v.getBottomY())) continue;
            y2 = v.getBottomY();
        }
        this.yCoordinates.add(0.5 * (y1 + y2));
        this.yWidths.add(y1 - y2);
    }

    private void createMatrix(TableBorderBuilder builder) {
        int rowNumber;
        for (int rowNumber2 = 0; rowNumber2 < this.numberOfRows; ++rowNumber2) {
            this.rows[rowNumber2] = new TableBorderRow(rowNumber2, this.numberOfColumns, new BoundingBox(this.boundingBox.getPageNumber(), this.boundingBox.getLeftX(), this.yCoordinates.get(rowNumber2 + 1) - 0.5 * this.yWidths.get(rowNumber2 + 1), this.boundingBox.getRightX(), this.yCoordinates.get(rowNumber2) + 0.5 * this.yWidths.get(rowNumber2)));
            for (int colNumber = 0; colNumber < this.numberOfColumns; ++colNumber) {
                this.rows[rowNumber2].cells[colNumber] = new TableBorderCell(rowNumber2, colNumber, this.numberOfRows - rowNumber2, this.numberOfColumns - colNumber);
            }
        }
        for (LineChunk line : builder.getHorizontalLines()) {
            int i = this.getCoordinateY(line.getCenterY());
            int j1 = this.getCoordinateX(line.getLeftX());
            int j2 = this.getCoordinateX(line.getRightX());
            if (i <= 0 || j1 == -1 || j2 == -1) continue;
            for (int j = j1; j < j2; ++j) {
                this.rows[i - 1].cells[j].rowSpan = 1;
            }
        }
        for (LineChunk line : builder.getVerticalLines()) {
            int j = this.getCoordinateX(line.getCenterX());
            int i1 = this.getCoordinateY(line.getTopY());
            int i2 = this.getCoordinateY(line.getBottomY());
            if (j <= 0 || i1 == -1 || i2 == -1) continue;
            for (int i = i1; i < i2; ++i) {
                this.rows[i].cells[j - 1].colSpan = 1;
            }
        }
        for (rowNumber = this.numberOfRows - 2; rowNumber >= 0; --rowNumber) {
            if (this.rows[rowNumber].cells[this.numberOfColumns - 1].rowSpan == 1) continue;
            this.rows[rowNumber].cells[this.numberOfColumns - 1].rowSpan = this.rows[rowNumber + 1].cells[this.numberOfColumns - 1].rowSpan + 1;
        }
        for (int colNumber = this.numberOfColumns - 2; colNumber >= 0; --colNumber) {
            if (this.rows[this.numberOfRows - 1].cells[colNumber].colSpan == 1) continue;
            this.rows[this.numberOfRows - 1].cells[colNumber].colSpan = this.rows[this.numberOfRows - 1].cells[colNumber + 1].colSpan + 1;
        }
        for (rowNumber = this.numberOfRows - 2; rowNumber >= 0; --rowNumber) {
            for (int colNumber = this.numberOfColumns - 2; colNumber >= 0; --colNumber) {
                if (this.rows[rowNumber].cells[colNumber].colSpan != 1) {
                    this.rows[rowNumber].cells[colNumber].colSpan = this.rows[rowNumber].cells[colNumber + 1].colSpan + 1;
                }
                if (this.rows[rowNumber].cells[colNumber].rowSpan == 1) continue;
                this.rows[rowNumber].cells[colNumber].rowSpan = this.rows[rowNumber + 1].cells[colNumber].rowSpan + 1;
            }
        }
        for (rowNumber = 0; rowNumber < this.numberOfRows; ++rowNumber) {
            for (int colNumber = 0; colNumber < this.numberOfColumns; ++colNumber) {
                if (this.rows[rowNumber].cells[colNumber].colNumber + this.rows[rowNumber].cells[colNumber].colSpan > colNumber + 1) {
                    this.rows[rowNumber].cells[colNumber + 1] = this.rows[rowNumber].cells[colNumber];
                }
                if (this.rows[rowNumber].cells[colNumber].rowNumber + this.rows[rowNumber].cells[colNumber].rowSpan <= rowNumber + 1) continue;
                this.rows[rowNumber + 1].cells[colNumber] = this.rows[rowNumber].cells[colNumber];
            }
        }
        for (rowNumber = 0; rowNumber < this.numberOfRows; ++rowNumber) {
            for (int colNumber = 0; colNumber < this.numberOfColumns; ++colNumber) {
                if (this.rows[rowNumber].cells[colNumber].colNumber != colNumber || this.rows[rowNumber].cells[colNumber].rowNumber != rowNumber) continue;
                TableBorderCell cell = this.rows[rowNumber].cells[colNumber];
                cell.setBoundingBox(new BoundingBox(this.rows[rowNumber].getPageNumber(), this.xCoordinates.get(colNumber) - 0.5 * this.xWidths.get(colNumber), this.yCoordinates.get(rowNumber + cell.rowSpan) - 0.5 * this.yWidths.get(rowNumber + cell.rowSpan), this.xCoordinates.get(colNumber + cell.colSpan) + 0.5 * this.xWidths.get(colNumber + cell.colSpan), this.yCoordinates.get(rowNumber) + 0.5 * this.yWidths.get(rowNumber)));
            }
        }
    }

    public Integer getPageNumber() {
        return this.boundingBox.getPageNumber();
    }

    private int getCoordinateX(double x) {
        for (int i = 0; i < this.xCoordinates.size(); ++i) {
            if (!(x <= this.xCoordinates.get(i) + 0.5 * this.xWidths.get(i) + 1.0E-4) || !(x >= this.xCoordinates.get(i) - 0.5 * this.xWidths.get(i) - 1.0E-4)) continue;
            return i;
        }
        return -1;
    }

    private int getCoordinateY(double y) {
        for (int i = 0; i < this.yCoordinates.size(); ++i) {
            if (!(y <= this.yCoordinates.get(i) + 0.5 * this.yWidths.get(i) + 1.0E-4) || !(y >= this.yCoordinates.get(i) - 0.5 * this.yWidths.get(i) - 1.0E-4)) continue;
            return i;
        }
        return -1;
    }

    private int getClosestLeftX(double x) {
        for (int i = this.xCoordinates.size() - 1; i >= 0; --i) {
            if (!(x >= this.xCoordinates.get(i) - 0.5 * this.xWidths.get(i) - 0.55)) continue;
            return i;
        }
        return -1;
    }

    private int getClosestTopY(double y) {
        for (int i = this.yCoordinates.size() - 1; i >= 0; --i) {
            if (!(y <= this.yCoordinates.get(i) + 0.5 * this.yWidths.get(i) + 0.55)) continue;
            return i;
        }
        return -1;
    }

    public int getNumberOfRows() {
        return this.numberOfRows;
    }

    public int getNumberOfColumns() {
        return this.numberOfColumns;
    }

    public Long getId() {
        return this.id;
    }

    public INode getNode() {
        return this.node;
    }

    public void setNode(INode node) {
        this.node = node;
    }

    public boolean isBadTable() {
        return this.numberOfRows <= 1 || this.numberOfColumns <= 1 || this.numberOfRows == 2 && this.numberOfColumns == 2;
    }

    public BoundingBox getBoundingBox() {
        return this.boundingBox;
    }

    public TableBorderCell getTableBorderCell(BoundingBox box) {
        int xIndex = this.getClosestLeftX(box.getLeftX());
        int yIndex = this.getClosestTopY(box.getTopY());
        if (xIndex < 0 || yIndex < 0) {
            return null;
        }
        TableBorderCell cell = this.rows[yIndex].cells[xIndex];
        if (cell.getRightX() + 0.55 > box.getRightX() && cell.getBottomY() - 0.55 < box.getBottomY()) {
            return cell;
        }
        return null;
    }

    public static class TableBordersComparator
    implements Comparator<TableBorder> {
        @Override
        public int compare(TableBorder border1, TableBorder border2) {
            int res = Double.compare(border2.getBoundingBox().getTopY(), border1.getBoundingBox().getTopY());
            if (res != 0) {
                return res;
            }
            return Double.compare(border1.getBoundingBox().getLeftX(), border2.getBoundingBox().getLeftX());
        }
    }
}

