/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.wcag.algorithms.semanticalgorithms.consumers;

import java.util.ArrayList;
import java.util.List;
import org.verapdf.wcag.algorithms.entities.INode;
import org.verapdf.wcag.algorithms.entities.ITree;
import org.verapdf.wcag.algorithms.entities.RepeatedCharacters;
import org.verapdf.wcag.algorithms.entities.SemanticSpan;
import org.verapdf.wcag.algorithms.entities.SemanticTextNode;
import org.verapdf.wcag.algorithms.entities.content.TextChunk;
import org.verapdf.wcag.algorithms.entities.content.TextLine;
import org.verapdf.wcag.algorithms.entities.enums.SemanticType;
import org.verapdf.wcag.algorithms.entities.geometry.BoundingBox;
import org.verapdf.wcag.algorithms.entities.geometry.MultiBoundingBox;
import org.verapdf.wcag.algorithms.entities.maps.AccumulatedNodeMapper;
import org.verapdf.wcag.algorithms.semanticalgorithms.utils.TextChunkUtils;

public class SemanticDocumentPostprocessingConsumer {
    private final AccumulatedNodeMapper accumulatedNodeMapper;
    private List<RepeatedCharacters> repeatedCharacters = new ArrayList<RepeatedCharacters>();

    public SemanticDocumentPostprocessingConsumer(AccumulatedNodeMapper accumulatedNodeMapper) {
        this.accumulatedNodeMapper = accumulatedNodeMapper;
    }

    public List<RepeatedCharacters> getRepeatedCharacters() {
        return this.repeatedCharacters;
    }

    public void checkForTitle(ITree tree) {
        for (INode node : tree) {
            if (this.checkNode(node)) break;
        }
    }

    public void checkForRepeatedElements(ITree tree) {
        String valueToCheck = "";
        MultiBoundingBox multiBoundingBox = new MultiBoundingBox();
        for (INode node : tree) {
            if (!(node instanceof SemanticSpan)) continue;
            for (TextLine textLine : ((SemanticSpan)node).getLines()) {
                for (TextChunk textChunk : textLine.getTextChunks()) {
                    if (!valueToCheck.isEmpty() && this.areTextChunksChained(valueToCheck, textChunk)) {
                        valueToCheck = valueToCheck + textChunk.getValue();
                        multiBoundingBox.union(textChunk.getBoundingBox());
                        continue;
                    }
                    this.checkRepeatedAndAdd(valueToCheck, multiBoundingBox);
                    valueToCheck = textChunk.getValue();
                    multiBoundingBox = new MultiBoundingBox(textChunk.getBoundingBox());
                }
            }
        }
        this.checkRepeatedAndAdd(valueToCheck, multiBoundingBox);
    }

    private boolean areTextChunksChained(String previousValue, TextChunk secondTextChunk) {
        char firstChar = previousValue.charAt(previousValue.length() - 1);
        char secondChar = secondTextChunk.getValue().charAt(0);
        if (TextChunkUtils.isWhiteSpaceChar(firstChar) && TextChunkUtils.isWhiteSpaceChar(secondChar)) {
            return true;
        }
        return firstChar == secondChar;
    }

    private boolean checkNode(INode node) {
        if (this.isTextNode(node)) {
            if (this.isTitle(node)) {
                node.setSemanticType(SemanticType.TITLE);
                return true;
            }
            for (INode parent = node.getParent(); parent != null && this.accumulatedNodeMapper.get(parent) instanceof SemanticTextNode; parent = parent.getParent()) {
                if (!this.isTitle(parent)) continue;
                parent.setSemanticType(SemanticType.TITLE);
                break;
            }
            return true;
        }
        return false;
    }

    private boolean isTextNode(INode node) {
        INode accumulatedNode = this.accumulatedNodeMapper.get(node);
        return accumulatedNode instanceof SemanticTextNode && !((SemanticTextNode)accumulatedNode).isSpaceNode() && !node.getChildren().isEmpty();
    }

    private boolean isTitle(INode node) {
        return SemanticType.HEADING.equals((Object)node.getSemanticType()) && !SemanticType.HEADING.equals((Object)node.getInitialSemanticType()) || SemanticType.NUMBER_HEADING.equals((Object)node.getSemanticType()) && !SemanticType.NUMBER_HEADING.equals((Object)node.getInitialSemanticType());
    }

    private void checkRepeatedAndAdd(String value, BoundingBox boundingBox) {
        if (value == null || value.isEmpty()) {
            return;
        }
        char[] characters = value.toCharArray();
        char lastCharacter = characters[0];
        boolean isLastCharacterWhiteSpace = TextChunkUtils.isWhiteSpaceChar(lastCharacter);
        int length = 0;
        for (char character : characters) {
            if (isLastCharacterWhiteSpace && TextChunkUtils.isWhiteSpaceChar(character) || lastCharacter == character) {
                ++length;
                continue;
            }
            if (length > 2) {
                this.repeatedCharacters.add(new RepeatedCharacters(!isLastCharacterWhiteSpace, length, boundingBox));
            }
            length = 1;
            lastCharacter = character;
            isLastCharacterWhiteSpace = TextChunkUtils.isWhiteSpaceChar(lastCharacter);
        }
        if (length > 2) {
            this.repeatedCharacters.add(new RepeatedCharacters(!isLastCharacterWhiteSpace, length, boundingBox));
        }
    }
}

