/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.wcag.algorithms.semanticalgorithms.utils;

import org.verapdf.wcag.algorithms.entities.INode;
import org.verapdf.wcag.algorithms.entities.SemanticHeading;
import org.verapdf.wcag.algorithms.entities.SemanticImageNode;
import org.verapdf.wcag.algorithms.entities.SemanticTextNode;
import org.verapdf.wcag.algorithms.entities.content.LineChunk;
import org.verapdf.wcag.algorithms.entities.content.TextChunk;
import org.verapdf.wcag.algorithms.entities.enums.SemanticType;
import org.verapdf.wcag.algorithms.entities.geometry.BoundingBox;
import org.verapdf.wcag.algorithms.entities.tables.Table;
import org.verapdf.wcag.algorithms.semanticalgorithms.utils.ChunksMergeUtils;
import org.verapdf.wcag.algorithms.semanticalgorithms.utils.listLabelsDetection.ListLabelsDetectionAlgorithm;

public class NodeUtils {
    private static final double FLOATING_POINT_OPERATIONS_EPS = 1.0E-7;
    private static final double[] DEFAULT_INTERVAL_BEFORE_IMAGE = new double[]{0.0, 1.75};
    private static final double[] DEFAULT_INTERVAL_AFTER_IMAGE = new double[]{0.0, 1.8};
    private static final double IMAGE_INTERVAL_STANDARD = 1.0;
    public static final double EPSILON = 1.0E-4;
    public static final double TABLE_BORDER_EPSILON = 0.011;
    public static final double[] UNDERLINED_TEXT_EPSILONS = new double[]{0.05, 0.3, 0.3, 0.3};
    private static final double WITH_TOLERANCE_FACTOR = 0.33;
    private static final double[] HEADING_PROBABILITY_PARAMS = new double[]{0.55, 0.55, 0.3, 0.0291, 0.15, 0.15, 0.1, 0.1};
    private static final double[] CAPTION_PROBABILITY_PARAMS = new double[]{1.0, 0.95, 0.9, 0.85, 0.2, 0.1, 0.03};
    public static final String FIGURE = "Figure";

    public static double headingProbability(INode node, INode previousNode, INode nextNode, INode nextNextNode, SemanticType initialSemanticType) {
        if (node == null) {
            return 0.0;
        }
        if (!(node instanceof SemanticTextNode)) {
            return 0.0;
        }
        SemanticTextNode textNode = (SemanticTextNode)node;
        if (textNode.isEmpty()) {
            return 0.0;
        }
        double headingProbability = 0.0;
        if (previousNode == null || previousNode instanceof SemanticHeading) {
            if (nextNode != null) {
                double probabilityNextNode = NodeUtils.headingProbability(textNode, nextNode);
                headingProbability = NodeUtils.areCloseNumbers(probabilityNextNode, 0.0) && nextNextNode != null ? (headingProbability += NodeUtils.headingProbability(textNode, nextNextNode)) : (headingProbability += probabilityNextNode);
            }
        } else {
            double probability;
            headingProbability = nextNode == null ? (headingProbability += NodeUtils.headingProbability(textNode, previousNode)) : (NodeUtils.areCloseNumbers(probability = NodeUtils.headingProbability(textNode, nextNode), 0.0) ? (nextNextNode != null ? (headingProbability += Math.min(NodeUtils.headingProbability(textNode, previousNode), NodeUtils.headingProbability(textNode, nextNextNode))) : (headingProbability += NodeUtils.headingProbability(textNode, previousNode))) : (headingProbability += Math.min(NodeUtils.headingProbability(textNode, previousNode), probability)));
        }
        if (textNode.hasFullLines()) {
            headingProbability += HEADING_PROBABILITY_PARAMS[2];
        }
        if (textNode.isStartsWithArabicNumber()) {
            headingProbability += HEADING_PROBABILITY_PARAMS[6];
        }
        if (SemanticType.HEADING.equals((Object)initialSemanticType) || SemanticType.NUMBER_HEADING.equals((Object)initialSemanticType)) {
            headingProbability += HEADING_PROBABILITY_PARAMS[7];
        }
        return Math.max(Math.min(headingProbability * NodeUtils.getLinesNumberHeadingProbability(textNode), 1.0), 0.0);
    }

    public static double headingProbability(SemanticTextNode textNode, INode neighborNode) {
        if (neighborNode == null) {
            return 1.0;
        }
        if (!(neighborNode instanceof SemanticTextNode)) {
            return 0.0;
        }
        SemanticTextNode neighborTextNode = (SemanticTextNode)neighborNode;
        double probability = 0.0;
        if (textNode.getFontWeight() > neighborTextNode.getFontWeight() + 1.0E-7) {
            probability += HEADING_PROBABILITY_PARAMS[0];
        } else if (neighborTextNode.getFontWeight() > textNode.getFontWeight() + 1.0E-7) {
            probability -= HEADING_PROBABILITY_PARAMS[4];
        }
        if (textNode.getFontSize() > neighborTextNode.getFontSize() + 1.0E-7) {
            probability += HEADING_PROBABILITY_PARAMS[1];
        } else if (neighborTextNode.getFontSize() > textNode.getFontSize() + 1.0E-7) {
            probability -= HEADING_PROBABILITY_PARAMS[5];
        }
        return probability;
    }

    private static double getLinesNumberHeadingProbability(SemanticTextNode textNode) {
        return Math.max(0.0, 1.0 - HEADING_PROBABILITY_PARAMS[3] * (double)(textNode.getLinesNumber() - 1) * (double)(textNode.getLinesNumber() - 1));
    }

    public static double imageCaptionProbability(INode node, INode neighborNode) {
        if (node == null) {
            return 0.0;
        }
        if (neighborNode == null) {
            return 1.0;
        }
        if (!(node instanceof SemanticTextNode)) {
            return 0.0;
        }
        if (!(neighborNode instanceof SemanticImageNode)) {
            return 0.0;
        }
        SemanticTextNode textNode = (SemanticTextNode)node;
        SemanticImageNode neighborImageNode = (SemanticImageNode)neighborNode;
        double captionProbability = NodeUtils.captionVerticalProbability(textNode, neighborImageNode.getBoundingBox());
        captionProbability *= NodeUtils.captionHorizontalProbability(textNode, neighborImageNode.getBoundingBox());
        captionProbability *= NodeUtils.getLinesNumberCaptionProbability(textNode);
        return Math.min(captionProbability += NodeUtils.captionContentProbability(textNode, FIGURE), 1.0);
    }

    public static double tableCaptionProbability(INode node, Table table) {
        if (node == null) {
            return 0.0;
        }
        if (!(node instanceof SemanticTextNode)) {
            return 0.0;
        }
        SemanticTextNode textNode = (SemanticTextNode)node;
        double captionProbability = NodeUtils.captionVerticalProbability(textNode, table.getBoundingBox());
        captionProbability *= NodeUtils.captionHorizontalProbability(textNode, table.getBoundingBox());
        captionProbability *= NodeUtils.getLinesNumberCaptionProbability(textNode);
        return Math.min(captionProbability += NodeUtils.captionContentProbability(textNode, SemanticType.TABLE.getValue()), 1.0);
    }

    private static double getLinesNumberCaptionProbability(SemanticTextNode textNode) {
        return Math.max(0.0, 1.0 - CAPTION_PROBABILITY_PARAMS[6] * (double)(textNode.getLinesNumber() - 1) * (double)(textNode.getLinesNumber() - 1));
    }

    private static boolean isContaining(SemanticTextNode textNode, BoundingBox imageBoundingBox) {
        double tol = 0.33 * textNode.getFontSize();
        return imageBoundingBox.getLeftX() + tol > textNode.getLeftX() && imageBoundingBox.getRightX() < textNode.getRightX() + tol;
    }

    private static boolean isContaining(BoundingBox imageBoundingBox, SemanticTextNode textNode) {
        double tol = 0.33 * textNode.getFontSize();
        return textNode.getLeftX() + tol > imageBoundingBox.getLeftX() && textNode.getRightX() < imageBoundingBox.getRightX() + tol;
    }

    private static boolean areStrongCenterOverlapping(SemanticTextNode textNode, BoundingBox imageBoundingBox) {
        double tol = 0.33 * textNode.getFontSize();
        double textCenter = textNode.getBoundingBox().getCenterX();
        double imageCenter = imageBoundingBox.getCenterX();
        if (textCenter + tol > imageBoundingBox.getRightX() || textCenter < imageBoundingBox.getLeftX() + tol) {
            return false;
        }
        return !(imageCenter + tol > textNode.getRightX()) && !(imageCenter < textNode.getLeftX() + tol);
    }

    private static boolean areCenterOverlapping(SemanticTextNode textNode, BoundingBox imageBoundingBox) {
        double tol = 0.33 * textNode.getFontSize();
        double textCenter = textNode.getBoundingBox().getCenterX();
        double imageCenter = imageBoundingBox.getCenterX();
        if (textCenter + tol < imageBoundingBox.getRightX() && textCenter > imageBoundingBox.getLeftX() + tol) {
            return true;
        }
        return imageCenter + tol < textNode.getRightX() && imageCenter > textNode.getLeftX() + tol;
    }

    private static boolean areOverlapping(SemanticTextNode textNode, SemanticImageNode imageNode) {
        double tol = 0.33 * textNode.getFontSize();
        return textNode.getLeftX() + tol < imageNode.getRightX() && imageNode.getLeftX() + tol < textNode.getRightX();
    }

    public static boolean areOverlapping(TextChunk textChunk, LineChunk lineChunk) {
        return Math.min(lineChunk.getRightX() - textChunk.getLeftX(), textChunk.getRightX() - lineChunk.getLeftX()) > UNDERLINED_TEXT_EPSILONS[0] * textChunk.getBoundingBox().getWidth();
    }

    private static double captionVerticalProbability(SemanticTextNode textNode, BoundingBox imageBoundingBox) {
        if (textNode.getLastPageNumber() == null || imageBoundingBox.getPageNumber() == null || textNode.getPageNumber() == null || imageBoundingBox.getLastPageNumber() == null) {
            return 0.0;
        }
        if (!textNode.getPageNumber().equals(textNode.getLastPageNumber()) || !textNode.getPageNumber().equals(imageBoundingBox.getPageNumber())) {
            return 0.0;
        }
        double firstBaseline = textNode.getFirstBaseline();
        double lastBaseline = textNode.getLastBaseline();
        if (lastBaseline > imageBoundingBox.getTopY() + 1.0E-7) {
            return ChunksMergeUtils.getUniformProbability(DEFAULT_INTERVAL_BEFORE_IMAGE, (lastBaseline - imageBoundingBox.getTopY()) / textNode.getFontSize(), 1.0);
        }
        if (firstBaseline < imageBoundingBox.getBottomY() - 1.0E-7) {
            return ChunksMergeUtils.getUniformProbability(DEFAULT_INTERVAL_AFTER_IMAGE, (imageBoundingBox.getBottomY() - firstBaseline) / textNode.getFontSize(), 1.0);
        }
        return 0.0;
    }

    private static double captionContentProbability(SemanticTextNode textNode, String prefix) {
        String value = textNode.getFirstLine().getValue().trim();
        if (value.startsWith(prefix)) {
            if (!(value = value.substring(prefix.length()).trim()).isEmpty() && ListLabelsDetectionAlgorithm.getRegexStartLength(value, "\\d+") > 0) {
                return CAPTION_PROBABILITY_PARAMS[4];
            }
            return CAPTION_PROBABILITY_PARAMS[5];
        }
        return 0.0;
    }

    private static double captionHorizontalProbability(SemanticTextNode textNode, BoundingBox imageBoundingBox) {
        if (NodeUtils.isContaining(imageBoundingBox, textNode) && NodeUtils.areStrongCenterOverlapping(textNode, imageBoundingBox)) {
            return CAPTION_PROBABILITY_PARAMS[0];
        }
        if (NodeUtils.isContaining(imageBoundingBox, textNode) && NodeUtils.areCenterOverlapping(textNode, imageBoundingBox)) {
            return CAPTION_PROBABILITY_PARAMS[1];
        }
        if (NodeUtils.isContaining(textNode, imageBoundingBox) && NodeUtils.areStrongCenterOverlapping(textNode, imageBoundingBox)) {
            return CAPTION_PROBABILITY_PARAMS[2];
        }
        if (NodeUtils.isContaining(textNode, imageBoundingBox) && NodeUtils.areCenterOverlapping(textNode, imageBoundingBox)) {
            return CAPTION_PROBABILITY_PARAMS[3];
        }
        return 0.0;
    }

    public static boolean areCloseNumbers(double d1, double d2, double epsilon) {
        return Math.abs(d1 - d2) <= epsilon;
    }

    public static boolean areCloseNumbers(double d1, double d2) {
        return NodeUtils.areCloseNumbers(d1, d2, 1.0E-4);
    }
}

