/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.wcag.algorithms.entities.lists;

import java.util.ArrayList;
import java.util.List;
import org.verapdf.wcag.algorithms.entities.content.InfoChunk;
import org.verapdf.wcag.algorithms.entities.lists.ListItem;
import org.verapdf.wcag.algorithms.entities.tables.Table;
import org.verapdf.wcag.algorithms.entities.tables.TableCell;
import org.verapdf.wcag.algorithms.entities.tables.TableRow;
import org.verapdf.wcag.algorithms.entities.tables.TableToken;
import org.verapdf.wcag.algorithms.semanticalgorithms.utils.TableUtils;

public class PDFList
extends InfoChunk {
    private final List<ListItem> listItems;

    public PDFList(Table table) {
        super(table.getBoundingBox());
        this.setRecognizedStructureId(table.getId());
        this.listItems = new ArrayList<ListItem>();
        this.createListItemsFromTableRows(table.getRows());
    }

    public int getNumberOfListItems() {
        return this.listItems.size();
    }

    public List<ListItem> getListItems() {
        return this.listItems;
    }

    public void add(ListItem listItem) {
        this.listItems.add(listItem);
        this.getBoundingBox().union(listItem.getBoundingBox());
    }

    private void createListItemsFromTableRows(List<TableRow> tableRows) {
        ListItem lastListItem = null;
        Double maxGap = null;
        for (TableRow row : tableRows) {
            TableCell cell = row.getCells().get(0);
            if (cell.getString().trim().isEmpty() && (cell.getContent().isEmpty() || cell.getContent().get(0).getType() == TableToken.TableTokenType.TEXT) && lastListItem != null) {
                double gap = TableUtils.getRowGapFactor(lastListItem, row);
                if (maxGap == null) {
                    maxGap = 1.5 * gap;
                } else {
                    if (!(gap < maxGap)) break;
                    maxGap = Math.max(1.5 * gap, maxGap);
                }
                lastListItem.add(row);
                continue;
            }
            lastListItem = new ListItem(row);
            this.add(lastListItem);
        }
    }
}

