/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.wcag.algorithms.semanticalgorithms.consumers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.verapdf.wcag.algorithms.entities.INode;
import org.verapdf.wcag.algorithms.entities.SemanticFigure;
import org.verapdf.wcag.algorithms.entities.SemanticImageNode;
import org.verapdf.wcag.algorithms.entities.SemanticList;
import org.verapdf.wcag.algorithms.entities.SemanticSpan;
import org.verapdf.wcag.algorithms.entities.SemanticTextNode;
import org.verapdf.wcag.algorithms.entities.content.ImageChunk;
import org.verapdf.wcag.algorithms.entities.content.LineArtChunk;
import org.verapdf.wcag.algorithms.entities.content.TextLine;
import org.verapdf.wcag.algorithms.entities.enums.SemanticType;
import org.verapdf.wcag.algorithms.entities.lists.ListInterval;
import org.verapdf.wcag.algorithms.entities.lists.ListIntervalsCollection;
import org.verapdf.wcag.algorithms.entities.lists.info.ListItemImageInfo;
import org.verapdf.wcag.algorithms.entities.lists.info.ListItemInfo;
import org.verapdf.wcag.algorithms.entities.lists.info.ListItemLineArtInfo;
import org.verapdf.wcag.algorithms.entities.lists.info.ListItemTextInfo;
import org.verapdf.wcag.algorithms.entities.tables.tableBorders.TableBorder;
import org.verapdf.wcag.algorithms.semanticalgorithms.containers.StaticContainers;
import org.verapdf.wcag.algorithms.semanticalgorithms.utils.ErrorCodes;
import org.verapdf.wcag.algorithms.semanticalgorithms.utils.ListLabelsUtils;
import org.verapdf.wcag.algorithms.semanticalgorithms.utils.ListUtils;

public class ListDetectionConsumer
implements Consumer<INode> {
    @Override
    public void accept(INode node) {
        boolean isLeafChild = node.getChildren().stream().allMatch(child -> child instanceof SemanticSpan || child instanceof SemanticImageNode || child instanceof SemanticFigure || child.getSemanticType() == null);
        if (isLeafChild) {
            return;
        }
        this.acceptSemanticList(node);
        if (node.getSemanticType() != SemanticType.LIST) {
            this.checkNeighborLists(node);
        }
        this.checkListInsideList(node);
    }

    private void checkListInsideList(INode node) {
        if (node.getInitialSemanticType() == SemanticType.LIST && node.getChildren().size() == 1 && node.getChildren().get(0).getSemanticType() == SemanticType.LIST) {
            ErrorCodes.addErrorCodeWithArguments(node, 1201, new Object[0]);
            node.setSemanticType(SemanticType.LIST);
        }
    }

    private void acceptSemanticList(INode node) {
        if (node.getSemanticType() == SemanticType.TABLE_OF_CONTENT) {
            return;
        }
        INode accumulatedNode = StaticContainers.getAccumulatedNodeMapper().get(node);
        TableBorder tableBorder = StaticContainers.getTableBordersCollection().getTableBorder(node.getBoundingBox());
        if (accumulatedNode != null && tableBorder != null && tableBorder.getTableBorderCell(accumulatedNode.getBoundingBox()) == null) {
            return;
        }
        int childrenSize = node.getChildren().size();
        ArrayList<ListItemTextInfo> textChildrenInfo = new ArrayList<ListItemTextInfo>(childrenSize);
        ArrayList<ListItemImageInfo> imageChildrenInfo = new ArrayList<ListItemImageInfo>(childrenSize);
        ArrayList<ListItemLineArtInfo> lineArtChildrenInfo = new ArrayList<ListItemLineArtInfo>(childrenSize);
        for (INode child : node.getChildren()) {
            LineArtChunk lineArt;
            SemanticTextNode textNode;
            INode accumulatedChild;
            if (child == null || SemanticType.LIST.equals((Object)child.getSemanticType()) && child.getChildren().stream().filter(i -> SemanticType.LIST_ITEM.equals((Object)i.getSemanticType())).count() > 1L || !((accumulatedChild = StaticContainers.getAccumulatedNodeMapper().get(child)) instanceof SemanticTextNode) || (textNode = (SemanticTextNode)accumulatedChild).isSpaceNode() || textNode.isEmpty()) continue;
            TextLine line = textNode.getFirstNonSpaceLine();
            textChildrenInfo.add(new ListItemTextInfo(child.getIndex(), child.getSemanticType(), line, line.getValue().trim()));
            INode newChild = child;
            while (!newChild.getChildren().isEmpty()) {
                newChild = newChild.getChildren().get(0);
            }
            if (newChild instanceof SemanticImageNode) {
                ImageChunk image = ((SemanticImageNode)newChild).getImage();
                if (!(image.getRightX() <= line.getLeftX()) || !(image.getBoundingBox().getHeight() < 2.5 * line.getBoundingBox().getHeight())) continue;
                imageChildrenInfo.add(new ListItemImageInfo(child.getIndex(), child.getSemanticType(), image));
                continue;
            }
            if (!(newChild instanceof SemanticFigure) || !((lineArt = ((SemanticFigure)newChild).getLineArt()).getRightX() <= line.getLeftX()) || !(lineArt.getBoundingBox().getHeight() < 2.5 * line.getBoundingBox().getHeight())) continue;
            lineArtChildrenInfo.add(new ListItemLineArtInfo(child.getIndex(), child.getSemanticType(), lineArt));
        }
        if (!this.updateTreeWithOneElementList(node, textChildrenInfo) && textChildrenInfo.size() > 1) {
            ListUtils.updateTreeWithRecognizedLists(node, ListUtils.getChildrenListIntervals(ListLabelsUtils.getListItemsIntervals(textChildrenInfo), node.getChildren()));
        }
        if (imageChildrenInfo.size() > 1) {
            ListUtils.updateTreeWithRecognizedLists(node, ListUtils.getChildrenListIntervals(ListLabelsUtils.getImageListItemsIntervals(imageChildrenInfo), node.getChildren()));
        }
        if (lineArtChildrenInfo.size() > 1) {
            ListUtils.updateTreeWithRecognizedLists(node, ListUtils.getChildrenListIntervals(ListLabelsUtils.getImageListItemsIntervals(lineArtChildrenInfo), node.getChildren()));
        }
    }

    private boolean updateTreeWithOneElementList(INode node, List<ListItemTextInfo> itemsInfo) {
        if (SemanticType.LIST.equals((Object)node.getInitialSemanticType()) && (long)itemsInfo.size() == itemsInfo.stream().filter(i -> SemanticType.LIST.equals((Object)i.getSemanticType())).count() + 1L) {
            int index = IntStream.range(0, itemsInfo.size()).filter(i -> !SemanticType.LIST.equals((Object)((ListItemTextInfo)itemsInfo.get(i)).getSemanticType())).findFirst().orElse(0);
            if (ListLabelsUtils.isListLabel(itemsInfo.get(index).getListItem())) {
                int originalIndex = itemsInfo.get(index).getIndex();
                ArrayList<ListItemInfo> listItemsInfos = new ArrayList<ListItemInfo>(Collections.singletonList(itemsInfo.get(index)));
                ListUtils.updateTreeWithRecognizedList(node, new ListInterval(listItemsInfos, itemsInfo.stream().map(ListItemInfo::getIndex).filter(i -> i != originalIndex).collect(Collectors.toList()), 1));
            }
            return true;
        }
        return false;
    }

    private void checkNeighborLists(INode node) {
        INode previousChild = null;
        for (INode currentChild : node.getChildren()) {
            if (currentChild.getSemanticType() == SemanticType.LIST) {
                if (previousChild != null) {
                    INode accumulatedPreviousNode = StaticContainers.getAccumulatedNodeMapper().get(previousChild);
                    INode accumulatedNode = StaticContainers.getAccumulatedNodeMapper().get(currentChild);
                    if (accumulatedNode instanceof SemanticList && accumulatedPreviousNode instanceof SemanticList && this.checkNeighborLists(currentChild, previousChild, (SemanticList)accumulatedNode, (SemanticList)accumulatedPreviousNode)) {
                        ErrorCodes.addErrorCodeWithArguments(currentChild, 1200, new Object[0]);
                        ErrorCodes.addErrorCodeWithArguments(previousChild, 1200, new Object[0]);
                        StaticContainers.getIdMapper().put(previousChild.getRecognizedStructureId(), currentChild.getRecognizedStructureId());
                    }
                }
                previousChild = currentChild;
                continue;
            }
            previousChild = null;
        }
    }

    private boolean checkNeighborLists(INode currentNode, INode previousNode, SemanticList currentList, SemanticList previousList) {
        Set<ListInterval> listIntervals;
        int targetListItemNumber;
        ListItemInfo previousInfo;
        ListItemInfo currentInfo = currentList.getListInterval().getFirstListItemInfo();
        if (!this.checkInfos(currentNode, previousNode, currentInfo, previousInfo = previousList.getListInterval().getLastListItemInfo())) {
            return false;
        }
        if (previousInfo instanceof ListItemTextInfo && currentInfo instanceof ListItemTextInfo) {
            List<ListItemTextInfo> textChildrenInfo = this.getTextChildrenInfo(currentList, previousList);
            targetListItemNumber = textChildrenInfo.size();
            listIntervals = ListLabelsUtils.getListItemsIntervals(textChildrenInfo);
        } else if (previousInfo instanceof ListItemImageInfo && currentInfo instanceof ListItemImageInfo || previousInfo instanceof ListItemLineArtInfo && currentInfo instanceof ListItemLineArtInfo) {
            List<ListItemInfo> childrenInfo = this.getImageChildrenInfo(currentList, previousList);
            targetListItemNumber = childrenInfo.size();
            listIntervals = ListLabelsUtils.getImageListItemsIntervals(childrenInfo);
        } else {
            return false;
        }
        if (listIntervals.size() != 1) {
            return false;
        }
        ListInterval interval = listIntervals.iterator().next();
        if (interval.getNumberOfListItems() != targetListItemNumber) {
            return false;
        }
        return this.checkListItemsPositions(currentNode, previousNode, currentList, previousList);
    }

    private boolean checkInfos(INode currentNode, INode previousNode, ListItemInfo currentInfo, ListItemInfo previousInfo) {
        int i;
        for (i = 0; i < currentInfo.getIndex(); ++i) {
            if (currentNode.getChildren().get(i).getSemanticType() == SemanticType.LIST) continue;
            return false;
        }
        for (i = previousNode.getChildren().size() - 1; i > previousInfo.getIndex(); --i) {
            if (previousNode.getChildren().get(i).getSemanticType() == SemanticType.LIST) continue;
            return false;
        }
        return true;
    }

    private List<ListItemTextInfo> getTextChildrenInfo(SemanticList previousList, SemanticList currentList) {
        ArrayList<ListItemTextInfo> textChildrenInfo = new ArrayList<ListItemTextInfo>(4);
        if (previousList.getNumberOfListItems() != 1) {
            textChildrenInfo.add((ListItemTextInfo)previousList.getListInterval().getPenultListItemInfo());
        }
        textChildrenInfo.add((ListItemTextInfo)previousList.getListInterval().getLastListItemInfo());
        textChildrenInfo.add((ListItemTextInfo)currentList.getListInterval().getFirstListItemInfo());
        if (currentList.getNumberOfListItems() != 1) {
            textChildrenInfo.add((ListItemTextInfo)currentList.getListInterval().getSecondListItemInfo());
        }
        return textChildrenInfo;
    }

    private List<ListItemInfo> getImageChildrenInfo(SemanticList previousList, SemanticList currentList) {
        ArrayList<ListItemInfo> childrenInfo = new ArrayList<ListItemInfo>(4);
        if (previousList.getNumberOfListItems() != 1) {
            childrenInfo.add(previousList.getListInterval().getPenultListItemInfo());
        }
        childrenInfo.add(previousList.getListInterval().getLastListItemInfo());
        childrenInfo.add(currentList.getListInterval().getFirstListItemInfo());
        if (currentList.getNumberOfListItems() != 1) {
            childrenInfo.add(currentList.getListInterval().getSecondListItemInfo());
        }
        return childrenInfo;
    }

    private boolean checkListItemsPositions(INode currentNode, INode previousNode, SemanticList currentList, SemanticList previousList) {
        ArrayList<ListItemInfo> listItemInfos = new ArrayList<ListItemInfo>();
        ListItemInfo newInfo = ListItemInfo.createListItemInfo(previousList.getListInterval().getLastListItemInfo());
        newInfo.setIndex(0);
        listItemInfos.add(newInfo);
        newInfo = ListItemInfo.createListItemInfo(currentList.getListInterval().getFirstListItemInfo());
        newInfo.setIndex(1);
        listItemInfos.add(newInfo);
        ArrayList<INode> children = new ArrayList<INode>();
        children.add(previousNode.getChildren().get(previousNode.getChildren().size() - 1));
        children.add(currentNode.getChildren().get(0));
        ListIntervalsCollection listIntervalsCollection = new ListIntervalsCollection();
        ListUtils.checkChildrenListInterval(listIntervalsCollection, new ListInterval(listItemInfos, Collections.emptyList(), 1), children);
        SortedSet<ListInterval> listIntervals = listIntervalsCollection.getSet();
        if (listIntervals.size() != 1) {
            return false;
        }
        ListInterval interval = (ListInterval)listIntervals.iterator().next();
        return interval.getNumberOfListItems() == listItemInfos.size();
    }
}

