/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.wcag.algorithms.semanticalgorithms;

import org.verapdf.wcag.algorithms.entities.IDocument;
import org.verapdf.wcag.algorithms.entities.ITree;
import org.verapdf.wcag.algorithms.entities.tables.TableBordersCollection;
import org.verapdf.wcag.algorithms.semanticalgorithms.ContrastRatioChecker;
import org.verapdf.wcag.algorithms.semanticalgorithms.ISemanticsChecker;
import org.verapdf.wcag.algorithms.semanticalgorithms.consumers.AccumulatedNodeConsumer;
import org.verapdf.wcag.algorithms.semanticalgorithms.consumers.ClusterTableConsumer;
import org.verapdf.wcag.algorithms.semanticalgorithms.consumers.LinesPreprocessingConsumer;
import org.verapdf.wcag.algorithms.semanticalgorithms.consumers.ListDetectionConsumer;
import org.verapdf.wcag.algorithms.semanticalgorithms.consumers.SemanticDocumentPostprocessingConsumer;
import org.verapdf.wcag.algorithms.semanticalgorithms.consumers.SemanticDocumentPreprocessingConsumer;
import org.verapdf.wcag.algorithms.semanticalgorithms.consumers.TOCDetectionConsumer;
import org.verapdf.wcag.algorithms.semanticalgorithms.consumers.TableBorderConsumer;
import org.verapdf.wcag.algorithms.semanticalgorithms.consumers.TableChecker;
import org.verapdf.wcag.algorithms.semanticalgorithms.containers.StaticContainers;
import org.verapdf.wcag.algorithms.semanticalgorithms.utils.WCAGProgressStatus;

public class AccumulatedNodeSemanticChecker
implements ISemanticsChecker {
    @Override
    public void checkSemanticDocument(IDocument document, String fileName) {
        ITree tree;
        StaticContainers.updateContainers(document);
        if (!AccumulatedNodeSemanticChecker.startNextStep(WCAGProgressStatus.CONTRAST_DETECTION)) {
            return;
        }
        if (fileName != null) {
            ContrastRatioChecker contrastRatioChecker = new ContrastRatioChecker();
            contrastRatioChecker.checkDocument(document, fileName);
        }
        if ((tree = document.getTree()) == null) {
            return;
        }
        if (!AccumulatedNodeSemanticChecker.startNextStep(WCAGProgressStatus.LINES_PREPROCESSING)) {
            return;
        }
        LinesPreprocessingConsumer linesPreprocessingConsumer = new LinesPreprocessingConsumer();
        linesPreprocessingConsumer.findTableBorders();
        if (!AccumulatedNodeSemanticChecker.startNextStep(WCAGProgressStatus.DOCUMENT_PREPROCESSING)) {
            return;
        }
        SemanticDocumentPreprocessingConsumer semanticDocumentValidator = new SemanticDocumentPreprocessingConsumer();
        tree.forEach(semanticDocumentValidator);
        StaticContainers.setTableBordersCollection(new TableBordersCollection(linesPreprocessingConsumer.getTableBorders()));
        if (!AccumulatedNodeSemanticChecker.startNextStep(WCAGProgressStatus.PARAGRAPH_DETECTION)) {
            return;
        }
        AccumulatedNodeConsumer semanticDetectionValidator = new AccumulatedNodeConsumer();
        tree.forEach(semanticDetectionValidator);
        if (!AccumulatedNodeSemanticChecker.startNextStep(WCAGProgressStatus.TOC_DETECTION)) {
            return;
        }
        TOCDetectionConsumer tocDetectionConsumer = new TOCDetectionConsumer();
        tree.forEach(tocDetectionConsumer);
        if (!AccumulatedNodeSemanticChecker.startNextStep(WCAGProgressStatus.LIST_DETECTION)) {
            return;
        }
        ListDetectionConsumer listDetectionConsumer = new ListDetectionConsumer();
        tree.forEach(listDetectionConsumer);
        if (!AccumulatedNodeSemanticChecker.startNextStep(WCAGProgressStatus.TABLE_BORDER_DETECTION)) {
            return;
        }
        TableBorderConsumer tableBorderConsumer = new TableBorderConsumer();
        tableBorderConsumer.recognizeTables(tree);
        if (!AccumulatedNodeSemanticChecker.startNextStep(WCAGProgressStatus.TABLE_VALIDATION)) {
            return;
        }
        TableChecker tableChecker = new TableChecker();
        tree.forEach(tableChecker);
        if (!AccumulatedNodeSemanticChecker.startNextStep(WCAGProgressStatus.TABLE_DETECTION)) {
            return;
        }
        ClusterTableConsumer tableFinder = new ClusterTableConsumer();
        tableFinder.findTables(tree.getRoot());
        if (!AccumulatedNodeSemanticChecker.startNextStep(WCAGProgressStatus.DOCUMENT_POSTPROCESSING)) {
            return;
        }
        SemanticDocumentPostprocessingConsumer documentPostprocessingConsumer = new SemanticDocumentPostprocessingConsumer();
        documentPostprocessingConsumer.runPostprocessingChecks(tree);
        StaticContainers.setWCAGProgressStatus(null);
    }

    public static boolean startNextStep(WCAGProgressStatus status) {
        if (StaticContainers.getAbortProcessing().booleanValue()) {
            StaticContainers.setAbortProcessing(false);
            StaticContainers.setWCAGProgressStatus(null);
            return false;
        }
        StaticContainers.setWCAGProgressStatus(status);
        return true;
    }
}

