/**
 * This file is part of veraPDF wcag algorithms, a module of the veraPDF project.
 * Copyright (c) 2015, veraPDF Consortium <info@verapdf.org>
 * All rights reserved.
 *
 * veraPDF wcag algorithms is free software: you can redistribute it and/or modify
 * it under the terms of either:
 *
 * The GNU General public license GPLv3+.
 * You should have received a copy of the GNU General Public License
 * along with veraPDF wcag algorithms as the LICENSE.GPL file in the root of the source
 * tree.  If not, see http://www.gnu.org/licenses/ or
 * https://www.gnu.org/licenses/gpl-3.0.en.html.
 *
 * The Mozilla Public License MPLv2+.
 * You should have received a copy of the Mozilla Public License along with
 * veraPDF wcag algorithms as the LICENSE.MPL file in the root of the source tree.
 * If a copy of the MPL was not distributed with this file, you can obtain one at
 * http://mozilla.org/MPL/2.0/.
 */
package org.verapdf.wcag.algorithms.semanticalgorithms.utils;

public class ErrorCodes {

	//TOC/TOCI error codes
	public static final int ERROR_CODE_1000 = 1000;//TOCI doesn't have a text
	public static final int ERROR_CODE_1001 = 1001;//TOCI doesn't have a destination
	public static final int ERROR_CODE_1002 = 1002;//TOCI has a wrong page label
	public static final int ERROR_CODE_1003 = 1003;//TOCI has a bad right alignment
	public static final int ERROR_CODE_1004 = 1004;//TOCI has a bad left alignment
	public static final int ERROR_CODE_1005 = 1005;//TOCI text not found on a destination page
	public static final int ERROR_CODE_1006 = 1006;//This TOC and neighbor TOC(s) should be tagged as one TOC

	//Table error codes
	public static final int ERROR_CODE_1100 = 1100;//This cell is below than some cells in the next row
	public static final int ERROR_CODE_1101 = 1101;//This cell is above than some cells in the previous row
	public static final int ERROR_CODE_1102 = 1102;//This cell is to the right of some cells in the next column
	public static final int ERROR_CODE_1103 = 1103;//This cell is to the left of some cells in the previous column
	public static final int ERROR_CODE_1104 = 1104;//The number of rows of this table does not match the number of rows of the visual representation of this table
	public static final int ERROR_CODE_1105 = 1105;//The number of columns of this table does not match the number of columns of the visual representation of this table
	public static final int ERROR_CODE_1106 = 1106;//The row span of this table cell does not match the row span of the visual representation of this table cell
	public static final int ERROR_CODE_1107 = 1107;//The column span of this table cell does not match the column span of the visual representation of this table cell

	//List error codes
	public static final int ERROR_CODE_1200 = 1200;//This list and neighbor list(s) should be tagged as one list

}
