/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.wcag.algorithms.entities;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.verapdf.wcag.algorithms.entities.SemanticNode;
import org.verapdf.wcag.algorithms.entities.content.TextChunk;
import org.verapdf.wcag.algorithms.entities.content.TextColumn;
import org.verapdf.wcag.algorithms.entities.content.TextLine;
import org.verapdf.wcag.algorithms.entities.enums.SemanticType;
import org.verapdf.wcag.algorithms.entities.enums.TextFormat;
import org.verapdf.wcag.algorithms.entities.geometry.BoundingBox;
import org.verapdf.wcag.algorithms.semanticalgorithms.utils.TextChunkUtils;
import org.verapdf.wcag.algorithms.semanticalgorithms.utils.listLabelsDetection.ListLabelsDetectionAlgorithm;

public class SemanticTextNode
extends SemanticNode {
    private final List<TextColumn> columns;
    private Double fontWeight;
    private Double fontSize;
    private double[] textColor;
    private Double italicAngle;
    private String fontName;
    private TextFormat textFormat = TextFormat.NORMAL;
    private Double maxFontSize;
    private double[] backgroundColor;

    public SemanticTextNode(SemanticTextNode textNode) {
        super(textNode.getBoundingBox(), textNode.getInitialSemanticType(), textNode.getSemanticType());
        this.columns = new ArrayList<TextColumn>(textNode.getColumns());
        this.fontWeight = textNode.fontWeight;
        this.fontSize = textNode.fontSize;
        this.textColor = textNode.textColor;
        this.italicAngle = textNode.italicAngle;
        this.fontName = textNode.fontName;
        this.textFormat = textNode.textFormat;
        this.maxFontSize = textNode.maxFontSize;
        this.backgroundColor = textNode.backgroundColor;
    }

    public SemanticTextNode() {
        this.columns = new ArrayList<TextColumn>();
    }

    public SemanticTextNode(SemanticType initialSemanticType) {
        super(initialSemanticType);
        this.columns = new ArrayList<TextColumn>();
    }

    public SemanticTextNode(BoundingBox bbox) {
        super(bbox);
        this.columns = new ArrayList<TextColumn>();
    }

    public SemanticTextNode(BoundingBox bbox, SemanticType initialSemanticType) {
        super(bbox, initialSemanticType);
        this.columns = new ArrayList<TextColumn>();
    }

    public SemanticTextNode(BoundingBox bbox, List<TextColumn> columns) {
        super(bbox);
        this.columns = new ArrayList<TextColumn>(columns);
    }

    public SemanticTextNode(TextChunk textChunk) {
        this.columns = new ArrayList<TextColumn>();
        this.add(new TextLine(textChunk));
    }

    public SemanticTextNode(TextChunk textChunk, SemanticType initialSemanticType) {
        this(initialSemanticType);
        this.add(new TextLine(textChunk));
    }

    public void add(TextLine textLine) {
        if (this.columns.isEmpty()) {
            this.columns.add(new TextColumn(textLine));
        } else {
            this.getLastColumn().add(textLine);
        }
        this.getBoundingBox().union(textLine.getBoundingBox());
        this.updateVariables();
    }

    public void addAll(List<TextColumn> text) {
        this.columns.addAll(text);
        this.updateVariables();
    }

    private void updateVariables() {
        this.fontSize = null;
        this.fontWeight = null;
        this.textColor = null;
        this.italicAngle = null;
        this.fontName = null;
        this.maxFontSize = null;
        this.backgroundColor = null;
    }

    public List<TextColumn> getColumns() {
        return this.columns;
    }

    public int getLinesNumber() {
        int linesNumber = 0;
        for (TextColumn textColumn : this.getColumns()) {
            linesNumber += textColumn.getLinesNumber();
        }
        return linesNumber;
    }

    public int getColumnsNumber() {
        return this.getColumns().size();
    }

    public TextLine getFirstLine() {
        TextColumn firstColumn;
        if (!this.getColumns().isEmpty() && !(firstColumn = this.getFirstColumn()).getLines().isEmpty()) {
            return firstColumn.getFirstLine();
        }
        return null;
    }

    public void setFirstLine(TextLine firstLine) {
        if (!this.columns.isEmpty()) {
            this.getFirstColumn().setFirstLine(firstLine);
        } else {
            this.columns.add(new TextColumn(firstLine));
        }
        this.updateVariables();
    }

    public void setLastLine(TextLine lastLine) {
        if (!this.columns.isEmpty()) {
            this.getLastColumn().setLastLine(lastLine);
        } else {
            this.columns.add(new TextColumn(lastLine));
        }
        this.updateVariables();
    }

    public void setLastColumn(TextColumn lastColumn) {
        if (!this.columns.isEmpty()) {
            this.columns.set(this.columns.size() - 1, lastColumn);
        } else {
            this.columns.add(lastColumn);
        }
        this.updateVariables();
    }

    public TextColumn getFirstColumn() {
        List<TextColumn> columns = this.getColumns();
        if (columns.isEmpty()) {
            return null;
        }
        return columns.get(0);
    }

    public TextColumn getLastColumn() {
        List<TextColumn> columns = this.getColumns();
        if (columns.isEmpty()) {
            return null;
        }
        return columns.get(columns.size() - 1);
    }

    public TextColumn getPenultColumn() {
        List<TextColumn> columns = this.getColumns();
        if (columns.size() < 2) {
            return null;
        }
        return columns.get(columns.size() - 2);
    }

    public TextLine getSecondLine() {
        if (!this.getColumns().isEmpty()) {
            return this.getFirstColumn().getSecondLine();
        }
        return null;
    }

    public TextLine getPenultLine() {
        if (!this.getColumns().isEmpty()) {
            return this.getLastColumn().getPenultLine();
        }
        return null;
    }

    public TextLine getLastLine() {
        return this.getLastColumn().getLastLine();
    }

    public double getFirstBaseline() {
        if (!this.isEmpty()) {
            double baseLine = -1.7976931348623157E308;
            for (TextColumn column : this.getColumns()) {
                baseLine = Math.max(baseLine, column.getFirstLine().getBaseLine());
            }
            return baseLine;
        }
        return 0.0;
    }

    public double getLastBaseline() {
        if (!this.isEmpty()) {
            double baseLine = Double.MAX_VALUE;
            for (TextColumn column : this.getColumns()) {
                baseLine = Math.min(baseLine, column.getLastLine().getBaseLine());
            }
            return baseLine;
        }
        return 0.0;
    }

    public boolean isEmpty() {
        List<TextColumn> columns = this.getColumns();
        return columns.isEmpty() || columns.stream().allMatch(TextColumn::isEmpty);
    }

    public double getFontWeight() {
        if (this.fontWeight == null) {
            this.fontWeight = this.calculateFontWeight();
        }
        return this.fontWeight;
    }

    private double calculateFontWeight() {
        HashMap<Double, Double> fontWeightMap = new HashMap<Double, Double>();
        for (TextColumn column : this.getColumns()) {
            for (TextLine line : column.getLines()) {
                for (TextChunk chunk : line.getTextChunks()) {
                    if (TextChunkUtils.isWhiteSpaceChunk(chunk)) continue;
                    Double weightLength = (Double)fontWeightMap.get(chunk.getFontWeight());
                    fontWeightMap.put(chunk.getFontWeight(), (weightLength == null ? 0.0 : weightLength) + chunk.getTextLength());
                }
            }
        }
        if (!fontWeightMap.isEmpty()) {
            return (Double)fontWeightMap.entrySet().stream().max(Comparator.comparingDouble(Map.Entry::getValue)).get().getKey();
        }
        return 0.0;
    }

    public TextLine getFirstNonSpaceLine() {
        for (TextColumn column : this.getColumns()) {
            for (TextLine line : column.getLines()) {
                if (line.isEmpty() || line.isSpaceLine()) continue;
                return line;
            }
        }
        return null;
    }

    public boolean hasFullLines() {
        if (!this.isEmpty()) {
            return this.getFirstLine().isFullLine() && this.getLastLine().isFullLine();
        }
        return true;
    }

    public double getFontSize() {
        if (this.fontSize == null) {
            this.fontSize = this.calculateFontSize();
        }
        return this.fontSize;
    }

    private double calculateFontSize() {
        HashMap<Double, Double> fontSizeMap = new HashMap<Double, Double>();
        this.maxFontSize = 0.0;
        for (TextColumn column : this.getColumns()) {
            for (TextLine line : column.getLines()) {
                for (TextChunk chunk : line.getTextChunks()) {
                    if (TextChunkUtils.isWhiteSpaceChunk(chunk)) continue;
                    Double sizeLength = (Double)fontSizeMap.get(chunk.getFontSize());
                    fontSizeMap.put(chunk.getFontSize(), (sizeLength == null ? 0.0 : sizeLength) + chunk.getTextLength());
                    this.maxFontSize = Math.max(this.maxFontSize, chunk.getFontSize());
                }
            }
        }
        if (!fontSizeMap.isEmpty()) {
            return (Double)fontSizeMap.entrySet().stream().max(Comparator.comparingDouble(Map.Entry::getValue)).get().getKey();
        }
        return 0.0;
    }

    public double getItalicAngle() {
        if (this.italicAngle == null) {
            this.italicAngle = this.calculateItalicAngle();
        }
        return this.italicAngle;
    }

    private double calculateItalicAngle() {
        HashMap<Double, Double> italicAngleMap = new HashMap<Double, Double>();
        for (TextColumn column : this.getColumns()) {
            for (TextLine line : column.getLines()) {
                for (TextChunk chunk : line.getTextChunks()) {
                    if (TextChunkUtils.isWhiteSpaceChunk(chunk)) continue;
                    Double sizeLength = (Double)italicAngleMap.get(chunk.getItalicAngle());
                    italicAngleMap.put(chunk.getItalicAngle(), (sizeLength == null ? 0.0 : sizeLength) + chunk.getTextLength());
                }
            }
        }
        if (!italicAngleMap.isEmpty()) {
            return (Double)italicAngleMap.entrySet().stream().max(Comparator.comparingDouble(Map.Entry::getValue)).get().getKey();
        }
        return 0.0;
    }

    public double[] getTextColor() {
        if (this.textColor == null) {
            this.textColor = this.calculateTextColor();
        }
        return this.textColor;
    }

    private double[] calculateTextColor() {
        HashMap textColorMap = new HashMap();
        for (TextColumn column : this.getColumns()) {
            for (TextLine line : column.getLines()) {
                for (TextChunk chunk : line.getTextChunks()) {
                    List currentFontColor;
                    if (TextChunkUtils.isWhiteSpaceChunk(chunk)) continue;
                    Double fontNameLength = (Double)textColorMap.get(currentFontColor = Arrays.stream(chunk.getFontColor()).boxed().collect(Collectors.toList()));
                    textColorMap.put(currentFontColor, (fontNameLength == null ? 0.0 : fontNameLength) + chunk.getTextLength());
                }
            }
        }
        if (!textColorMap.isEmpty()) {
            return ((List)textColorMap.entrySet().stream().max(Comparator.comparingDouble(Map.Entry::getValue)).get().getKey()).stream().mapToDouble(i -> i).toArray();
        }
        return null;
    }

    public String getFontName() {
        if (this.fontName == null) {
            this.fontName = this.calculateFontName();
        }
        return this.fontName;
    }

    private String calculateFontName() {
        HashMap<String, Double> fontNameMap = new HashMap<String, Double>();
        for (TextColumn column : this.getColumns()) {
            for (TextLine line : column.getLines()) {
                for (TextChunk chunk : line.getTextChunks()) {
                    if (TextChunkUtils.isWhiteSpaceChunk(chunk)) continue;
                    Double fontNameLength = (Double)fontNameMap.get(chunk.getFontName());
                    fontNameMap.put(chunk.getFontName(), (fontNameLength == null ? 0.0 : fontNameLength) + chunk.getTextLength());
                }
            }
        }
        if (!fontNameMap.isEmpty()) {
            return (String)fontNameMap.entrySet().stream().max(Comparator.comparingDouble(Map.Entry::getValue)).get().getKey();
        }
        return "";
    }

    public TextFormat getTextFormat() {
        return this.textFormat;
    }

    public void setTextFormat(TextFormat textFormat) {
        this.textFormat = textFormat;
    }

    public Double getMaxFontSize() {
        if (this.maxFontSize == null) {
            this.calculateFontSize();
        }
        return this.maxFontSize;
    }

    public double[] getBackgroundColor() {
        if (this.backgroundColor == null) {
            this.backgroundColor = this.calculateBackgroundColor();
        }
        return this.backgroundColor;
    }

    private double[] calculateBackgroundColor() {
        HashMap backgroundColorMap = new HashMap();
        for (TextColumn column : this.getColumns()) {
            for (TextLine line : column.getLines()) {
                for (TextChunk chunk : line.getTextChunks()) {
                    List currentBackgroundColor;
                    if (TextChunkUtils.isWhiteSpaceChunk(chunk) || chunk.getBackgroundColor() == null) continue;
                    Double backgroundColorLength = (Double)backgroundColorMap.get(currentBackgroundColor = Arrays.stream(chunk.getBackgroundColor()).boxed().collect(Collectors.toList()));
                    backgroundColorMap.put(currentBackgroundColor, (backgroundColorLength == null ? 0.0 : backgroundColorLength) + chunk.getTextLength());
                }
            }
        }
        if (!backgroundColorMap.isEmpty()) {
            return ((List)backgroundColorMap.entrySet().stream().max(Comparator.comparingDouble(Map.Entry::getValue)).get().getKey()).stream().mapToDouble(i -> i).toArray();
        }
        return null;
    }

    public boolean isSpaceNode() {
        for (TextColumn column : this.getColumns()) {
            for (TextLine line : column.getLines()) {
                for (TextChunk chunk : line.getTextChunks()) {
                    if (TextChunkUtils.isWhiteSpaceChunk(chunk)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public boolean isStartsWithArabicNumber() {
        String value = this.getFirstLine().getValue().trim();
        return !value.isEmpty() && ListLabelsDetectionAlgorithm.getRegexStartLength(value, "\\d+") > 0;
    }

    public String getValue() {
        StringBuilder stringBuilder = new StringBuilder();
        for (TextColumn textColumn : this.getColumns()) {
            stringBuilder.append(textColumn);
        }
        return stringBuilder.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (!(o instanceof SemanticTextNode)) {
            return false;
        }
        SemanticTextNode that = (SemanticTextNode)o;
        return this.columns.equals(that.getColumns());
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.columns.size();
        for (TextColumn textColumn : this.columns) {
            result = 31 * result + textColumn.hashCode();
        }
        return result;
    }

    @Override
    public String toString() {
        if (this.columns.size() == 0) {
            return this.getClass().getName() + "{}";
        }
        StringBuilder result = new StringBuilder(this.getClass().getSimpleName());
        result.append("{");
        result.append(this.columns.get(0));
        for (int i = 1; i < this.columns.size(); ++i) {
            result.append(", ");
            result.append(this.columns.get(i));
        }
        result.append("}");
        return result.toString();
    }
}

