/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.wcag.algorithms.entities.tables.tableBorders;

import java.util.LinkedList;
import java.util.List;
import org.verapdf.wcag.algorithms.entities.INode;
import org.verapdf.wcag.algorithms.entities.enums.SemanticType;
import org.verapdf.wcag.algorithms.entities.geometry.BoundingBox;
import org.verapdf.wcag.algorithms.entities.geometry.MultiBoundingBox;
import org.verapdf.wcag.algorithms.entities.tables.TableToken;

public class TableBorderCell {
    private Long id;
    protected int rowNumber;
    protected int colNumber;
    protected int rowSpan;
    protected int colSpan;
    private BoundingBox boundingBox;
    private final List<TableToken> content;
    private SemanticType semanticType;
    private INode node;

    public TableBorderCell(int rowNumber, int colNumber, int rowSpan, int colSpan, Long id) {
        this.rowNumber = rowNumber;
        this.colNumber = colNumber;
        this.rowSpan = rowSpan;
        this.colSpan = colSpan;
        this.content = new LinkedList<TableToken>();
        this.id = id;
    }

    public TableBorderCell(INode node, int rowNumber, int colNumber) {
        this.node = node;
        this.rowSpan = (int)node.getAttributesDictionary().getRowSpan();
        this.colSpan = (int)node.getAttributesDictionary().getColSpan();
        this.rowNumber = rowNumber;
        this.colNumber = colNumber;
        this.boundingBox = node.getBoundingBox();
        this.content = new LinkedList<TableToken>();
    }

    public void setBoundingBox(BoundingBox boundingBox) {
        this.boundingBox = boundingBox;
    }

    public BoundingBox getBoundingBox() {
        return this.boundingBox;
    }

    public double getTopY() {
        return this.boundingBox.getTopY();
    }

    public double getBottomY() {
        return this.boundingBox.getBottomY();
    }

    public double getLeftX() {
        return this.boundingBox.getLeftX();
    }

    public double getRightX() {
        return this.boundingBox.getRightX();
    }

    public double getWidth() {
        return this.boundingBox.getWidth();
    }

    public double getHeight() {
        return this.boundingBox.getHeight();
    }

    public void addContent(TableToken token) {
        this.content.add(token);
    }

    public List<TableToken> getContent() {
        return this.content;
    }

    public SemanticType getSemanticType() {
        return this.semanticType;
    }

    public void setSemanticType(SemanticType semanticType) {
        this.semanticType = semanticType;
    }

    public INode getNode() {
        return this.node;
    }

    public void setNode(INode node) {
        this.node = node;
    }

    public int getColNumber() {
        return this.colNumber;
    }

    public int getRowNumber() {
        return this.rowNumber;
    }

    public int getRowSpan() {
        return this.rowSpan;
    }

    public int getColSpan() {
        return this.colSpan;
    }

    public BoundingBox getContentBoundingBox() {
        MultiBoundingBox boundingBox = new MultiBoundingBox();
        for (TableToken token : this.content) {
            ((BoundingBox)boundingBox).union(token.getBoundingBox());
        }
        return boundingBox;
    }

    public Long getId() {
        return this.id;
    }
}

