/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.wcag.algorithms.semanticalgorithms;

import org.verapdf.wcag.algorithms.entities.IDocument;
import org.verapdf.wcag.algorithms.entities.ITree;
import org.verapdf.wcag.algorithms.entities.tables.TableBordersCollection;
import org.verapdf.wcag.algorithms.semanticalgorithms.ISemanticsChecker;
import org.verapdf.wcag.algorithms.semanticalgorithms.consumers.AccumulatedNodeConsumer;
import org.verapdf.wcag.algorithms.semanticalgorithms.consumers.ClusterTableConsumer;
import org.verapdf.wcag.algorithms.semanticalgorithms.consumers.LinesPreprocessingConsumer;
import org.verapdf.wcag.algorithms.semanticalgorithms.consumers.ListDetectionConsumer;
import org.verapdf.wcag.algorithms.semanticalgorithms.consumers.SemanticDocumentPostprocessingConsumer;
import org.verapdf.wcag.algorithms.semanticalgorithms.consumers.SemanticDocumentPreprocessingConsumer;
import org.verapdf.wcag.algorithms.semanticalgorithms.consumers.TOCDetectionConsumer;
import org.verapdf.wcag.algorithms.semanticalgorithms.consumers.TableBorderConsumer;
import org.verapdf.wcag.algorithms.semanticalgorithms.consumers.TableChecker;
import org.verapdf.wcag.algorithms.semanticalgorithms.containers.StaticContainers;

public class AccumulatedNodeSemanticChecker
implements ISemanticsChecker {
    @Override
    public void checkSemanticDocument(IDocument document) {
        StaticContainers.updateContainers(document);
        ITree tree = document.getTree();
        LinesPreprocessingConsumer linesPreprocessingConsumer = new LinesPreprocessingConsumer();
        linesPreprocessingConsumer.findTableBorders();
        SemanticDocumentPreprocessingConsumer semanticDocumentValidator = new SemanticDocumentPreprocessingConsumer();
        tree.forEach(semanticDocumentValidator);
        StaticContainers.setTableBordersCollection(new TableBordersCollection(linesPreprocessingConsumer.getTableBorders()));
        AccumulatedNodeConsumer semanticDetectionValidator = new AccumulatedNodeConsumer();
        tree.forEach(semanticDetectionValidator);
        TOCDetectionConsumer tocDetectionConsumer = new TOCDetectionConsumer();
        tree.forEach(tocDetectionConsumer);
        ListDetectionConsumer listDetectionConsumer = new ListDetectionConsumer();
        tree.forEach(listDetectionConsumer);
        TableBorderConsumer tableBorderConsumer = new TableBorderConsumer();
        tableBorderConsumer.recognizeTables(tree);
        TableChecker tableChecker = new TableChecker();
        tree.forEach(tableChecker);
        ClusterTableConsumer tableFinder = new ClusterTableConsumer();
        tableFinder.findTables(tree.getRoot());
        SemanticDocumentPostprocessingConsumer documentPostprocessingConsumer = new SemanticDocumentPostprocessingConsumer();
        documentPostprocessingConsumer.runPostprocessingChecks(tree);
    }
}

